/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.asset;

import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.asset.AbstractAssetManager;
import com.konylabs.middleware.asset.AssetType;
import com.konylabs.middleware.asset.AssetUtil;
import com.konylabs.middleware.common.PropertiesHelper;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterCache;
import com.konylabs.middleware.registry.ModifiableAppCache;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

class SAPJcoAssetManager
extends AbstractAssetManager {
    SAPJcoAssetManager() {
    }

    @Override
    protected void loadAssetCore(String assetName, AppVersion appIdVersion, byte[] assetData, ModifiableAppCache appCache, DataAdapterCache dataAdapterCache) throws IOException {
        ApplicationMetadata appMetadata = (ApplicationMetadata)appCache.getAppMetadata(appIdVersion);
        this.loadAsset(assetName, assetData, appMetadata);
    }

    private void loadAsset(String assetName, byte[] assetData, ApplicationMetadata appMetadata) throws IOException {
        String assetNameKey = AssetUtil.removeAssetPrefix(assetName, appMetadata.getApplicationVersion().getAppId(), appMetadata.getApplicationVersion().getVersion());
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(assetData);){
            Properties properties = PropertiesHelper.loadQuietlyAndCloseStream((InputStream)inputStream);
            appMetadata.putAsset(AssetType.SAPJCO.getType(), assetNameKey, properties);
        }
    }
}

