/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.cache;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kony.mobilefabric.cache.director.CacheDirector;
import com.kony.mobilefabric.cache.director.CacheDirectorBuilder;
import com.konylabs.middleware.cache.CacheProperties;
import com.konylabs.middleware.classloader.MiddlewareClassloaderFactory;
import com.konylabs.middleware.classloader.MiddlewareClassloaderManager;
import com.konylabs.middleware.ehcache.ResultCacheImpl;
import com.konylabs.middleware.environment.Environment;
import com.konylabs.middleware.environment.EnvironmentFactory;
import com.konylabs.middleware.environment.impl.AmazonMobileFabricEnvironment;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.RequestUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CacheUtils {
    private static final Logger LOGGER = Logger.getLogger(CacheUtils.class);
    private static final Integer THREE = 3;

    public static CacheDirector createCacheDirector() {
        return CacheUtils.createCacheDirector((String)CacheProperties.CACHE_NAME.getFromConfig());
    }

    public static CacheDirector createCacheDirector(String cacheName) {
        LOGGER.debug((Object)("Invalidating and creating a new cache director with cache type " + CacheProperties.CACHE_TYPE.getFromConfig()));
        MiddlewareClassloaderManager classLoaderManager = MiddlewareClassloaderFactory.getClassLoaderManager();
        ClassLoader classloader = classLoaderManager.getMiddlewareLibClassLoader();
        Map<String, String> advancedProperties = CacheUtils.getAdvancedProperties();
        CacheDirectorBuilder cacheDirectorBuilder = new CacheDirectorBuilder().with(classloader).withProperty(CacheProperties.CACHE_TYPE.getName(), (String)CacheProperties.CACHE_TYPE.getFromConfig()).withProperty(CacheProperties.CACHE_IMPL_CLASS.getName(), (String)CacheProperties.CACHE_IMPL_CLASS.getFromConfig()).withProperty(CacheProperties.CACHE_NAME.getName(), cacheName).withProperty(CacheProperties.CACHE_URL.getName(), (String)CacheProperties.CACHE_URL.getFromConfig()).withProperty(CacheProperties.CACHE_EXPIRY.getName(), (String)CacheProperties.CACHE_EXPIRY.getFromConfig());
        if (advancedProperties != null) {
            cacheDirectorBuilder.with(advancedProperties);
        }
        CacheDirector cacheDirector = cacheDirectorBuilder.build();
        ResultCacheImpl resultCache = new ResultCacheImpl(cacheDirector);
        ResultCacheImpl.setInstance((ResultCacheImpl)resultCache);
        return cacheDirector;
    }

    static Map<String, String> getAdvancedProperties() {
        HashMap<String, String> allProperties = new HashMap<String, String>();
        try {
            String advancedProperties = ConfigUtility.getProperty((String)CacheProperties.CACHE_ADVANCED_PROPERTIES.getName());
            if (StringUtils.isNotBlank((String)advancedProperties)) {
                JsonElement configProperties;
                Map configPropertiesMap;
                JsonParser parser = new JsonParser();
                JsonObject advancedPropertiesJson = parser.parse(advancedProperties).getAsJsonObject();
                JsonElement envProperties = advancedPropertiesJson.get(CacheProperties.CACHE_ENVIRONMENT_PROPERTIES.getName());
                HashMap<String, String> envPropertiesMap = (HashMap<String, String>)new Gson().fromJson(envProperties, Map.class);
                allProperties = envPropertiesMap != null ? envPropertiesMap : allProperties;
                JsonElement edditionalProperties = advancedPropertiesJson.get(CacheProperties.CACHE_ADDITIONAL_PROPERTIES.getName());
                Map additionalPropertiesMap = (Map)new Gson().fromJson(edditionalProperties, Map.class);
                if (additionalPropertiesMap != null) {
                    allProperties.putAll(additionalPropertiesMap);
                }
                if ((configPropertiesMap = (Map)new Gson().fromJson(configProperties = advancedPropertiesJson.get(CacheProperties.CACHE_CONFIGURATION_PROPERTIES.getName()), Map.class)) != null) {
                    allProperties.putAll(configPropertiesMap);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while loading cache advanced properties.", (Throwable)e);
        }
        return allProperties;
    }

    public static CacheDirector getCacheDirector(HttpServletRequest request) {
        LOGGER.debug((Object)("Retrieving the cache director with cache type " + CacheProperties.CACHE_TYPE.getFromConfig()));
        return (CacheDirector)RequestUtils.getAttribute((HttpServletRequest)request, (String)"cacheDirector");
    }

    public static void addCacheDirectorToRequest(HttpServletRequest request, ServletContext servletContext) {
        CacheDirector cacheDirector = (CacheDirector)servletContext.getAttribute("cacheDirector");
        RequestUtils.setAttribute((HttpServletRequest)request, (String)"cacheDirector", (Object)cacheDirector);
    }

    public static Boolean isSesionDistributed() {
        return (Boolean)CacheProperties.SESSION_DISTRIBUTION.getFromConfig();
    }

    public static String getCloudMemcachedCluster() {
        String memcacheCluster = "";
        Environment environment = EnvironmentFactory.getEnvironment();
        if (environment instanceof AmazonMobileFabricEnvironment) {
            memcacheCluster = environment.getMemcacheCluster();
        }
        return memcacheCluster;
    }

    public static String getRandomHealthcheckCacheName() {
        return "kony_healthcheck_cache_" + RandomStringUtils.randomAlphanumeric((int)THREE);
    }

    private CacheUtils() {
    }
}

