/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.classloader;

import com.konylabs.middleware.classloader.MiddlewareClassloaderFactory;
import com.konylabs.middleware.classloader.MiddlewareClassloaderManager;
import com.konylabs.middleware.utilities.ConfigPathUtil;
import java.io.File;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractClassloader
implements MiddlewareClassloaderManager {
    private static final Logger logger = Logger.getLogger(MiddlewareClassloaderFactory.class);
    protected HashMap<String, Long> unloadedJars = new HashMap();
    private String defaultJarLocation = null;

    @Override
    public String getDefaultJarLocation() {
        if (StringUtils.isBlank((String)this.defaultJarLocation)) {
            this.defaultJarLocation = ConfigPathUtil.getMiddlewareHome() + "/middleware/middleware-bootconfig/customlib/";
        }
        return this.defaultJarLocation;
    }

    @Override
    public void cleanDefalutjarsPath() {
        this.cleanCustomJarsPath(this.getDefaultJarLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanCustomJarsPath(String jarsPath) {
        File file = null;
        try {
            file = new File(jarsPath);
            FileUtils.cleanDirectory((File)file);
        }
        catch (Exception e) {
            logger.debug((Object)"Exception while cleaning up the jar folders", (Throwable)e);
        }
        finally {
            this.storeUnloadedJars(file);
        }
    }

    public void storeUnloadedJars(File file) {
        File[] listFiles;
        if (file != null && (listFiles = file.listFiles()) != null) {
            for (File tempFile : listFiles) {
                this.unloadedJars.put(tempFile.getName(), tempFile.lastModified());
            }
        }
    }

    public void setDefaultJarLocation(String defaultJarLocation) {
        this.defaultJarLocation = defaultJarLocation;
    }

    public HashMap<String, Long> getUnloadedJars() {
        return this.unloadedJars;
    }

    public void setUnloadedJars(HashMap<String, Long> notAbleToDeleteFiles) {
        this.unloadedJars = notAbleToDeleteFiles;
    }

    protected String getResourcesLocation() {
        return ConfigPathUtil.getMiddlewareHome() + "/middleware/middleware-bootconfig/resources/";
    }
}

