/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.classloader;

import com.konylabs.middleware.classloader.MiddlewareClassloader;
import java.net.URL;
import org.apache.log4j.Logger;

public class IsolatedMiddlewareClassloader
extends MiddlewareClassloader {
    private static final Logger LOGGER = Logger.getLogger(IsolatedMiddlewareClassloader.class);

    public IsolatedMiddlewareClassloader(URL[] customClassPathUrls, ClassLoader parentClassLoader) {
        super(customClassPathUrls, parentClassLoader);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class<?> loadedClass = this.loadClassInCurrentClassLoader(name);
        if (loadedClass == null) {
            LOGGER.debug((Object)"Delegating the class look up to parent class loader.");
            loadedClass = super.loadClass(name);
        }
        return loadedClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> loadClassInCurrentClassLoader(String name) {
        Class<?> loadedClass = null;
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            loadedClass = this.findLoadedClass(name);
            if (loadedClass == null) {
                LOGGER.debug((Object)String.format("Loading the [%s] class for the first time.", name));
                try {
                    loadedClass = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    LOGGER.debug((Object)String.format("Look up failed in child respository for [%s] class", name));
                }
            }
        }
        return loadedClass;
    }
}

