/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.classloader;

import com.kony.adapter.annotations.connection.Resource;
import com.kony.adapter.exception.DataAdapterException;
import com.kony.dataadapter.annotations.adapter.AdapterInvocationProperties;
import com.kony.dataadapter.annotations.adapter.AnnotationAdapter;
import com.kony.dataadapter.annotations.utilities.ReflectionUtil;
import com.kony.mobilefabric.util.ReflectionUtils;
import com.konylabs.middleware.classloader.AbstractClassloader;
import com.konylabs.middleware.classloader.ClassLoaderException;
import com.konylabs.middleware.classloader.ClassLoaderProperties;
import com.konylabs.middleware.classloader.IsolatedMiddlewareClassloader;
import com.konylabs.middleware.classloader.MiddlewareClassloader;
import com.konylabs.middleware.classloader.MiddlewareClassloaderEvent;
import com.konylabs.middleware.classloader.MiddlewareClassloaderObserver;
import com.konylabs.middleware.classloader.ResourceLookup;
import com.konylabs.middleware.common.MWConstants;
import com.konylabs.middleware.connectors.ConnectorUtils;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterTask;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.utilities.ConfigUtility;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.reflections.util.ClasspathHelper;

public class MiddlewareDefaultClassloaderManager
extends AbstractClassloader {
    private static final Logger LOGGER = Logger.getLogger(MiddlewareDefaultClassloaderManager.class);
    private final Map<String, MiddlewareClassloader> middlewareClassLoaders = new HashMap<String, MiddlewareClassloader>();
    private final Map<String, Object> cache = new HashMap<String, Object>();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Map<String, AnnotationAdapter> codeBasedAdapterInstanceByBasePackage = new HashMap<String, AnnotationAdapter>();
    private final Map<String, AnnotationAdapter> codeLessAdapterInstanceByBasePackage = new HashMap<String, AnnotationAdapter>();
    private final Set<MiddlewareClassloaderObserver> observers = new CopyOnWriteArraySet<MiddlewareClassloaderObserver>();

    @Override
    public void load() throws MiddlewareException {
        this.load(this.getDefaultJarLocation());
    }

    @Override
    public void load(String path) throws MiddlewareException {
        this.readWriteLock.writeLock().lock();
        LOGGER.debug((Object)("Loading the jars to cloassloader from " + path));
        try {
            if (StringUtils.isNotBlank((String)path)) {
                this.loadJars(path, this.getClass().getClassLoader());
                this.notify(new MiddlewareClassloaderEvent(new Object()));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"error while loading class loader", (Throwable)e);
            throw new MiddlewareException(null, "Error while loading jars : ", (Throwable)e);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
        LOGGER.debug((Object)("Finished loading the jars to cloassloader from " + path));
    }

    protected void loadJars(String path, ClassLoader currentClassLoader) throws MalformedURLException {
        LOGGER.trace((Object)"inside loadJars method");
        File customLib = new File(path);
        if (customLib.exists() && customLib.isDirectory()) {
            Arrays.stream(customLib.listFiles()).forEach(module -> {
                if (module.isDirectory()) {
                    List<URL> urlList = this.getJarUrlsFromModule((File)module);
                    this.addResourcesUrlToclassloader(urlList);
                    MiddlewareClassloader classLoader = this.createDefaultMWClassLoader(urlList.toArray(new URL[0]));
                    this.middlewareClassLoaders.put(module.getName(), classLoader);
                }
            });
        }
    }

    private void addResourcesUrlToclassloader(List<URL> urlList) {
        try {
            File resourcesFolder = new File(this.getResourcesLocation());
            if (!resourcesFolder.exists()) {
                LOGGER.debug((Object)"Resource directory not created, trying to create the resource directory");
                resourcesFolder.mkdirs();
            }
            if (resourcesFolder.exists()) {
                urlList.add(resourcesFolder.toURI().toURL());
            } else {
                LOGGER.error((Object)"Unable to create the resource directory");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception occurred while adding resources folder to clasloader", (Throwable)e);
        }
    }

    @Override
    public Object getInstance(String className) throws MiddlewareException {
        return this.getInstance(className, ClassLoaderProperties.DEFAULT_MODULE_NAME.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getInstance(String className, String jarModule) throws MiddlewareException {
        this.readWriteLock.readLock().lock();
        LOGGER.trace((Object)"inside getInstance method");
        LOGGER.debug((Object)String.format("Getting the custom class [%s] with jar module [%s]", className, jarModule));
        try {
            if (StringUtils.isNotBlank((String)className)) {
                String cacheKey = jarModule + ":" + className;
                Object instance = this.cache.get(cacheKey);
                if (instance == null) {
                    LOGGER.debug((Object)"Custom class not found in the manager cache.");
                    ClassLoader classLoader = this.getMiddlewareLibClassLoader(jarModule);
                    instance = ReflectionUtils.newInstanceQuietly((ClassLoader)classLoader, (String)className);
                    if (instance == null) {
                        throw new MiddlewareException(null, "Error while instantiating class: " + className);
                    }
                    this.cache.put(cacheKey, instance);
                }
                Object object = instance;
                return object;
            }
            Object var3_4 = null;
            return var3_4;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public AnnotationAdapter getDataAdapterInstance(AdapterInvocationProperties invocationProperties) throws MiddlewareException {
        AnnotationAdapter annotationAdapter = null;
        if (invocationProperties != null) {
            try {
                annotationAdapter = new AnnotationAdapter(invocationProperties, this.getMiddlewareLibClassLoader(ClassLoaderProperties.DEFAULT_MODULE_NAME.getName()));
                annotationAdapter.addResource(Resource.ResourceType.HTTP_CLIENT, (Object)ConnectorUtils.getHttpClient());
            }
            catch (DataAdapterException e) {
                LOGGER.error((Object)"Failed to get DataAdapter instance", (Throwable)e);
                throw new MiddlewareException(null, "Failed to create DataAdapter instance", (Throwable)e);
            }
        }
        return annotationAdapter;
    }

    @Override
    public AnnotationAdapter getDataAdapterInstance(String basePackage) throws MiddlewareException {
        AnnotationAdapter annotationAdapter = null;
        if (StringUtils.isNotBlank((String)basePackage)) {
            if (!this.hasAdapterInstance(basePackage)) {
                this.readWriteLock.writeLock().lock();
                try {
                    annotationAdapter = new AnnotationAdapter(basePackage, this.getMiddlewareLibClassLoader());
                    annotationAdapter.addResource(Resource.ResourceType.HTTP_CLIENT, (Object)ConnectorUtils.getHttpClient());
                    this.putAdapterInstance(basePackage, annotationAdapter);
                }
                catch (DataAdapterException e) {
                    LOGGER.error((Object)"Failed to get DataAdapter instance", (Throwable)e);
                    throw new MiddlewareException(null, "Failed to create DataAdapter instance", (Throwable)e);
                }
                finally {
                    this.readWriteLock.writeLock().unlock();
                }
            } else {
                this.readWriteLock.readLock().lock();
                annotationAdapter = this.getAdapterInstance(basePackage);
                annotationAdapter.addResource(Resource.ResourceType.CLASS_LOADER, (Object)this.getMiddlewareLibClassLoader());
                this.readWriteLock.readLock().unlock();
            }
            return annotationAdapter;
        }
        return null;
    }

    private void putAdapterInstance(String basePackage, AnnotationAdapter annotationAdapter) {
        if (MWConstants.CODEBASED_ADAPTERS_BASEPACKAGE.contains(basePackage)) {
            this.codeBasedAdapterInstanceByBasePackage.put(basePackage, annotationAdapter);
        } else {
            this.codeLessAdapterInstanceByBasePackage.put(basePackage, annotationAdapter);
        }
    }

    private AnnotationAdapter getAdapterInstance(String basePackage) {
        AnnotationAdapter adapter = null;
        adapter = MWConstants.CODEBASED_ADAPTERS_BASEPACKAGE.contains(basePackage) ? this.codeBasedAdapterInstanceByBasePackage.get(basePackage) : this.codeLessAdapterInstanceByBasePackage.get(basePackage);
        return adapter;
    }

    private boolean hasAdapterInstance(String basePackage) {
        return this.codeBasedAdapterInstanceByBasePackage.containsKey(basePackage) || this.codeLessAdapterInstanceByBasePackage.containsKey(basePackage);
    }

    @Override
    public void clear() {
        this.clear(this.getDefaultJarLocation());
    }

    @Override
    public void clear(String jarsPath) {
        this.readWriteLock.writeLock().lock();
        LOGGER.trace((Object)"inside clear()");
        this.clearAdapters();
        this.cache.clear();
        this.closeCustomClassLoader();
        this.cleanCustomJarsPath(jarsPath);
        this.getUnloadedJars().clear();
        this.readWriteLock.writeLock().unlock();
    }

    @Override
    public void refresh() throws MiddlewareException {
        LOGGER.trace((Object)"inside refresh()");
        this.readWriteLock.writeLock().lock();
        this.clearAdapters();
        this.cache.clear();
        this.getUnloadedJars().clear();
        this.closeCustomClassLoader();
        this.cleanDefalutjarsPath();
        this.readWriteLock.writeLock().unlock();
    }

    public void closeCustomClassLoader() {
        this.middlewareClassLoaders.forEach((jarModule, classLoader) -> {
            try {
                classLoader.close();
                classLoader = null;
            }
            catch (IOException e) {
                LOGGER.error((Object)("Exception while closing the class loader of the module : " + jarModule));
            }
        });
        this.middlewareClassLoaders.clear();
    }

    @Override
    public Class<? extends Object> getClassObj(String className) throws MiddlewareException {
        this.readWriteLock.readLock().lock();
        LOGGER.trace((Object)"inside getClassObj(String className)");
        try {
            if (StringUtils.isNotBlank((String)className)) {
                Class<?> clazz = this.getMiddlewareLibClassLoader().loadClass(className);
                return clazz;
            }
            Class<? extends Object> clazz = null;
            return clazz;
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)"ClassNotFoundException while loading class loader", (Throwable)e);
            throw new MiddlewareException(null, "Error while loading class: " + className, (Throwable)e);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public ClassLoader getMiddlewareLibClassLoader() {
        LOGGER.debug((Object)"Fteching the class loader with default name.");
        return this.createDefaultClassLoaderIfAbsent();
    }

    @Override
    public ClassLoader getMiddlewareLibClassLoader(String moduleName) throws ClassLoaderException {
        LOGGER.debug((Object)String.format("Trying to fetch class loader with module name [%s]", moduleName));
        return this.getMiddlewareClassLoader(moduleName);
    }

    @Override
    public ResourceLookup getMiddlewareResourceLookup() {
        LOGGER.debug((Object)"Creating the default class loader if absent.");
        return this.createDefaultClassLoaderIfAbsent();
    }

    @Override
    public ResourceLookup getMiddlewareResourceLookup(String jarModule) throws ClassLoaderException {
        return this.getMiddlewareClassLoader(jarModule);
    }

    private void clearAdapters() {
        LOGGER.info((Object)"Clearing adapters");
        new DataAdapterTask().destroyAll(this.codeLessAdapterInstanceByBasePackage);
        this.codeLessAdapterInstanceByBasePackage.clear();
        LOGGER.info((Object)"Finished clearing adapters");
    }

    @Override
    public void register(MiddlewareClassloaderObserver observer) {
        LOGGER.trace((Object)("register DynamicClassloaderObserver: " + observer.getClass().getName()));
        this.observers.add(observer);
    }

    @Override
    public void notify(MiddlewareClassloaderEvent event) {
        for (MiddlewareClassloaderObserver observer : this.observers) {
            LOGGER.trace((Object)("notifying DynamicClassloaderObserver: " + observer.getClass().getName()));
            try {
                observer.onUpdate(event);
            }
            catch (Throwable e) {
                LOGGER.error((Object)"Exception occurred from observer while notifying", e);
            }
        }
    }

    @Override
    public void unregister(MiddlewareClassloaderObserver observer) {
        LOGGER.trace((Object)("unRegister DynamicClassloaderObserver: " + observer.getClass().getName()));
        this.observers.remove(observer);
    }

    @Override
    public List<URL> getResourceUrls(List<String> basepackageList) {
        ArrayList<URL> resourceUrlsList = new ArrayList<URL>();
        boolean isCustomScanEnabled = ConfigUtility.getBoolean((String)"kony.server.basepackage.scan", (boolean)false);
        MiddlewareClassloader classLoader = (MiddlewareClassloader)this.getMiddlewareLibClassLoader();
        if (CollectionUtils.isNotEmpty(basepackageList)) {
            basepackageList.forEach(basePackage -> resourceUrlsList.addAll(ClasspathHelper.forPackage((String)basePackage, (ClassLoader[])new ClassLoader[]{classLoader})));
        } else if (!isCustomScanEnabled) {
            URL[] resourceUrls;
            for (URL url : resourceUrls = classLoader.getResourceUrls()) {
                try {
                    File jarUri = new File(url.toURI());
                    String basePackage2 = ReflectionUtil.getBasePackage((File)jarUri);
                    resourceUrlsList.addAll(ClasspathHelper.forPackage((String)basePackage2, (ClassLoader[])new ClassLoader[]{classLoader}));
                    LOGGER.debug((Object)("Configured base package: " + basePackage2));
                }
                catch (EmptyStackException es) {
                    LOGGER.trace((Object)"Exception occurred while gettitng base package for the jar, please include source folders while building the jar", (Throwable)es);
                    resourceUrlsList.add(url);
                }
                catch (Throwable e) {
                    LOGGER.debug((Object)"Exception occurred while gettitng base package for the jar", e);
                    resourceUrlsList.add(url);
                }
            }
        }
        return resourceUrlsList;
    }

    @Override
    public void acquireReadLock() {
        this.readWriteLock.readLock().lock();
    }

    @Override
    public void releaseReadLock() {
        this.readWriteLock.readLock().unlock();
    }

    private MiddlewareClassloader createDefaultMWClassLoader(URL[] customClassPathUrls) {
        ClassLoader parentClassLoader = this.getClass().getClassLoader();
        MiddlewareClassloader customClassLoader = null;
        boolean isolatedClassLoader = (Boolean)ClassLoaderProperties.IS_ISOLATED_CLASSLOADER.getFromConfig();
        if (isolatedClassLoader) {
            LOGGER.debug((Object)("Creating Isolated Middleware Custom class loader with custom class path urls : " + customClassPathUrls));
            customClassLoader = new IsolatedMiddlewareClassloader(customClassPathUrls, parentClassLoader);
        } else {
            LOGGER.debug((Object)("Creating Middleware Custom class loader with custom class path urls : " + customClassPathUrls));
            customClassLoader = new MiddlewareClassloader(customClassPathUrls, parentClassLoader);
        }
        return customClassLoader;
    }

    private List<URL> getJarUrlsFromModule(File jarModule) {
        LOGGER.debug((Object)("Getting jars from module " + jarModule.getName()));
        ArrayList<URL> urlList = new ArrayList<URL>();
        File[] jars = jarModule.listFiles((dir, name) -> {
            if (this.getUnloadedJars().containsKey(name)) {
                if (new File(dir.getPath() + "/" + name).lastModified() == this.getUnloadedJars().get(name).longValue()) {
                    return false;
                }
                this.getUnloadedJars().remove(name);
            }
            return name.toLowerCase().endsWith(".jar");
        });
        LOGGER.debug((Object)("Below are the jars in module " + jarModule.getName()));
        Arrays.stream(jars).forEach(jar -> {
            try {
                LOGGER.debug((Object)jar.getName());
                urlList.add(jar.toURI().toURL());
            }
            catch (MalformedURLException e) {
                LOGGER.error((Object)("Exception while adding jar uri : " + jar.toURI()), (Throwable)e);
            }
        });
        LOGGER.debug((Object)("Finished getting jars from module " + jarModule.getName()));
        return urlList;
    }

    private MiddlewareClassloader getMiddlewareClassLoader(String moduleName) throws ClassLoaderException {
        if (!this.middlewareClassLoaders.containsKey(moduleName)) {
            String errorMessage = ClassLoaderException.getErrorMessage("13100", moduleName);
            throw new ClassLoaderException("13100", errorMessage);
        }
        return this.middlewareClassLoaders.get(moduleName);
    }

    private MiddlewareClassloader createDefaultClassLoaderIfAbsent() {
        return this.middlewareClassLoaders.computeIfAbsent(ClassLoaderProperties.DEFAULT_MODULE_NAME.getName(), defaultModuleName -> this.createDefaultMWClassLoader(new URL[0]));
    }
}

