/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.classloader.resources;

import com.konylabs.middleware.classloader.resources.ConfigurationProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.log4j.Logger;

public final class ConfigurationPropertiesManager {
    private static final Logger LOGGER = Logger.getLogger(ConfigurationPropertiesManager.class);

    public static void analyzeDbChangesAndUpdateConfigBean(ConfigurationProperties configProperties, Map<String, String> updatedServerConfigParams, List<String> currentServerPropsInDb, Map<String, String> updatedClientConfigParams, List<String> currentClientPropsInDb) {
        LOGGER.debug((Object)"Analyzing the DB changes for updating configuration properties..");
        currentServerPropsInDb = currentServerPropsInDb == null ? new ArrayList() : currentServerPropsInDb;
        currentClientPropsInDb = currentClientPropsInDb == null ? new ArrayList() : currentClientPropsInDb;
        List deletedServerProps = ListUtils.subtract((List)configProperties.getAllServerPropertyNames(), currentServerPropsInDb);
        List deletedClientProps = ListUtils.subtract((List)configProperties.getAllClientAppPropertyNames(), currentClientPropsInDb);
        configProperties.addOrUpdateClientAppProperties(ConfigurationPropertiesManager.modifyNullValuesToEmptyStrInMap(updatedClientConfigParams));
        configProperties.addOrUpdateServerProperties(ConfigurationPropertiesManager.modifyNullValuesToEmptyStrInMap(updatedServerConfigParams));
        configProperties.removeServerProperties(deletedServerProps);
        configProperties.removeClientAppProperties(deletedClientProps);
    }

    public static Map<String, String> modifyNullValuesToEmptyStrInMap(Map<String, String> paramMap) {
        if (MapUtils.isNotEmpty(paramMap)) {
            paramMap.forEach((k, v) -> paramMap.computeIfAbsent((String)k, e -> ""));
        }
        return paramMap;
    }

    private ConfigurationPropertiesManager() {
    }
}

