/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.cloud;

import com.kony.mobilefabric.util.JSONBuilder;
import com.konylabs.middleware.common.KHttpServletRequestWrapper;
import com.konylabs.middleware.connectors.logservice.MetricsUtils;
import com.konylabs.middleware.datasourcelogs.DiagnosticLogService;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.tenant.TenantBean;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.io.PrintWriter;
import java.util.UUID;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AbstractMetricsServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(AbstractMetricsServlet.class);
    private static final int HTTP_STATUS_OK = 200;
    private static final int HTTP_STATUS_BAD_REQUEST = 400;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String resultJson = JSONBuilder.createWith((String)"opstatus", (Object)1).toString();
        int status = 200;
        long currentTime = System.currentTimeMillis();
        if (request != null) {
            try {
                if (MetricsUtils.isMetricsEnabled().booleanValue()) {
                    DiagnosticLogService.initDeviceRequestResponseLogBean((ServletRequest)request);
                    KHttpServletRequestWrapper requestWrapper = request instanceof KHttpServletRequestWrapper ? (KHttpServletRequestWrapper)request : new KHttpServletRequestWrapper(request);
                    String konyreportingparams = requestWrapper.getParameter("konyreportingparams");
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Kony reporting params are: " + konyreportingparams));
                    }
                    if (StringUtils.isNotBlank((String)konyreportingparams)) {
                        JSONObject reportsParams = new JSONObject(konyreportingparams);
                        String remote_ip = MetricsUtils.getRemoteIp(request, reportsParams);
                        reportsParams.put("rip", (Object)remote_ip);
                        MetricsUtils.addUserAgent(request, reportsParams);
                        String request_id = request.getHeader("X-Kony-RequestId");
                        request_id = StringUtils.isNotBlank((String)request_id) ? request_id : UUID.randomUUID().toString();
                        reportsParams.put("rid", (Object)request_id);
                        Object cacheId = this.getCacheId(request);
                        if (cacheId != null) {
                            reportsParams.put("sid", cacheId);
                        } else {
                            LOGGER.debug((Object)"Cache Id is null from request for setting sid parameter.");
                        }
                        TenantBean<AppCache> tenantBean = TenantUtilities.getTenantBeanFromRequest((ServletRequest)request);
                        if ("Success".equals(this.sendMetricsParams(tenantBean, reportsParams, currentTime))) {
                            resultJson = JSONBuilder.createWith((String)"opstatus", (Object)0).add("requestId", (Object)request_id).toString();
                        }
                        JSONObject jsonRes = new JSONObject(resultJson);
                        LOGGER.debug((Object)("SQS result " + resultJson));
                        status = jsonRes != null && jsonRes.getInt("opstatus") == 0 ? 200 : 400;
                    } else {
                        LOGGER.debug((Object)"Reporting params not found in the request");
                    }
                } else {
                    resultJson = JSONBuilder.createWith((String)"opstatus", (Object)0).toString();
                    LOGGER.debug((Object)"Metrics is turned off");
                }
                LOGGER.debug((Object)("Response Status " + status));
                response.setStatus(status);
                response.setContentType("text/plain");
                response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
                response.setHeader("Pragma", "no-cache");
                PrintWriter wtr = response.getWriter();
                wtr.write(resultJson);
                wtr.close();
            }
            catch (JSONException joe) {
                LOGGER.error((Object)"JSON Error ", (Throwable)joe);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Exception while logging session tracking information ", (Throwable)e);
            }
        }
    }

    protected abstract String sendMetricsParams(TenantBean<AppCache> var1, JSONObject var2, long var3) throws Exception;

    protected abstract Object getCacheId(HttpServletRequest var1);
}

