/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.cloud;

import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ChannelServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(ChannelServlet.class);
    private static final long serialVersionUID = 1L;
    private String buildPlatforms = "";
    private static final String CLOUD_CHANNELS = "cloud-channels";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.buildPlatforms = config.getInitParameter(CLOUD_CHANNELS);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            PrintWriter pw = response.getWriter();
            pw.write("Channel HTTP GET is not supported.");
            pw.flush();
        }
        catch (Throwable t) {
            LOGGER.error((Object)"caught throwable at top level", t);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            LOGGER.debug((Object)"*********************Channel servlet called **********************************");
            PrintWriter pw = null;
            int contentLength = 0;
            if (StringUtils.isNotBlank((String)this.buildPlatforms)) {
                contentLength = this.buildPlatforms.length();
            }
            response.setStatus(200);
            response.setContentLength(contentLength);
            response.setHeader("Content-Length", contentLength + "");
            response.setContentType("application/json");
            response.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
            response.setHeader("Pragma", "no-cache");
            LOGGER.debug((Object)("Build platforms Out put *********************** " + this.buildPlatforms));
            if (StringUtils.isNotBlank((String)this.buildPlatforms)) {
                pw = response.getWriter();
                pw.write(this.buildPlatforms);
                pw.flush();
            }
        }
        catch (Throwable t) {
            LOGGER.error((Object)"Exception while getting build platforms info", t);
        }
    }
}

