/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.cloud;

import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.S3Object;
import com.kony.mobilefabric.amazonaws.AWSUtils;
import com.konylabs.middleware.common.S3Config;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.tenant.TenantBean;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public final class CloudUtils {
    private static final Logger LOGGER = Logger.getLogger(CloudUtils.class);

    public static String getDateUTCString(Date date) {
        if (date == null) {
            date = new Date();
        }
        return CloudUtils.getDateUTCString(date, null);
    }

    private static String getDateUTCString(Date date, SimpleDateFormat formatter) {
        if (date == null) {
            date = new Date();
        }
        if (formatter == null) {
            formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        TimeZone utc = TimeZone.getTimeZone("UTC");
        formatter.setTimeZone(utc);
        return formatter.format(date);
    }

    public static String getCloudSID(HttpServletRequest request, JSONObject json) throws JSONException {
        String sid = null;
        if (json.has("rsid")) {
            sid = (String)json.get("rsid");
        }
        if (StringUtils.isBlank(sid) && request.getAttribute("cacheid") != null) {
            sid = String.valueOf(request.getAttribute("cacheid"));
        }
        return sid;
    }

    public static String getS3BucketName() {
        return ConfigUtility.getProperty((String)S3Config.SERVERAPPS_AMAZON_S3_CONFIG.name());
    }

    public static boolean doesBucketExist(String bucketName, TenantBean<AppCache> tenantBean) {
        return AWSUtils.getAmazonS3ClientWithCustomConfiguration((int)Integer.parseInt(tenantBean.getEnvProperty(S3Config.MAX_RETRIES.name())), (int)Integer.parseInt(tenantBean.getEnvProperty(S3Config.CONN_TIMEOUT.name())), (int)Integer.parseInt(tenantBean.getEnvProperty(S3Config.READ_TIMEOUT.name()))).doesBucketExistV2(bucketName);
    }

    public static boolean isCustomCodeEnabled() {
        return !MiddlewareUtils.isAmazonS3Support() || !"false".equalsIgnoreCase(ConfigUtility.getProperty((String)S3Config.CUSTOM_CODE_ENABLED.name()));
    }

    public static List<String> getFoldersList(String bucketName, String prefix, String marker) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        ObjectListing objList = CloudUtils.listObjects(bucketName, prefix, marker);
        if (objList != null && objList.getCommonPrefixes() != null) {
            for (String app : objList.getCommonPrefixes()) {
                int startLength = StringUtils.isNotBlank((String)prefix) ? prefix.length() : 0;
                list.add(app.substring(startLength, app.length() - 1));
            }
        }
        return list;
    }

    public static List<String> getAppFolders(String bucketName, String prefix, String marker) {
        ObjectListing objList = CloudUtils.listObjects(bucketName, prefix, marker);
        ArrayList<String> appList = new ArrayList<String>();
        if (objList != null) {
            appList.addAll(objList.getCommonPrefixes());
        }
        return appList;
    }

    private static ObjectListing listObjects(String bucketName, String prefix, String marker) {
        ListObjectsRequest request = new ListObjectsRequest();
        request.setBucketName(bucketName);
        request.setDelimiter("/");
        if (StringUtils.isNotBlank((String)prefix)) {
            request.setPrefix(prefix);
        }
        if (StringUtils.isNotBlank((String)marker)) {
            request.setMarker(marker);
        }
        return AWSUtils.getAmazonS3Client().listObjects(request);
    }

    public static InputStream getS3ObjectIfExist(String filePath, String key) {
        try {
            S3Object s3Object = AWSUtils.getAmazonS3Client().getObject(filePath, key);
            return s3Object == null ? null : s3Object.getObjectContent();
        }
        catch (Exception e) {
            LOGGER.debug((Object)e, (Throwable)e);
            return null;
        }
    }

    private CloudUtils() {
    }
}

