/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.cloud;

import com.google.gson.Gson;
import com.kony.mobilefabric.cache.director.CacheDirector;
import com.konylabs.middleware.environment.EnvironmentProperties;
import com.konylabs.middleware.healthcheck.AppHealthCheckBean;
import com.konylabs.middleware.healthcheck.HealthCheckUtils;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.tenant.TenantBean;
import com.konylabs.middleware.utilities.BuildProperties;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;

public class HealthCheckServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(HealthCheckServlet.class);
    private static final String HEALTH_CHECK_DETAIL = "healthDetail";
    private static final String APP_HEALTH_CHECK = "applicationHealthCheck";
    private static final Map<String, Object> HC_CACHE = new HashMap<String, Object>();
    private static final String DEFAULT_CACHE_TIMEOUT_IN_MILLS = Long.toString(300000L);
    protected static final String MID_LIB_VESION = "MiddlewareLibVersion";
    protected static final String THR_LIB_VESION = "ThirdPartyLibVersion";
    protected static final String THIN_LIB_VESION = "MobileWebLibVersion";
    protected static final String MID_BUILD_VESION = "Build";
    protected static final String KEY_MID_BUILD_VESION = "Middleware Version";
    protected static final String KEY_THIN_LIB_VERSION = "ThinClient Version";
    protected static final String KEY_THR_LIB_VESION = "Third Party Jars Version";
    protected static final String KEY_MID_LIB_VESION = "Middleware Version";
    private ServletContext servletContext;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.servletContext = config.getServletContext();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.doPost(request, response);
        }
        catch (Throwable t) {
            LOGGER.error((Object)"caught throwable at top level", t);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HashMap<String, String> healthcheckMap = new HashMap<String, String>();
        String json = null;
        try {
            TenantBean<AppCache> tenantBean = TenantUtilities.getTenantBeanFromRequest((ServletRequest)request);
            boolean forceFlag = this.isHealthCheckCacheUpdate(tenantBean);
            LOGGER.debug((Object)("health check update flag " + forceFlag));
            if ("true".equalsIgnoreCase(request.getParameter("force"))) {
                forceFlag = true;
            }
            boolean ignoreQueueFlag = false;
            if ("true".equalsIgnoreCase(request.getParameter("ignorequeue"))) {
                ignoreQueueFlag = true;
            }
            if (forceFlag) {
                HC_CACHE.remove("healthcheck_app_cache");
                HealthCheckUtils healthCheckUtils = new HealthCheckUtils();
                LOGGER.debug((Object)"Post Method executing");
                CacheDirector cacheDirector = (CacheDirector)this.servletContext.getAttribute("cacheDirector");
                if (cacheDirector == null) {
                    LOGGER.error((Object)"Cache director retrieved from the servlet context is null");
                }
                List<AppHealthCheckBean> appHealthCheckBeanList = healthCheckUtils.getAppHealthCheckBeanList(tenantBean, false, ignoreQueueFlag, cacheDirector);
                Gson gson = new Gson();
                LinkedHashMap<String, Object> model = new LinkedHashMap<String, Object>();
                String appId = this.getServletContext().getInitParameter("appID");
                boolean status = healthCheckUtils.buildAndGetOverAllHealthCheckStatus(healthcheckMap, appHealthCheckBeanList);
                healthcheckMap.put("appID", appId);
                model.put(HEALTH_CHECK_DETAIL, healthcheckMap);
                if (status) {
                    model.put(APP_HEALTH_CHECK, "PASSED");
                } else {
                    model.put(APP_HEALTH_CHECK, "FAILED");
                }
                Map<String, String> versionMap = this.getVersionProperties(request.getSession().getServletContext());
                model.put("version", versionMap);
                json = gson.toJson(model);
                HC_CACHE.put("healthcheck_app_cache", json);
                HC_CACHE.put("healthcheck_lastupdate_time", System.currentTimeMillis());
            } else {
                json = (String)HC_CACHE.get("healthcheck_app_cache");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Health check from cache: " + !forceFlag + ", data: " + json));
            }
            response.setContentType("application/json");
            response.getWriter().write(json);
            response.setStatus(200);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while forming JSON for health check ", (Throwable)e);
        }
    }

    public Map<String, String> getVersionProperties(ServletContext servletContext) {
        LOGGER.debug((Object)"Finding the version properties");
        HashMap<String, String> versionMap = new HashMap<String, String>();
        Properties props = BuildProperties.getInstance(servletContext).getBuildProperties();
        if (props.getProperty(MID_LIB_VESION) != null) {
            versionMap.put("Middleware Version", props.getProperty(MID_LIB_VESION));
        } else {
            versionMap.put("Middleware Version", props.getProperty(MID_BUILD_VESION));
        }
        versionMap.put(KEY_THR_LIB_VESION, props.getProperty(THR_LIB_VESION));
        versionMap.put(KEY_THIN_LIB_VERSION, props.getProperty(THIN_LIB_VESION));
        return versionMap;
    }

    private boolean isHealthCheckCacheUpdate(TenantBean<AppCache> tenantBean) {
        String cacheDuration = tenantBean != null ? tenantBean.getEnvProperty(EnvironmentProperties.HEALTH_CHECK_CACHE_DURATION.name()) : DEFAULT_CACHE_TIMEOUT_IN_MILLS;
        long lcacheDuration = NumberUtils.toLong((String)cacheDuration);
        long lastUpdateTime = HC_CACHE.get("healthcheck_lastupdate_time") != null ? (Long)HC_CACHE.get("healthcheck_lastupdate_time") : 0L;
        long currentTime = System.currentTimeMillis();
        LOGGER.debug((Object)("Last updated time stamp difference " + (currentTime - lastUpdateTime)));
        return currentTime - lastUpdateTime >= lcacheDuration;
    }
}

