/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.common;

import com.kony.mobilefabric.cache.director.CacheDirector;
import com.kony.mobilefabric.logger.DiagnosticContext;
import com.konylabs.middleware.cache.CacheProperties;
import com.konylabs.middleware.cache.CacheUtils;
import com.konylabs.middleware.common.AbstractResponseWrapper;
import com.konylabs.middleware.common.BaseSessionManager;
import com.konylabs.middleware.common.NDCLogMaps;
import com.konylabs.middleware.core.request.AbstractRequestWrapper;
import com.konylabs.middleware.utilities.MaskUtils;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

abstract class AbstractCacheSessionManager
implements BaseSessionManager {
    private static final Logger LOGGER = Logger.getLogger(AbstractCacheSessionManager.class);
    private static final String SESSION_ISNEW = "session.isnew";
    private static final String NIL = "nil";
    private static String nodeNum = "";
    private static Integer https_port = 0;
    NDCLogMaps logMap = NDCLogMaps.getInstance();

    AbstractCacheSessionManager() {
    }

    @Override
    public void recreateCache(HttpServletRequest request) {
        HttpServletResponse response;
        if (request == null) {
            return;
        }
        CacheDirector director = CacheUtils.getCacheDirector(request);
        String tenantCacheid = (String)request.getAttribute("tenant_cacheid");
        if (tenantCacheid != null) {
            director.getCache().removeFromCache((Object)tenantCacheid);
        }
        String cacheID = this.getCacheID();
        request.setAttribute("cacheid", (Object)cacheID);
        request.setAttribute("tenant_cacheid", (Object)TenantUtilities.updateAndGetMemCacheKeyWithTenantIdentifier(cacheID));
        if (request instanceof AbstractRequestWrapper && (response = ((AbstractRequestWrapper)request).getResponse()) instanceof AbstractResponseWrapper) {
            ((AbstractResponseWrapper)response).addCacheIdCookie((AbstractRequestWrapper)request);
        }
    }

    @Override
    public String getCacheID() {
        return this.getNodeNumber() + "" + UUID.randomUUID().toString();
    }

    protected void cleanUpSession(HttpSession httpSession) {
        LOGGER.debug((Object)"Func ENTRY POINT - SessionManager.cleanUpSession()");
        if (httpSession != null) {
            LOGGER.debug((Object)"Invalidating httpsession.....");
            httpSession.invalidate();
            LOGGER.debug((Object)"httpsession Invalidation completed successfully");
        }
        httpSession = null;
        LOGGER.debug((Object)"Func EXIT POINT - SessionManager.cleanUpSession()");
    }

    @Override
    public boolean entry(AbstractRequestWrapper request) {
        LOGGER.debug((Object)"-------------------------START<SessionManager.entry()>--------------------------------");
        String cacheid = request.getCacheIdFromClient();
        if (StringUtils.isBlank((String)cacheid) || NIL.equals(cacheid)) {
            cacheid = (String)request.getAttribute("cacheid");
        }
        if (StringUtils.isBlank((String)cacheid) || NIL.equals(cacheid)) {
            LOGGER.debug((Object)"No cacheid found in the request");
            String sessionID = request.getSession(false) != null ? request.getSession(false).getId() : "";
            LOGGER.debug((Object)("Session id in the session manager entry is : " + sessionID));
            this.recreateCache((HttpServletRequest)request);
            request.setAttribute(SESSION_ISNEW, (Object)"true");
            request.setAttribute("expire.session", (Object)"false");
            MaskUtils.logDebugWithMasking((String)"Created cacheid", (String)"cacheid", (String)String.valueOf(request.getAttribute("cacheid")));
        } else {
            MaskUtils.logDebugWithMasking((String)"Cached id in request parameter", (String)"cacheid", (String)cacheid);
            boolean exists = this.populateSession((HttpServletRequest)request, cacheid);
            if (exists) {
                request.setAttribute("cacheid", (Object)cacheid);
                request.setAttribute("tenant_cacheid", (Object)TenantUtilities.updateAndGetMemCacheKeyWithTenantIdentifier(cacheid));
                request.setAttribute("expire.session", (Object)"false");
                request.setAttribute(SESSION_ISNEW, (Object)"false");
                MaskUtils.logDebugWithMasking((String)"Data exists in cache for cacheid", (String)"cacheid", (String)cacheid);
            } else {
                this.recreateCache((HttpServletRequest)request);
                request.setAttribute("expire.session", (Object)"true");
                request.setAttribute(SESSION_ISNEW, (Object)"true");
                MaskUtils.logDebugWithMasking((String)"No data exists. Created new Cache Id", (String)"cacheid", (String)String.valueOf(request.getAttribute("cacheid")));
            }
        }
        request.setAttribute("node.no", (Object)nodeNum);
        request.setAttribute("sechtno", (Object)https_port);
        LOGGER.debug((Object)"---------------------------END<SessionManager.entry()>--------------------------------");
        return true;
    }

    @Override
    public void exit(AbstractRequestWrapper request, AbstractResponseWrapper response) {
        LOGGER.debug((Object)"-------------------------START<SessionManager.exit()>--------------------------------");
        CacheDirector director = CacheUtils.getCacheDirector((HttpServletRequest)request);
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null) {
            LOGGER.debug((Object)("Session id in Session manager exit is : " + httpSession.getId()));
            response.addCacheIdCookie(request);
            Enumeration enumeration = httpSession.getAttributeNames();
            HashMap<String, Object> cMap = new HashMap<String, Object>();
            while (enumeration.hasMoreElements()) {
                String ckey = (String)enumeration.nextElement();
                Object value = httpSession.getAttribute(ckey);
                cMap.put(ckey, value);
                MaskUtils.logDebugWithMasking((String)"Populating Hashmap(memcache) with key and value from httpsession", (String)ckey, (String)String.valueOf(value));
            }
            this.store2Cache(cMap, (HttpServletRequest)request, director);
            this.cleanUpSession(httpSession);
        } else {
            String tenantCacheID = (String)request.getAttribute("tenant_cacheid");
            MaskUtils.logDebugWithMasking((String)"Session is null and deleting cacheId from memcache", (String)"cacheid", (String)tenantCacheID);
            director.getCache().removeFromCache((Object)tenantCacheID);
        }
        LOGGER.debug((Object)"-------------------------START<SessionManager.exit()>--------------------------------");
    }

    protected boolean populateSession(HttpServletRequest request, String cacheid) {
        LOGGER.debug((Object)"-------------------------START<SessionManager.populateSession()>--------------------------------");
        CacheDirector director = CacheUtils.getCacheDirector(request);
        Map cMap = null;
        boolean exists = false;
        String tenantCacheid = TenantUtilities.updateAndGetMemCacheKeyWithTenantIdentifier(cacheid);
        cMap = (Map)director.getCache().retrieveFromCache((Object)tenantCacheid);
        if (cMap != null) {
            String sessionID = request.getSession(false) != null ? request.getSession(false).getId() : "";
            LOGGER.debug((Object)("Session id before the getSession() in populateSession is : " + sessionID));
            HttpSession httpSession = request.getSession(true);
            LOGGER.debug((Object)("Session id after the getSession() in populateSession is : " + httpSession.getId()));
            if (httpSession != null) {
                Set keySet = cMap.keySet();
                for (String ckey : keySet) {
                    Object value = cMap.get(ckey);
                    httpSession.setAttribute(ckey, value);
                    MaskUtils.logDebugWithMasking((String)"Populating http session from memcache", (String)ckey, (String)String.valueOf(value));
                }
                exists = true;
            }
        }
        if (cMap != null) {
            cMap = null;
        }
        LOGGER.debug((Object)"---------------------------END<SessionManager.populateSession()>--------------------------------");
        return exists;
    }

    protected void store2Cache(Map cMap, HttpServletRequest request, CacheDirector director) {
        LOGGER.debug((Object)"Func ENTRY POINT - SessionManager.store2Cache()");
        String tenantCacheID = (String)request.getAttribute("tenant_cacheid");
        Object valueMap = director.getCache().retrieveFromCache((Object)tenantCacheID);
        if (valueMap instanceof Map) {
            cMap.putAll((Map)valueMap);
        }
        int cacheExpiry = Integer.parseInt((String)CacheProperties.CACHE_EXPIRY.getFromConfig());
        director.getCache().insertIntoCache((Object)tenantCacheID, (Object)cMap, cacheExpiry);
        LOGGER.debug((Object)"Func EXIT POINT - SessionManager.store2Cache()");
    }

    @Override
    public String getNodeNumber() {
        return nodeNum;
    }

    @Override
    public Integer getHttpsPortNumber() {
        LOGGER.debug((Object)("Https Port Value : " + https_port));
        return https_port;
    }

    @Override
    public void setHttpsPortNumber(Integer portNumber) {
        https_port = portNumber;
    }

    @Override
    public void appendSessionID(ServletRequest request) {
        if (!this.logMap.DO_NOT_LOG_LIST.contains("SESSIONID")) {
            DiagnosticContext.addCustomFields((String)"SESSIONID", (String)((String)request.getAttribute("cacheid")));
        }
    }
}

