/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.common;

import com.kony.mobilefabric.logger.DiagnosticContext;
import com.konylabs.middleware.common.NDCBuilder;
import com.konylabs.middleware.common.NDCLogMaps;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.tenant.TenantBean;
import com.konylabs.middleware.utilities.TenantUtilities;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public abstract class AbstractNDCBuilder
implements NDCBuilder {
    NDCLogMaps logMap = NDCLogMaps.getInstance();

    protected AbstractNDCBuilder() {
    }

    @Override
    public void buildNDC(ServletRequest request) {
        HttpServletRequest req = (HttpServletRequest)request;
        if (req != null) {
            HttpSession session;
            if (TenantUtilities.isMultiTenant()) {
                this.appendTenantIdentifier(request);
            }
            if ((session = req.getSession(false)) != null) {
                for (String s : this.logMap.LOG_SPECIFIC_PARAM_SESSION) {
                    Object attribute = session.getAttribute(s);
                    if (attribute == null) continue;
                    AbstractNDCBuilder.appendValue(s, attribute);
                }
            }
            for (String s : this.logMap.LOG_SPECIFIC_PARAM_REQUEST) {
                String param = req.getHeader(s);
                if (param != null) {
                    AbstractNDCBuilder.appendValue(s, param);
                    continue;
                }
                param = req.getParameter(s);
                if (param == null) continue;
                AbstractNDCBuilder.appendValue(s, param);
            }
            if (!this.logMap.DO_NOT_LOG_LIST.contains("UA")) {
                String userAgent = req.getHeader("user-agent");
                userAgent = userAgent != null ? userAgent : "NA";
                AbstractNDCBuilder.appendValue("UA", userAgent);
            }
            if (!this.logMap.DO_NOT_LOG_LIST.contains("referer")) {
                String referer = req.getHeader("referer");
                referer = referer != null ? referer : "NA";
                AbstractNDCBuilder.appendValue("referer", referer);
            }
            if (!this.logMap.DO_NOT_LOG_LIST.contains("URL")) {
                String buildurl = this.buildURL(req);
                buildurl = buildurl == null ? "" : buildurl;
                AbstractNDCBuilder.appendValue("URL", buildurl);
            }
            if (!this.logMap.DO_NOT_LOG_LIST.contains("TS")) {
                AbstractNDCBuilder.appendValue("TS", System.currentTimeMillis());
            }
            if (!this.logMap.DO_NOT_LOG_LIST.contains("REMOTEADDRESS")) {
                AbstractNDCBuilder.appendValue("REMOTEADDRESS", request.getRemoteAddr());
            }
            this.appendForwardedIP(request);
        }
    }

    protected void appendTenantIdentifier(ServletRequest request) {
        TenantBean<AppCache> tenantBean = TenantUtilities.getTenantBeanFromRequest(request);
        AbstractNDCBuilder.appendValue("TENANTENVID", tenantBean.getTenantIdentifier());
    }

    protected void appendForwardedIP(ServletRequest request) {
        if (!this.logMap.DO_NOT_LOG_LIST.contains("X-Forwarded-For")) {
            AbstractNDCBuilder.appendValue("X-Forwarded-For", this.getXForwardedIP((HttpServletRequest)request));
        }
    }

    protected String getXForwardedIP(HttpServletRequest request) {
        String xff = request.getHeader("X-Forwarded-For");
        if (xff != null) {
            return xff.split("[\\s,]+")[0];
        }
        return null;
    }

    protected static void appendValue(String key, Object value) {
        if (value == null) {
            value = "null";
        }
        DiagnosticContext.addCustomFields((String)key, (String)value.toString());
    }

    protected String buildURL(HttpServletRequest req) {
        String reqUri = req.getRequestURL().toString();
        String queryString = req.getQueryString();
        if (queryString != null) {
            reqUri = reqUri + "?" + queryString;
        }
        return reqUri;
    }
}

