/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.common;

import com.konylabs.middleware.common.IntegrationValidationListener;
import com.konylabs.middleware.core.request.AbstractRequestWrapper;
import com.konylabs.middleware.utilities.ConfigUtility;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractResponseWrapper
extends HttpServletResponseWrapper {
    HttpServletRequest request = null;

    public AbstractResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    protected abstract boolean isCookieSupported(String var1);

    protected abstract IntegrationValidationListener.CACHEID_TRANSPORT_MODE getCookieTransport();

    protected abstract boolean isEncodeable();

    public void setRequest(HttpServletRequest request) {
        this.request = request;
        request.setAttribute("isCookieSupported", (Object)this.isCookieSupported(request.getHeader("x-kony-cookie-transport-mode")));
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void addCacheIdCookie(AbstractRequestWrapper request) {
        String cacheId = (String)request.getAttribute("cacheid");
        if (!this.getResponse().isCommitted() && cacheId != null && this.isCookieSupported(request.getHeader("x-kony-cookie-transport-mode"))) {
            ((HttpServletResponse)this.getResponse()).addHeader("Set-Cookie", this.getcacheIdCookieString(cacheId));
        }
    }

    public String getcacheIdCookieString(String cacheId) {
        StringBuilder cacheIdCookie = new StringBuilder();
        cacheIdCookie.append("cacheid");
        cacheIdCookie.append("=");
        cacheIdCookie.append(cacheId);
        String contextPath = ConfigUtility.getProperty((String)"cacheid.cookie.path");
        if (StringUtils.isNotBlank((String)contextPath)) {
            cacheIdCookie.append("; Path=").append(contextPath);
        } else {
            cacheIdCookie.append("; Path=").append(this.getRequest().getContextPath());
        }
        if (ConfigUtility.getBoolean((String)"is.cacheid.cookie.secure", (boolean)false)) {
            cacheIdCookie.append("; Secure");
        }
        cacheIdCookie.append("; HttpOnly");
        return cacheIdCookie.toString();
    }
}

