/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.common;

import com.konylabs.middleware.utilities.MaskUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Logger;

public class CSRIssueLogger {
    private static final Logger LOGGER = Logger.getLogger(CSRIssueLogger.class);
    private static final String SEPARATOR = "|";
    private static final String ERROR_KEY = "e";
    private static final String DOCKET_ID = "did";
    private static final String DATE_FORMAT = "MMddyyHHmmss";
    private static CSRIssueLogger instance = new CSRIssueLogger();

    private CSRIssueLogger() {
    }

    public static void logCSRIssue(String docketID, String errorCode, String sessionID, Date timeStamp, String message) {
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        Properties prop = new Properties();
        StringBuffer buffer = new StringBuffer();
        buffer.append("MW").append(SEPARATOR);
        buffer.append(errorCode).append(SEPARATOR);
        buffer.append(sessionID).append(SEPARATOR);
        buffer.append(format.format(timeStamp)).append(SEPARATOR);
        buffer.append(message).append(SEPARATOR);
        prop.put(DOCKET_ID, docketID);
        prop.put(ERROR_KEY, buffer.toString());
        buffer.delete(0, buffer.length());
        CSRIssueLogger.logCSRIssue(prop);
    }

    private static void logCSRIssue(Properties props) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            props.store(out, "CSR generated log");
            String log = new String(out.toByteArray());
            LOGGER.error((Object)log);
        }
        catch (IOException e) {
            MaskUtils.maskTrace((String)"Error storing the csr log message", (Throwable)e);
        }
    }

    public CSRIssueLogger getInstance() {
        return instance;
    }

    public static synchronized String generateCSRID() {
        return "1";
    }
}

