/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.common;

import com.kony.mobilefabric.util.ReflectionUtils;
import com.konylabs.middleware.common.NDCBuilder;
import com.konylabs.middleware.datasourcelogs.DiagnosticLogService;
import com.konylabs.middleware.factory.KonyAppFactory;
import com.konylabs.middleware.http.HttpMethods;
import com.konylabs.middleware.utilities.ConfigUtility;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class DCFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(DCFilter.class);
    private NDCBuilder ndcBuilder;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        DiagnosticLogService.initDeviceRequestResponseLogBean(request);
        if (((HttpServletRequest)request).getMethod().equals(HttpMethods.OPTIONS.name())) {
            LOGGER.debug((Object)"Request method is OPTIONS.");
            chain.doFilter(request, response);
            return;
        }
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding("UTF-8");
        }
        if (this.ndcBuilder != null) {
            this.ndcBuilder.buildNDC(request);
            chain.doFilter(request, response);
        } else {
            LOGGER.error((Object)"Unable to create NDC for the Request, no builder configured");
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String initClass = filterConfig.getInitParameter("NDCBuilderClassName");
        if (StringUtils.isBlank((String)initClass)) {
            initClass = ConfigUtility.getProperty((String)"NDCBuilderClassName");
        }
        this.ndcBuilder = DCFilter.getCustomNDCBuilder(initClass);
        if (this.ndcBuilder == null) {
            LOGGER.debug((Object)"Loading default log init handler");
            this.ndcBuilder = KonyAppFactory.getNDCBuilder();
        }
        LOGGER.debug((Object)"NDC Filter initialized");
    }

    public void destroy() {
    }

    private static NDCBuilder getCustomNDCBuilder(String ndcBuilderClass) {
        if (StringUtils.isNotBlank((String)ndcBuilderClass)) {
            LOGGER.debug((Object)("Loading NDC Builder class  " + ndcBuilderClass));
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return (NDCBuilder)ReflectionUtils.newInstanceQuietly((ClassLoader)loader, (String)ndcBuilderClass);
        }
        return null;
    }
}

