/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.common;

import com.konylabs.middleware.common.Closer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;

public class DerbyServerLifecycleListener
implements LifecycleListener {
    public static final String DRIVER_CLASSNAME = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String SHUTDOWN_URL = "jdbc:derby:;shutdown=true";
    public static final String SHUTDOWN_MESSAGE = "Derby system shutdown.";
    public static final String MSG_INIT_SUCCESS = "Derby JDBC driver loaded successfully";
    public static final String MSG_TERM_SUCCESS = "Derby shutdown was successful.";
    public static final String MSG_TERM_FAILURE = "Unexpected Exception was caught from the Derby shutdown.";
    public static final String MSG_CONN_CLOSING_FAILURE = "Failure while closing the connection.";
    public static final String MSG_INIT_CLASS_NOT_FOUND = "The Derby JDBC driver (org.apache.derby.jdbc.EmbeddedDriver) could not be found.  Make sure the appropriate JAR files are available.";

    public void lifecycleEvent(LifecycleEvent argEvent) {
        if (argEvent.getType().equals("stop")) {
            this.shutdownCloudscape();
        }
    }

    /*
     * Loose catch block
     */
    protected void shutdownCloudscape() {
        Connection dbConnection = null;
        try {
            Class.forName(DRIVER_CLASSNAME);
            dbConnection = DriverManager.getConnection(SHUTDOWN_URL);
        }
        catch (ClassNotFoundException varException) {
            System.out.println(MSG_INIT_CLASS_NOT_FOUND);
            Closer.closeQuietly((AutoCloseable)dbConnection);
        }
        catch (SQLException varException2) {
            block7: {
                if (varException2.getMessage().equals(SHUTDOWN_MESSAGE)) {
                    System.out.println(MSG_TERM_SUCCESS);
                    break block7;
                }
                System.out.println(MSG_TERM_FAILURE);
                {
                    catch (Throwable throwable) {
                        Closer.closeQuietly(dbConnection);
                        throw throwable;
                    }
                }
            }
            Closer.closeQuietly((AutoCloseable)dbConnection);
        }
        Closer.closeQuietly((AutoCloseable)dbConnection);
    }
}

