/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.common;

import com.kony.api.gateway.util.ServiceType;
import com.kony.middleware.dbcommons.DAOFactory;
import com.kony.middleware.dbcommons.dao.NodeStatusDAO;
import com.kony.middleware.dbcommons.entity.NodeInfo;
import com.kony.mobilefabric.cache.director.CacheDirector;
import com.konylabs.devicecentral.client.ClientAPI;
import com.konylabs.middleware.cache.CacheUtils;
import com.konylabs.middleware.cache.MemcacheProperties;
import com.konylabs.middleware.classloader.MiddlewareClassloaderFactory;
import com.konylabs.middleware.classloader.MiddlewareClassloaderManager;
import com.konylabs.middleware.classloader.resources.ConfigurationProperties;
import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.common.MiddlewareValidationListener;
import com.konylabs.middleware.common.PropertiesHelper;
import com.konylabs.middleware.common.TenantEnvManagerFactory;
import com.konylabs.middleware.config.CacheObserver;
import com.konylabs.middleware.config.DBConfigSubject;
import com.konylabs.middleware.config.Observer;
import com.konylabs.middleware.connectors.ConnectorUtils;
import com.konylabs.middleware.connectors.SSLProperties;
import com.konylabs.middleware.connectors.logservice.MetricsUtils;
import com.konylabs.middleware.devicedb.TenantException;
import com.konylabs.middleware.environment.EnvironmentConfigBean;
import com.konylabs.middleware.environment.EnvironmentFactory;
import com.konylabs.middleware.environment.MiddlewareDbManager;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.jmx.mbeans.ActiveServiceCount;
import com.konylabs.middleware.monitoring.MonitoringInitializer;
import com.konylabs.middleware.monitoring.MonitoringUtils;
import com.konylabs.middleware.tenant.ReadableTenantEnvManager;
import com.konylabs.middleware.tenant.WritableTenantEnvManager;
import com.konylabs.middleware.timer.KonyTimerScheduler;
import com.konylabs.middleware.timer.NodeStatusEnum;
import com.konylabs.middleware.timer.TimerUtils;
import com.konylabs.middleware.utilities.ConfigPathUtil;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class IntegrationValidationListener
extends MiddlewareValidationListener {
    private static final Logger LOGGER = Logger.getLogger(IntegrationValidationListener.class);
    private static boolean beansInstantiated = false;
    private static boolean isCloudSupport = false;
    private static Properties migrationProperties = null;

    @Override
    public void contextInitialized(ServletContextEvent contextEvent) {
        String str;
        super.contextInitialized(contextEvent);
        ServletContext servletContext = contextEvent.getServletContext();
        String middlewareHome = ConfigPathUtil.getMiddlewareHome();
        if (MetricsUtils.isMetricsEnabled().booleanValue()) {
            if (EnvironmentFactory.getEnvironment().getQueueService() != null) {
                IntegrationValidationListener.logMessage("JMSLogService/SQSLogService initialization is successful");
            }
        } else {
            IntegrationValidationListener.logMessage("JMSLogService/SQSLogService initialization is skipped as metrics is turned off");
        }
        WritableTenantEnvManager writableTenantManager = null;
        try {
            writableTenantManager = TenantEnvManagerFactory.createTenantManager();
        }
        catch (TenantException e) {
            LOGGER.error((Object)"Error while initializing tenant manager", (Throwable)e);
        }
        CacheDirector director = CacheUtils.createCacheDirector();
        servletContext.setAttribute("cacheDirector", (Object)director);
        DBConfigSubject.getInstance().registerObserver((Observer)new CacheObserver(servletContext));
        String isServices = servletContext.getInitParameter("isServices");
        String contextPath = servletContext.getContextPath();
        boolean isWebApp = !Boolean.parseBoolean(contextEvent.getServletContext().getInitParameter("isServices"));
        ReadableTenantEnvManager readableTenantEnvManager = writableTenantManager.getReadableTenantEnvManager();
        try {
            String singleTenantIdentifier = TenantUtilities.getSingleTenantIdentifier(readableTenantEnvManager);
            MiddlewareClassloaderManager classLoaderManager = MiddlewareClassloaderFactory.getClassLoaderManager();
            classLoaderManager.load();
            if (StringUtils.isNotBlank((String)singleTenantIdentifier)) {
                classLoaderManager.getMiddlewareResourceLookup().addResource(ConfigurationProperties.class, readableTenantEnvManager.getTenantBean(singleTenantIdentifier).getConfigurationProperties());
            }
        }
        catch (MiddlewareException e) {
            LOGGER.error((Object)"Error while loading jars", (Throwable)e);
        }
        String instanceId = MonitoringUtils.getInstanceId(servletContext.getRealPath("/WEB-INF"));
        if (!TenantUtilities.isMultiTenant() && MiddlewareUtils.isServicesWar()) {
            try {
                NodeStatusDAO nodeStatusDAO = (NodeStatusDAO)DAOFactory.getDAO(NodeStatusDAO.class);
                LOGGER.debug((Object)("NodeId for this node is " + instanceId));
                NodeInfo nodeInfo = nodeStatusDAO.getNodeInfo(instanceId);
                if (nodeInfo == null) {
                    nodeInfo = new NodeInfo();
                    nodeInfo.setNodeId(instanceId);
                    nodeInfo.setPublishTimerDisabled(false);
                    nodeInfo.setNodeStatus(NodeStatusEnum.ACTIVE.name());
                    LOGGER.debug((Object)"Node registration: Registering as new node");
                    ((NodeStatusDAO)DAOFactory.getDAO(NodeStatusDAO.class)).addNodeInfo(nodeInfo);
                } else {
                    nodeInfo.setNodeStatus(NodeStatusEnum.ACTIVE.name());
                    LOGGER.debug((Object)"Node registration: Already registered, updating the status to ACTIVE");
                    ((NodeStatusDAO)DAOFactory.getDAO(NodeStatusDAO.class)).updateNodeInfo(nodeInfo);
                }
                ConfigUtility.addPropertyInMapConfiguration((String)"kony_server_node_id", (Object)instanceId);
            }
            catch (SQLException e) {
                LOGGER.error((Object)("Node registration failed for instance " + EnvironmentFactory.getEnvironment().getInstanceId()), (Throwable)e);
            }
        }
        DataSource dataSource = MiddlewareDbManager.getAdminDataSource();
        EnvironmentConfigBean configBean = new EnvironmentConfigBean(dataSource, ServiceType.INTEGRATION);
        if (dataSource != null && (MiddlewareUtils.isServicesWar() || isWebApp)) {
            TimerUtils.createBackgroundTimerAndRun(writableTenantManager, configBean, isServices, contextPath);
        }
        servletContext.setAttribute("tenantEnvManager", (Object)readableTenantEnvManager);
        IntegrationValidationListener.validateJndiDatasource();
        String middlewarePropertiesFilePath = ConfigPathUtil.getMiddlewareProperties();
        IntegrationValidationListener.logMessage("Looking up for controller.deffile property " + middlewarePropertiesFilePath);
        String controllerDef = ConfigUtility.getProperty((String)"controller.deffile");
        if (controllerDef == null) {
            IntegrationValidationListener.logMessage("FATAL ERROR : Unable to find controller.deffile property");
        } else {
            File cprops = new File(middlewareHome + "/middleware/middleware-bootconfig/" + controllerDef);
            if (!cprops.exists() || !cprops.canRead()) {
                IntegrationValidationListener.logMessage("FATAL ERROR : Unable to locate the file " + cprops.getAbsolutePath() + " . Please make sure its available and readable.");
            } else {
                IntegrationValidationListener.logMessage("Successfully validated the availability the of ControllerDef at " + cprops.getAbsolutePath());
            }
        }
        IntegrationValidationListener.logMessage("Looking up for konycentral.capabilitylist property " + middlewarePropertiesFilePath + " value : " + ConfigUtility.getProperty((String)"konycentral.capabilitylist"));
        String capabilityList = ConfigUtility.getProperty((String)"konycentral.capabilitylist");
        if (StringUtils.isBlank((String)capabilityList)) {
            IntegrationValidationListener.logMessage("FATAL ERROR : Unable to find konycentral.capabilitylist property");
        } else {
            IntegrationValidationListener.logMessage("Successfully validated the konycentral.capabilitylist");
        }
        if (CacheUtils.isSesionDistributed().booleanValue()) {
            LOGGER.debug((Object)"Session is distributed");
            String richClientDeployDir = "richclient.deploy";
            IntegrationValidationListener.logMessage("Looking up for richclient.deploy property");
            String rcdeploy = ConfigPathUtil.getMiddlewareHome() + "/" + ConfigUtility.getProperty((String)"richclient.deploy");
            String string = rcdeploy == null ? "/var/apps" : (rcdeploy = rcdeploy.endsWith(File.separator) ? rcdeploy : rcdeploy + File.separator);
            if (!isCloudSupport) {
                File cprops = new File(rcdeploy);
                if (!cprops.exists() || !cprops.canRead()) {
                    IntegrationValidationListener.logMessage("FATAL ERROR : Unable to locate the rich client deployment directory " + cprops.getAbsolutePath() + " . Rich client deployments/publishing will not work on this server.");
                } else {
                    IntegrationValidationListener.logMessage("Successfully validated the availability the of Rich client deployments/publishing directory at " + cprops.getAbsolutePath());
                }
            }
            MemcacheProperties.EXPIRY_TIME.validateConfig();
            MemcacheProperties.STORE_TIMEOUT.validateConfig();
            MemcacheProperties.STORE_ATTEMPTS.validateConfig();
            MemcacheProperties.RETRIEVE_ATTEMPTS.validateConfig();
            MemcacheProperties.NUM_OF_CLIENTS.validateConfig();
        }
        if (StringUtils.isNotBlank((String)(str = ConfigUtility.getProperty((String)"mbeans.instantiation")))) {
            IntegrationValidationListener.logMessage("Found property mbeans.instantiation successfully with value :" + str);
            beansInstantiated = Boolean.valueOf(str);
        } else {
            IntegrationValidationListener.logMessage("Unable to find property mbeans.instantiation. Defaulting to FALSE");
            beansInstantiated = false;
        }
        if (beansInstantiated) {
            try {
                MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
                ObjectName activeServiceCount = new ObjectName("com.konylabs.middleware.jmx.mbeans:type=ActiveServiceCount");
                ActiveServiceCount svcCount = new ActiveServiceCount();
                mbs.registerMBean(svcCount, activeServiceCount);
            }
            catch (MalformedObjectNameException e) {
                IntegrationValidationListener.logMessage("Exception caught while registering mbean.Message:" + e.getMessage());
            }
            catch (Exception e) {
                IntegrationValidationListener.logMessage("Exception caught while registering mbean.Message:" + e.getMessage());
            }
        }
        SSLProperties.TRUST_STORE.validateSslPathKey();
        SSLProperties.KEY_STORE.validateSslPathKey();
        SSLProperties.TLS_ALGO.validateConfig();
        ConnectorUtils.initialize();
        IntegrationValidationListener.initMigrationProperties();
        MonitoringInitializer.initialize(instanceId);
        IntegrationValidationListener.logMessage("Completed validation of middleware installation");
        LOGGER.info((Object)"Middleware is running");
        String healthCheckStr = readableTenantEnvManager.getHealthCheck(director);
        LOGGER.info((Object)("Health Check Details: " + healthCheckStr));
    }

    @Override
    public void contextDestroyed(ServletContextEvent contextEvent) {
        EnvironmentFactory.getEnvironment().getQueueService().destroy();
        this.unregisterDriverManager();
        MiddlewareClassloaderFactory.clear();
        Closer.closeQuietly((Context)MiddlewareDbManager.getInitialContext());
        ConnectorUtils.shutdown();
        ServletContext servletContext = contextEvent.getServletContext();
        CacheDirector cacheDirector = (CacheDirector)servletContext.getAttribute("cacheDirector");
        cacheDirector.destroyProvider();
        if (MiddlewareDbManager.getAdminDataSource() != null && KonyTimerScheduler.getInstance() != null) {
            String timerName = contextEvent.getServletContext().getContextPath();
            KonyTimerScheduler.getInstance().stopTimer(timerName);
        }
        try {
            LOGGER.debug((Object)"Change node status to shutdown");
            ((NodeStatusDAO)DAOFactory.getDAO(NodeStatusDAO.class)).updateNodeStatus(ConfigUtility.getProperty((String)"kony_server_node_id"), NodeStatusEnum.SHUTDOWN.name());
        }
        catch (SQLException e) {
            LOGGER.error((Object)"NodeInfo delete failed", (Throwable)e);
        }
        if (EnvironmentFactory.getEnvironment().getQueueService() != null) {
            EnvironmentFactory.getEnvironment().getQueueService().shutdownQueueClient();
        }
        LOGGER.info((Object)"Middleware is stopped");
        MonitoringInitializer.destroy();
    }

    private void unregisterDriverManager() {
        IntegrationValidationListener.logMessage("unregistering driver");
        ClassLoader applicationClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
        Enumeration<Driver> driverEnumeration = DriverManager.getDrivers();
        while (driverEnumeration.hasMoreElements()) {
            Driver driver = driverEnumeration.nextElement();
            ClassLoader driverClassLoader = driver.getClass().getClassLoader();
            if (driverClassLoader == null || !driverClassLoader.equals(applicationClassLoader)) continue;
            try {
                DriverManager.deregisterDriver(driver);
            }
            catch (SQLException e) {
                LOGGER.error((Object)"error while unregistering driver", (Throwable)e);
            }
        }
        IntegrationValidationListener.logMessage("successfully unregistered the driver");
    }

    private static void initMigrationProperties() {
        if (migrationProperties == null) {
            try {
                StringBuilder migrationPropsFilePath = new StringBuilder().append(ConfigPathUtil.getMiddlewareHome()).append("/middleware/middleware-bootconfig/").append("migration");
                File migrationFolder = new File(migrationPropsFilePath.toString());
                if (migrationFolder.exists()) {
                    FilenameFilter fileNameFilter = new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            int lastIndex;
                            String extenstion;
                            return name.lastIndexOf(46) > 0 && (extenstion = name.substring(lastIndex = name.lastIndexOf(46))).equalsIgnoreCase(".properties");
                        }
                    };
                    File[] propertyFiles = migrationFolder.listFiles(fileNameFilter);
                    ArrayList<FileInputStream> inStreamList = new ArrayList<FileInputStream>();
                    FileInputStream fis = null;
                    if (propertyFiles != null) {
                        LOGGER.debug((Object)("Found " + propertyFiles.length + "\t property files for migrating"));
                        for (File aPropFile : propertyFiles) {
                            fis = new FileInputStream(aPropFile);
                            inStreamList.add(fis);
                            LOGGER.debug((Object)("Scanning Migration properties in " + aPropFile.getAbsolutePath()));
                        }
                    } else {
                        LOGGER.debug((Object)"Migration property files are not found !");
                    }
                    if (inStreamList.size() > 0) {
                        SequenceInputStream sequenceInputStream = new SequenceInputStream(Collections.enumeration(inStreamList));
                        IntegrationValidationListener.setMigrationProperties(PropertiesHelper.loadQuietlyAndCloseStream((InputStream)sequenceInputStream));
                    }
                    LOGGER.info((Object)"Succesfully read the migration properties");
                } else {
                    LOGGER.warn((Object)("Migration properties folder not found " + migrationPropsFilePath + "...Skipping"));
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Exception occurred while reading the migrationpProperties file", (Throwable)e);
            }
        }
    }

    public static Properties getMigrationProperties() {
        return migrationProperties;
    }

    public static void setMigrationProperties(Properties properties) {
        migrationProperties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateJndiDatasource() {
        block14: {
            String jndiValidationProp = ConfigUtility.getProperty((String)"jndi.validation", (String)"false");
            IntegrationValidationListener.logMessage("jndi.validation property value in middleware.properties : " + jndiValidationProp);
            if ("true".equalsIgnoreCase(jndiValidationProp)) {
                String deviceDBDatasource = ConfigUtility.getProperty((String)"konycentral.datasource");
                IntegrationValidationListener.logMessage("konycentral.datasource is " + deviceDBDatasource);
                if (deviceDBDatasource != null) {
                    IntegrationValidationListener.logMessage("Looking up the datasource : " + deviceDBDatasource);
                    try {
                        InitialContext context = MiddlewareDbManager.getInitialContext();
                        Object obj = context.lookup(deviceDBDatasource);
                        if (obj == null) {
                            IntegrationValidationListener.logMessage("FATAL ERROR : Null data source returned for : " + deviceDBDatasource);
                            break block14;
                        }
                        IntegrationValidationListener.logMessage("Successfully located the datasource: " + deviceDBDatasource + " Object " + obj);
                        Connection connection = null;
                        try {
                            connection = ((DataSource)obj).getConnection();
                            if (connection != null) {
                                IntegrationValidationListener.logMessage("Successfully validated the connection to " + connection.getMetaData().getURL());
                                try {
                                    ClientAPI clientAPI = new ClientAPI();
                                    int deviceid = clientAPI.getDeviceIdByUserAgent("konyua");
                                    int devicercid = clientAPI.getDeviceIdByRichClientIdentifier("konyrc");
                                    if (deviceid == 2 && devicercid == 1) {
                                        IntegrationValidationListener.logMessage("Successfully validated deviceid and devicercid for the konyua and konyrc default devices");
                                        break block14;
                                    }
                                    IntegrationValidationListener.logMessage("FATAL ERROR: Incorrect deviceid (expected is 2 and actual is +" + deviceid + ") for konyua device OR in correct device rcid (expected is 1 and actual is +" + devicercid + ") for konyrc device. Since the device db is not configured correctly middleware will not serve requests for UNKNOWN devices");
                                }
                                catch (Exception e) {
                                    IntegrationValidationListener.logMessage("FATAL ERRROR : Validating the default deviceid and devicercid " + e.getMessage());
                                }
                                break block14;
                            }
                            IntegrationValidationListener.logMessage("FATAL ERRROR : Null connection returned for datasource " + deviceDBDatasource);
                        }
                        catch (SQLException e) {
                            IntegrationValidationListener.logMessage("FATAL ERRROR : Getting a valid  connection for datasource " + deviceDBDatasource + " message : " + e.getMessage());
                        }
                        finally {
                            Closer.closeQuietly((AutoCloseable)connection);
                        }
                    }
                    catch (NamingException e) {
                        IntegrationValidationListener.logMessage("FATAL ERROR : Locating the data source : " + deviceDBDatasource + " message : " + e.getMessage());
                    }
                }
            }
        }
    }

    public static enum CACHEID_TRANSPORT_MODE {
        PARAM_ONLY,
        COOKIE_ONLY,
        EITHER;

    }
}

