/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.common;

import com.kony.mobilefabric.util.ReflectionUtils;
import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.common.KonyJob;
import com.konylabs.middleware.jobs.Job;
import com.konylabs.middleware.jobs.Jobs;
import com.konylabs.middleware.utilities.ConfigPathUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;

public class JobServletContextListener
implements ServletContextListener {
    private static final Logger LOGGER = Logger.getLogger(JobServletContextListener.class);
    private final ArrayList<KonyJob> jobList = new ArrayList();
    private String mwHome = "";

    public void contextDestroyed(ServletContextEvent contextEvent) {
        if (this.jobList != null) {
            for (KonyJob job : this.jobList) {
                if (job == null) continue;
                try {
                    job.destroy();
                }
                catch (Exception ex) {
                    LOGGER.warn((Object)"error while destroying the context", (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent contextEvent) {
        this.mwHome = ConfigPathUtil.getMiddlewareHome();
        String jobFileStr = this.mwHome + "/middleware/middleware-bootconfig/jobs.xml";
        LOGGER.debug((Object)("Checking jobs in " + jobFileStr));
        FileInputStream fileStream = null;
        try {
            File jobFile = new File(jobFileStr);
            if (jobFile.exists()) {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Jobs.class});
                XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
                xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
                xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
                fileStream = new FileInputStream(jobFile);
                XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(fileStream);
                Unmarshaller um = context.createUnmarshaller();
                Jobs jobs = (Jobs)um.unmarshal(xmlStreamReader);
                if (jobs != null && jobs.getJobs() != null) {
                    for (Job job : jobs.getJobs()) {
                        String className = job.getClassName();
                        KonyJob konyJob = this.getJobService(className);
                        this.jobList.add(konyJob);
                    }
                    for (KonyJob konyJob : this.jobList) {
                        try {
                            konyJob.init(this.mwHome);
                            konyJob.execute();
                        }
                        catch (Exception ex) {
                            LOGGER.error((Object)"error while executing the jobs", (Throwable)ex);
                        }
                    }
                }
            } else {
                LOGGER.warn((Object)(jobFileStr + " File doesn't exist. No jobs are required to run"));
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"error in context initialization", (Throwable)ex);
        }
        finally {
            Closer.closeQuietly(fileStream);
        }
    }

    public KonyJob getJobService(String className) {
        return (KonyJob)ReflectionUtils.newInstanceQuietly((String)className);
    }
}

