/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.common;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.konylabs.middleware.api.TypeParser;
import com.konylabs.middleware.api.processor.impl.InputData;
import com.konylabs.middleware.api.processor.impl.PayloadUnit;
import com.konylabs.middleware.common.MiddlewareValidationListener;
import com.konylabs.middleware.config.DevicePayloadLogger;
import com.konylabs.middleware.core.request.AbstractRequestWrapper;
import com.konylabs.middleware.datasourcelogs.DeviceRequestData;
import com.konylabs.middleware.datasourcelogs.DiagnosticLogService;
import com.konylabs.middleware.request.builder.PayloadParserUtil;
import com.konylabs.middleware.utilities.EncodeUtils;
import com.konylabs.middleware.utilities.MaskUtils;
import com.konylabs.middleware.utilities.MiddlewarePayloadParsingUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.InputStreamEntity;
import org.apache.log4j.Logger;

public class KHttpServletRequestWrapper
extends AbstractRequestWrapper {
    private static final Logger LOGGER = Logger.getLogger(KHttpServletRequestWrapper.class);
    private HashMap<String, String[]> requestMap = new HashMap();
    private final Map<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private List<File> files = new ArrayList<File>();
    private Cookie[] cookies = null;
    private InputStream streamData = null;

    public KHttpServletRequestWrapper(HttpServletRequest request) {
        this(request, false);
    }

    public KHttpServletRequestWrapper(HttpServletRequest request, boolean isRequestPassthrough) {
        super(request);
        DiagnosticLogService.setDiagnosticContextInfo(request, isRequestPassthrough);
        if (isRequestPassthrough) {
            this.streamData = this.getInputStream(request);
        } else {
            this.processRequest(request);
        }
        this.cookies = request.getCookies();
    }

    public InputStream getInputStream(HttpServletRequest request) {
        InputStream inputStream = null;
        try {
            InputStreamEntity entity = new InputStreamEntity((InputStream)request.getInputStream(), (long)request.getContentLength());
            inputStream = entity.getContent();
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return inputStream;
    }

    public void processRequest(HttpServletRequest request) {
        this.parseInputStream(request);
    }

    public String getParameter(String name) {
        String[] values = this.requestMap.get(name);
        return values != null && values.length > 0 ? values[0] : null;
    }

    public Enumeration<?> getParameterNames() {
        return new Vector<String>(this.requestMap.keySet()).elements();
    }

    public String[] getParameterValues(String name) {
        return this.requestMap.get(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.requestMap;
    }

    public void cleanup() {
        if (this.requestMap != null) {
            this.requestMap.clear();
            this.requestMap = null;
        }
        if (this.files != null) {
            this.files.clear();
            this.files = null;
        }
    }

    public void setParameter(String key, String value) {
        this.requestMap.put(key, new String[]{value});
    }

    public void addParameter(String key, String value) {
        key = EncodeUtils.decode((String)key);
        value = EncodeUtils.decode((String)value);
        MaskUtils.logDebugWithMasking((String)"Param", (String)key, (String)value);
        if ("httpheaders".equalsIgnoreCase(key)) {
            Map<String, String> headers = this.extractHeaders(value);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                this.setHeader(entry.getKey(), entry.getValue());
            }
        }
        String[] values = null;
        if (this.requestMap.get(key) != null) {
            String[] currentValues = this.getParameterValues(key);
            values = new String[currentValues.length + 1];
            System.arraycopy(currentValues, 0, values, 0, currentValues.length);
            values[values.length - 1] = value;
            this.requestMap.put(key, values);
        } else {
            this.requestMap.put(key, new String[]{value});
        }
    }

    public List<File> getUploadedFiles() {
        return this.files;
    }

    public String getCacheIdFromClient() {
        String cacheId = this.getParameter("cacheid");
        MaskUtils.logDebugWithMasking((String)"Cache id returned from request parameter", (String)"cacheid", (String)cacheId);
        if (cacheId == null || cacheId.length() == 0) {
            Cookie[] cookies = this.getCookies();
            for (int i = 0; cookies != null && i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (!"cacheid".equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        MaskUtils.logDebugWithMasking((String)"Cache id returned from client", (String)"cacheid", (String)cacheId);
        return cacheId;
    }

    public void addJsonAsRequestParameters(JsonObject inputPayload) {
        Set entrySet = inputPayload.entrySet();
        for (Map.Entry entry : entrySet) {
            if (((JsonElement)entry.getValue()).isJsonNull()) continue;
            String entryValue = PayloadParserUtil.getEntryValueBasedOnType((JsonElement)entry.getValue());
            this.addParameter((String)entry.getKey(), entryValue);
        }
    }

    public void processMultipartData(HttpServletRequest request) {
        try {
            Object payloadOb = request.getAttribute("REQUEST_PAYLOAD");
            Object uploadFiles = request.getAttribute("REQUEST_PAYLOAD_UPLOAD_FILES");
            request.removeAttribute("REQUEST_PAYLOAD");
            request.removeAttribute("REQUEST_PAYLOAD_UPLOAD_FILES");
            if (payloadOb == null && uploadFiles == null) {
                BiFunction fileItemToPayloadUnitParser = TypeParser.fileItemToPayloadUnitParser();
                InputData inputData = MiddlewarePayloadParsingUtil.processMultipartData((HttpServletRequest)request, (BiFunction)fileItemToPayloadUnitParser);
                inputData.getPayloadUnitKeys().forEach(key -> {
                    PayloadUnit payloadUnit = inputData.getPayloadUnit(key);
                    if (payloadUnit.getType().equals(File.class)) {
                        File uploadedFile = (File)payloadUnit.getValue();
                        this.addParameter("data", uploadedFile.getName());
                        this.files.add((File)payloadUnit.getValue());
                    } else {
                        this.addParameter((String)key, (String)payloadUnit.getValue());
                    }
                });
                request.setAttribute("REQUEST_PAYLOAD_UPLOAD_FILES", this.files);
                if (this.requestMap != null && this.requestMap.size() > 0) {
                    StringBuilder reqParamBuilder = new StringBuilder();
                    for (Map.Entry<String, String[]> anEntry : this.requestMap.entrySet()) {
                        reqParamBuilder.append(anEntry.getKey()).append("=");
                        String[] val = anEntry.getValue();
                        if (val != null && val.length > 0) {
                            reqParamBuilder.append(anEntry.getValue()[0]);
                        }
                        reqParamBuilder.append("&");
                    }
                    if (reqParamBuilder.length() > 0) {
                        reqParamBuilder.deleteCharAt(reqParamBuilder.length() - 1);
                        this.addPayloadToRequest(request, reqParamBuilder.toString());
                        request.setAttribute("REQUEST_PAYLOAD", (Object)reqParamBuilder.toString());
                    }
                }
            } else {
                if (payloadOb != null) {
                    this.processForwardedRequestParams(request, payloadOb);
                }
                if (uploadFiles != null) {
                    this.files = (List)uploadFiles;
                }
            }
        }
        catch (Exception ex) {
            MaskUtils.maskTrace((String)"Error while storing the uploaded files in given location.", (Throwable)ex);
        }
    }

    public void getQueryStringFromRequest(HttpServletRequest request) {
        String[] parameters;
        LOGGER.debug((Object)"Reading the query string parameters from the URL");
        String queryString = request.getQueryString();
        String[] stringArray = parameters = queryString == null ? null : queryString.split("&");
        if (parameters == null || parameters.length == 0) {
            return;
        }
        StringBuilder b = new StringBuilder();
        for (String parameter : parameters) {
            String[] keyValue = parameter.split("=");
            if (keyValue.length != 2) continue;
            this.addParameter(keyValue[0], keyValue[1]);
            String keyVal = keyValue[1];
            if (MiddlewareValidationListener.getKeyList().contains(keyValue[0])) {
                keyVal = MaskUtils.maskString((String[])new String[]{keyVal});
            }
            b.append(keyValue[0]).append(": ").append(keyVal).append('\n');
        }
        ((DeviceRequestData)request.getAttribute("DeviceReqLogBean")).setQueryParams(b.toString());
    }

    public void getParameterMapFromRequest(HttpServletRequest request) {
        LOGGER.debug((Object)"Reading the request parameters");
        Map map = request.getParameterMap();
        if (map == null) {
            return;
        }
        StringBuilder b = new StringBuilder();
        for (String key : map.keySet()) {
            String[] parameterValues = request.getParameterValues(key);
            this.requestMap.put(key, parameterValues);
            String value = "";
            if (LOGGER.isDebugEnabled() || DevicePayloadLogger.isEnabled() || DiagnosticLogService.isTraceLogsEnabled()) {
                MaskUtils.logDebugWithMasking((String)"Param", (String)key, (String)value);
            }
            b.append(key).append(": ").append(value).append('\n');
        }
        this.addDeviceRequestDataToLogBean(request, b.toString());
    }

    public void setHeader(String name, String value) {
        this.headers.put(name.trim(), value);
    }

    public String getHeader(String name) {
        return this.headers.containsKey(name) ? this.headers.get(name) : super.getHeader(name);
    }

    public String getHeadersString() {
        StringBuilder b = new StringBuilder();
        for (Map.Entry<String, String> e : this.headers.entrySet()) {
            String headerKey = e.getKey();
            String headerValue = e.getValue();
            if (MiddlewareValidationListener.getKeyList().contains(headerKey)) {
                headerValue = MaskUtils.maskString((String[])new String[]{headerValue});
            }
            b.append(headerKey).append(": ").append(headerValue).append('\n');
        }
        return b.toString();
    }

    public String getHeadersAsString() {
        StringBuilder builder = new StringBuilder();
        Enumeration headerNamesEnum = super.getHeaderNames();
        if (headerNamesEnum != null) {
            ArrayList<String> headerList = Collections.list(headerNamesEnum);
            for (String headerName : headerList) {
                String headerValue = super.getHeader(headerName);
                headerValue = MaskUtils.maskParamValue((String)headerName, (String)headerValue);
                builder.append(headerName).append(": ").append(headerValue).append('\n');
            }
        }
        return builder.toString();
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public InputStream getStreamData() {
        return this.streamData;
    }

    private void processForwardedRequestParams(HttpServletRequest request, Object payload) {
        this.addPayloadToRequest(request, payload);
    }

    public void addPayloadToRequest(HttpServletRequest request, Object payload) {
        String postStream = payload.toString();
        this.addDeviceRequestDataToLogBean(request, EncodeUtils.decode((String)postStream));
        StringTokenizer st = new StringTokenizer(postStream, "&");
        while (st.hasMoreTokens()) {
            String[] keyValue;
            String token = st.nextToken();
            if (!StringUtils.isNotBlank((String)token) || (keyValue = token.split("=", 2)).length != 2) continue;
            this.addParameter(keyValue[0], keyValue[1]);
        }
    }

    void addDeviceRequestDataToLogBean(HttpServletRequest request, String postStream) {
        String postData = this.maskStream(postStream);
        DeviceRequestData deviceRequestData = (DeviceRequestData)request.getAttribute("DeviceReqLogBean");
        deviceRequestData.setBody(postData);
        deviceRequestData.setHeaders(this.getHeadersAsString());
    }

    private Map<String, String> extractHeaders(String value) {
        HashMap<String, String> map = new HashMap<String, String>(0);
        value = value.substring(1, value.length() - 1);
        String[] pairs = value.split(",");
        for (int i = 0; i < pairs.length; ++i) {
            String pair = pairs[i];
            if ((pair = pair.trim()) == null || pair.length() == 0) continue;
            String[] keyValue = pair.split("=");
            map.put(keyValue[0], keyValue[1]);
        }
        return map;
    }

    private void parseInputStream(HttpServletRequest request) {
        String payloadOb = (String)request.getAttribute("REQUEST_PAYLOAD");
        this.getQueryStringFromRequest(request);
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            this.processMultipartData(request);
        } else if (StringUtils.isNotEmpty((String)payloadOb)) {
            this.processForwardedRequestParams(request, payloadOb);
            request.removeAttribute("REQUEST_PAYLOAD");
        } else {
            this.processStreamData(request);
        }
    }

    private void processStreamData(HttpServletRequest request) {
        try (PushbackInputStream pushbackInputStream = new PushbackInputStream((InputStream)request.getInputStream());){
            int read = pushbackInputStream.read();
            if (read != -1) {
                LOGGER.debug((Object)"Reading the request input stream.");
                pushbackInputStream.unread(read);
                if (read == 123) {
                    LOGGER.debug((Object)"Reading the request input stream as raw json.");
                    JsonObject inputPayload = (JsonObject)new JsonParser().parse((Reader)new InputStreamReader((InputStream)pushbackInputStream, EncodeUtils.getEncodingOrDefault((Object)request.getCharacterEncoding())));
                    this.addJsonAsRequestParameters(inputPayload);
                    this.addDeviceRequestDataToLogBean(request, inputPayload.toString());
                } else {
                    LOGGER.debug((Object)"Reading the request input stream as key values.");
                    String requestPayload = MiddlewarePayloadParsingUtil.getStringFromInputStreamQuietly((InputStream)pushbackInputStream, (String)EncodeUtils.getEncodingOrDefault((Object)request.getCharacterEncoding()));
                    request.setAttribute("REQUEST_PAYLOAD", (Object)requestPayload);
                    this.addPayloadToRequest(request, requestPayload);
                }
            } else {
                LOGGER.debug((Object)"reading the request.getParameterMap");
                this.getParameterMapFromRequest(request);
            }
        }
        catch (IOException ex) {
            LOGGER.debug((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private String maskStream(String postStream) {
        for (String key : MiddlewareValidationListener.getKeyList()) {
            Pattern passwordPattern = Pattern.compile(key + "=[^&]+");
            Matcher matcher = passwordPattern.matcher(postStream);
            postStream = matcher.replaceAll(key + "=****");
        }
        return postStream;
    }
}

