/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.common;

import com.konylabs.middleware.common.AbstractResponseWrapper;
import com.konylabs.middleware.common.IntegrationValidationListener;
import com.konylabs.middleware.utilities.ConfigUtility;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class KHttpServletResponseWrapper
extends AbstractResponseWrapper {
    private static final Logger LOGGER = Logger.getLogger(KHttpServletResponseWrapper.class);

    public KHttpServletResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public String encodeURL(String urlStr) {
        String cacheId = (String)this.getRequest().getAttribute("cacheid");
        String cacheIdEncodedURL = this.encodeCacheId(urlStr, cacheId);
        LOGGER.debug((Object)("Cached encoded URL: " + cacheIdEncodedURL));
        return super.encodeURL(cacheIdEncodedURL);
    }

    public String encodeRedirectURL(String urlStr) {
        String cacheId = (String)this.getRequest().getAttribute("cacheid");
        String cacheIdEncodedURL = this.encodeCacheId(urlStr, cacheId);
        LOGGER.debug((Object)("Cached encoded URL: " + cacheIdEncodedURL));
        return super.encodeRedirectURL(cacheIdEncodedURL);
    }

    @Override
    protected boolean isCookieSupported(String cookieTransportMode) {
        IntegrationValidationListener.CACHEID_TRANSPORT_MODE transportMode = null;
        if (StringUtils.isNotBlank((String)cookieTransportMode)) {
            transportMode = IntegrationValidationListener.CACHEID_TRANSPORT_MODE.valueOf(cookieTransportMode);
        }
        if (transportMode == null) {
            transportMode = this.getCookieTransport();
        }
        switch (transportMode) {
            case PARAM_ONLY: {
                return false;
            }
            case COOKIE_ONLY: {
                return true;
            }
            case EITHER: {
                if (this.getRequest().getParameter("cacheid") == null) {
                    Cookie[] cookies = this.getRequest().getCookies();
                    if (cookies != null) {
                        for (Cookie cookie : cookies) {
                            if (!"cacheid".equalsIgnoreCase(cookie.getName())) continue;
                            return true;
                        }
                        break;
                    }
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    @Override
    protected IntegrationValidationListener.CACHEID_TRANSPORT_MODE getCookieTransport() {
        String cookieModeStr = ConfigUtility.getProperty((String)"cacheid.transport");
        if (StringUtils.isNotBlank((String)cookieModeStr)) {
            try {
                return IntegrationValidationListener.CACHEID_TRANSPORT_MODE.valueOf(cookieModeStr);
            }
            catch (Exception e) {
                LOGGER.error((Object)("Incorrect value specified for the property cacheid.transport valid values are: " + (Object)((Object)IntegrationValidationListener.CACHEID_TRANSPORT_MODE.COOKIE_ONLY) + " or " + (Object)((Object)IntegrationValidationListener.CACHEID_TRANSPORT_MODE.PARAM_ONLY) + " or " + (Object)((Object)IntegrationValidationListener.CACHEID_TRANSPORT_MODE.EITHER)));
            }
        }
        return IntegrationValidationListener.CACHEID_TRANSPORT_MODE.PARAM_ONLY;
    }

    @Override
    protected boolean isEncodeable() {
        boolean isEncodeable = true;
        switch (this.getCookieTransport()) {
            case PARAM_ONLY: {
                isEncodeable = true;
                break;
            }
            case COOKIE_ONLY: {
                isEncodeable = false;
                break;
            }
            case EITHER: {
                Cookie[] cookies = this.getRequest().getCookies();
                isEncodeable = cookies == null || cookies.length == 0;
            }
        }
        LOGGER.debug((Object)("Cache id will be transferred as parameter: " + isEncodeable));
        return isEncodeable;
    }

    protected String encodeCacheId(String urlStr, String cacheId) {
        StringBuilder url = new StringBuilder(urlStr);
        if (cacheId != null && this.isEncodeable()) {
            if (url.indexOf("?") > 0) {
                if (url.indexOf("cacheid") != -1) {
                    int cacheIdParamIndex = url.indexOf("cacheid");
                    int fromIndex = cacheIdParamIndex + "cacheid".length() + 1;
                    int endIndex = url.indexOf("&", fromIndex) > 0 ? url.indexOf("&", fromIndex) : url.length();
                    url.replace(fromIndex, endIndex, cacheId);
                } else {
                    url.append("&").append("cacheid").append("=").append(cacheId);
                }
            } else {
                url.append("?").append("cacheid").append("=").append(cacheId);
            }
        }
        return url.toString();
    }
}

