/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.common;

import com.konylabs.middleware.cache.CacheUtils;
import com.konylabs.middleware.common.AbstractResponseWrapper;
import com.konylabs.middleware.common.BaseSessionManager;
import com.konylabs.middleware.common.CookieServletRequestWrapper;
import com.konylabs.middleware.common.CookieServletResponseWrapper;
import com.konylabs.middleware.common.FilterActionData;
import com.konylabs.middleware.common.IKonyDCFilterAction;
import com.konylabs.middleware.common.KHttpServletRequestWrapper;
import com.konylabs.middleware.common.KHttpServletResponseWrapper;
import com.konylabs.middleware.common.NDCLogMaps;
import com.konylabs.middleware.core.request.AbstractRequestWrapper;
import com.konylabs.middleware.factory.KonyAppFactory;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class KonyDCFilterActionImpl
implements IKonyDCFilterAction {
    private static final Logger LOGGER = Logger.getLogger(KonyDCFilterActionImpl.class);
    NDCLogMaps logMap = NDCLogMaps.getInstance();

    @Override
    public void preDCFilterProcessing() {
    }

    @Override
    public void postDCFilterProcessing() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doChainDCFilter(FilterActionData filterActionData) throws IOException, ServletException {
        ServletRequest request = filterActionData.getRequest();
        ServletResponse response = filterActionData.getResponse();
        FilterChain chain = filterActionData.getChain();
        AbstractRequestWrapper requestWrapper = request instanceof KHttpServletRequestWrapper ? (KHttpServletRequestWrapper)request : new CookieServletRequestWrapper((HttpServletRequest)request);
        AbstractResponseWrapper responseWrapper = response instanceof KHttpServletResponseWrapper ? (KHttpServletResponseWrapper)response : new CookieServletResponseWrapper((HttpServletResponse)response);
        responseWrapper.setRequest((HttpServletRequest)requestWrapper);
        requestWrapper.setResponse((HttpServletResponse)responseWrapper);
        BaseSessionManager sessionManager = KonyAppFactory.getSessionManagerInstance();
        if (!sessionManager.entry(requestWrapper)) {
            LOGGER.error((Object)"Unable to serve any requests due to previous errors");
            return;
        }
        if (CacheUtils.isSesionDistributed().booleanValue()) {
            LOGGER.debug((Object)"Session is distributed");
            HttpSession session = requestWrapper.getSession(false);
            if (session != null) {
                requestWrapper.setAttribute("SESSIONID", (Object)session.getId());
            }
        }
        sessionManager.appendSessionID((ServletRequest)requestWrapper);
        try {
            chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
        }
        finally {
            try {
                sessionManager.exit(requestWrapper, responseWrapper);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error while trying to exit memcache session.", (Throwable)e);
            }
            finally {
                requestWrapper.cleanup();
            }
        }
        LOGGER.debug((Object)("***********port at Exit Point:" + request.getServerPort()));
    }
}

