/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.common;

import com.kony.api.gateway.GatewayException;
import com.kony.mobilefabric.cache.director.CacheDirector;
import com.kony.mobilefabric.logger.DiagnosticContext;
import com.kony.mobilefabric.timer.FabricTimer;
import com.kony.mobilefabric.timer.FabricTimerCategory;
import com.konylabs.commons.xss.XSSValidator;
import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.datasourcelogs.DeviceRequestData;
import com.konylabs.middleware.datasourcelogs.DiagnosticLogService;
import com.konylabs.middleware.exceptions.ExceptionUtil;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.http.HttpMethods;
import com.konylabs.middleware.mbaas.MBAASGateWayWrapper;
import com.konylabs.middleware.metrics.MetricsBean;
import com.konylabs.middleware.monitoring.MonitoringUtils;
import com.konylabs.middleware.registry.AppCache;
import com.konylabs.middleware.request.HttpIntegrityInfo;
import com.konylabs.middleware.request.builder.Authenticator;
import com.konylabs.middleware.request.builder.AuthorizationException;
import com.konylabs.middleware.request.builder.RequestContext;
import com.konylabs.middleware.request.builder.UriContext;
import com.konylabs.middleware.request.parser.UriParser;
import com.konylabs.middleware.request.validator.RequestValidator;
import com.konylabs.middleware.servlet.filters.IntegrationCustomFilter;
import com.konylabs.middleware.tenant.TenantBean;
import com.konylabs.middleware.utilities.IntegrityUtils;
import com.konylabs.middleware.utilities.LoggerUtility;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import com.konylabs.middleware.utilities.RequestUtils;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@IntegrationCustomFilter(filterOrder=30, servletNames={"MWServlet", "AppServices", "AppMetadataServices"}, defaultFilter=true)
public class MWValidationAndAuthenticationFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(MWValidationAndAuthenticationFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        if (HttpMethods.OPTIONS.nameEquals(httpServletRequest.getMethod())) {
            return;
        }
        DiagnosticLogService.initDeviceRequestResponseLogBean(servletRequest);
        if (httpServletRequest.getCharacterEncoding() == null) {
            httpServletRequest.setCharacterEncoding("UTF-8");
        }
        httpServletResponse.setCharacterEncoding(httpServletRequest.getCharacterEncoding());
        try {
            DiagnosticContext.addFromRequest((ServletRequest)httpServletRequest);
            this.doFilterCore(chain, httpServletRequest, httpServletResponse);
        }
        catch (AuthorizationException e) {
            LOGGER.error((Object)"AuthorizationException occurred in XSS Filter", (Throwable)((Object)e));
            Result errorResult = e.prepareErrorResult();
            ExceptionUtil.prepareResult((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Result)errorResult);
        }
        catch (GatewayException e) {
            LOGGER.error((Object)"GatewayException occurred in XSS Filter", (Throwable)e);
            String requestId = MiddlewareUtils.getRequestId(httpServletRequest);
            Result errorResult = ExceptionUtil.getExceptionresult((HttpServletResponse)httpServletResponse, (String)requestId, (GatewayException)e);
            ExceptionUtil.prepareResult((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, (Result)errorResult);
        }
        catch (MiddlewareException e) {
            LOGGER.error((Object)"MiddlewareException occurred in XSS Filter", (Throwable)e);
            String errorMsg = ObjectServiceUtil.getErrorMsgByMiddlewareException(e);
            ObjectServiceUtil.sendResponse(errorMsg, httpServletResponse);
        }
        catch (IOException | RuntimeException | ServletException e) {
            LOGGER.error((Object)"Failed to process request", e);
            httpServletResponse.setStatus(500);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to process request -- XSS Filter", (Throwable)e);
            httpServletResponse.setStatus(500);
        }
        finally {
            LoggerUtility.DYNAMIC_LOG_MANAGER.resetLevel();
            DiagnosticContext.remove();
        }
    }

    private void doFilterCore(FilterChain chain, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        MetricsBean metricsBean = new MetricsBean();
        httpServletRequest.setAttribute("metricsBean", (Object)metricsBean);
        XSSValidator.validateUriAndServerName((String)httpServletRequest.getRequestURI(), (String)httpServletRequest.getServerName());
        RequestContext requestContext = MWValidationAndAuthenticationFilter.initializeRequestContext(httpServletRequest);
        UriContext uriContext = (UriContext)RequestUtils.getAttribute((HttpServletRequest)httpServletRequest, (String)"frontend_uri_context");
        uriContext = uriContext != null ? uriContext : UriParser.getInstance().parseUri(httpServletRequest.getRequestURI(), httpServletRequest.getContextPath());
        RequestUtils.setAttribute((HttpServletRequest)httpServletRequest, (String)"uricontext", (Object)uriContext);
        RequestUtils.setAttribute((HttpServletRequest)httpServletRequest, (String)"requestcontext", (Object)requestContext);
        uriContext.prepareRequestContext(httpServletRequest, requestContext);
        DeviceRequestData deviceRequestData = (DeviceRequestData)httpServletRequest.getAttribute("DeviceReqLogBean");
        deviceRequestData.setRequestUrl(httpServletRequest.getRequestURL().toString());
        String timerName = MonitoringUtils.buildTimerName(requestContext);
        metricsBean.setParentTimerName(timerName);
        metricsBean.setServiceName(StringUtils.isNotBlank((String)requestContext.getObjectId()) ? requestContext.getObjectId() : requestContext.getServiceId());
        FabricTimer fabricTimer = FabricTimer.startNew((FabricTimerCategory)FabricTimerCategory.SERVICE, (String)timerName, null, requestContext.getServiceInfoForTimerData());
        try {
            MBAASGateWayWrapper mbaasGatewayWrapper = this.validateAndAuthenticateRequest(httpServletRequest, requestContext, uriContext);
            String requestId = requestContext.getRequestId();
            requestId = requestId != null ? requestId.replace('\r', ' ').replace('\n', ' ') : requestId;
            requestContext.setRequestId(requestId);
            httpServletResponse.addHeader("X-Kony-RequestId", requestId);
            HttpIntegrityInfo httpIntegrity = IntegrityUtils.createIntegrityWrapperIfRequired(httpServletRequest, httpServletResponse, requestContext, mbaasGatewayWrapper);
            chain.doFilter((ServletRequest)httpIntegrity.getHttpIntegrityRequestWrapper(), (ServletResponse)httpIntegrity.getHttpIntegrityResponseWrapper());
            if (MonitoringUtils.checkForError(httpServletRequest)) {
                fabricTimer.markAsError();
            }
        }
        catch (Exception e) {
            fabricTimer.markAsError();
            throw e;
        }
        finally {
            MonitoringUtils.closeTimerAndUpdateInternalDurationManually(fabricTimer, metricsBean, timerName);
        }
    }

    private MBAASGateWayWrapper validateAndAuthenticateRequest(HttpServletRequest httpServletRequest, RequestContext requestContext, UriContext uriContext) throws MiddlewareException, GatewayException {
        LOGGER.debug((Object)"Inside validateAndAuthenticateRequest()");
        RequestValidator requestValidator = uriContext.getRequestValidator(requestContext);
        this.validateRequest(httpServletRequest, requestValidator, requestContext);
        return this.authenticateRequest(httpServletRequest, requestContext);
    }

    private void validateRequest(HttpServletRequest httpServletRequest, RequestValidator requestValidator, RequestContext requestContext) throws MiddlewareException {
        LOGGER.debug((Object)"Inside validateRequest()");
        requestValidator.validateRequest(requestContext);
        requestValidator.postValidation(httpServletRequest, requestContext);
    }

    private MBAASGateWayWrapper authenticateRequest(HttpServletRequest httpServletRequest, RequestContext requestContext) throws AuthorizationException, GatewayException {
        LOGGER.debug((Object)"Authenticating the request.");
        Authenticator authenticator = new Authenticator(requestContext);
        MBAASGateWayWrapper gatewayWrapper = authenticator.authorize();
        LOGGER.debug((Object)"Request successfully authenticated.");
        authenticator.doPostAuthentication(httpServletRequest, gatewayWrapper);
        return gatewayWrapper;
    }

    static RequestContext initializeRequestContext(HttpServletRequest httpServletRequest) {
        RequestContext requestContext = new RequestContext();
        if (httpServletRequest.getAttribute("tenantBean") != null) {
            TenantBean<AppCache> tenantBean = TenantUtilities.getTenantBeanFromRequest((ServletRequest)httpServletRequest);
            requestContext.setTenantBean(tenantBean);
            requestContext.setAppCache((AppCache)tenantBean.getAppCache());
        }
        CacheDirector cacheDirector = (CacheDirector)RequestUtils.getAttribute((HttpServletRequest)httpServletRequest, (String)"cacheDirector");
        requestContext.setCacheDirector(cacheDirector);
        return requestContext;
    }
}

