/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.common;

import com.konylabs.middleware.connectors.logservice.MetricsUtils;
import com.konylabs.middleware.servlet.filters.IntegrationCustomFilter;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

@IntegrationCustomFilter(filterOrder=120, servletNames={"MWServlet", "AppServices", "AppMetadataServices"}, defaultFilter=true)
public class MetricsFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(MetricsFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        long startTime = System.currentTimeMillis();
        try {
            chain.doFilter(request, response);
            if (MetricsUtils.isMetricsEnabled().booleanValue()) {
                MetricsUtils.logDetailsToQueue((HttpServletRequest)request, System.currentTimeMillis() - startTime);
            } else {
                LOGGER.debug((Object)"Metrics is turned off for middleware request call");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while performing log service.", (Throwable)e);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        LOGGER.debug((Object)"Metrics Filter initialized");
    }

    public void destroy() {
    }
}

