/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.common;

import com.kony.api.gateway.util.ServiceType;
import com.kony.middleware.web.listener.ConfigBootListener;
import com.konylabs.middleware.config.DBConfigSubject;
import com.konylabs.middleware.config.LoggerObserver;
import com.konylabs.middleware.config.Observer;
import com.konylabs.middleware.environment.EnvironmentConfigBean;
import com.konylabs.middleware.environment.EnvironmentFactory;
import com.konylabs.middleware.environment.MiddlewareDbManager;
import com.konylabs.middleware.monitoring.ServiceMonitorObserver;
import com.konylabs.middleware.utilities.ConfigPathUtil;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.LoggerUtility;
import com.konylabs.middleware.utilities.MaskUtils;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.sql.DataSource;

public class MiddlewareValidationListener
extends ConfigBootListener {
    private static boolean isCloudSupport = false;

    public void contextInitialized(ServletContextEvent contextEvent) {
        MiddlewareValidationListener.logMessage("Starting the validation of middleware environment at: " + Calendar.getInstance().getTime());
        ServletContext servletContext = contextEvent.getServletContext();
        String middlewareHome = super.initialize(servletContext);
        String cloudModeValue = System.getProperty("CLOUD_MODE");
        isCloudSupport = "true".equalsIgnoreCase(cloudModeValue) || "yes".equalsIgnoreCase(cloudModeValue);
        DataSource dataSource = MiddlewareDbManager.getAdminDataSource();
        EnvironmentConfigBean configBean = new EnvironmentConfigBean(dataSource, ServiceType.INTEGRATION);
        EnvironmentFactory.getEnvironmentInstance(configBean);
        DBConfigSubject.getInstance().reloadDatabaseProperties(configBean);
        if (ConfigUtility.getAllProperties().size() == 0) {
            MiddlewareValidationListener.logMessage("FATAL ERROR : middleware properties is not loaded properly.");
        }
        ConfigUtility.addPropertyInMapConfiguration((String)"context-path", (Object)servletContext.getContextPath());
        ConfigUtility.addPropertyInMapConfiguration((String)"IS_WEB_APP", (Object)(Boolean.valueOf(servletContext.getInitParameter("isServices")) == false ? 1 : 0));
        String log4jFilePath = System.getProperty("middleware.log4j.dir", middlewareHome + "/middleware/middleware-bootconfig/") + "server-log4j2.xml";
        LoggerUtility.loadLog4jProperties(log4jFilePath, false);
    }

    public static Set<String> getKeyList() {
        return MaskUtils.getKeyList();
    }

    public static boolean isCloudSupport() {
        return isCloudSupport;
    }

    public static void setCloudSupport(boolean isCloudSupport) {
        MiddlewareValidationListener.isCloudSupport = isCloudSupport;
    }

    @Deprecated
    public static String getMIDDLEWARE_HOME() {
        return ConfigPathUtil.getMiddlewareHome();
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    protected Map<String, String> getPropertiesMap() {
        DBConfigSubject.getInstance().registerObserver((Observer)new LoggerObserver());
        DBConfigSubject.getInstance().registerObserver((Observer)new ServiceMonitorObserver());
        return DBConfigSubject.getInstance().getPropMap();
    }

    protected static void logMessage(String message) {
        System.out.println(message);
    }

    public static Set<String> getResponseElementMaskList() {
        return MaskUtils.getResponseElementMaskList();
    }
}

