/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.common;

import com.konylabs.middleware.api.processor.StreamWriter;
import com.konylabs.middleware.api.processor.impl.ResponseData;
import com.konylabs.middleware.api.processor.manager.FabricResponseManager;
import com.konylabs.middleware.appservices.common.util.ObjectServiceUtil;
import com.konylabs.middleware.appservices.custom.processors.util.ObjectServicePreProcessorUtil;
import com.konylabs.middleware.common.XSSFilter;
import com.konylabs.middleware.exceptions.MiddlewareException;
import com.konylabs.middleware.exceptions.XssException;
import com.konylabs.middleware.request.builder.PayloadParserUtil;
import com.konylabs.middleware.request.builder.RequestContext;
import com.konylabs.middleware.request.builder.UriContext;
import com.konylabs.middleware.request.parser.RequestData;
import com.konylabs.middleware.servlet.filters.IntegrationCustomFilter;
import com.konylabs.middleware.utilities.RequestUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

@IntegrationCustomFilter(filterOrder=50, servletNames={"MWServlet", "AppServices", "AppMetadataServices"}, defaultFilter=true)
public class PayloadParsingFilter
extends XSSFilter {
    private static final Logger LOGGER = Logger.getLogger(PayloadParsingFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        UriContext uriContext = (UriContext)RequestUtils.getAttribute((HttpServletRequest)httpServletRequest, (String)"uricontext");
        RequestContext requestContext = (RequestContext)RequestUtils.getAttribute((HttpServletRequest)httpServletRequest, (String)"requestcontext");
        try {
            ObjectServicePreProcessorUtil.updateOperationFromCustomCode(httpServletRequest);
            RequestData requestData = PayloadParserUtil.getRequestDataByParsingPayload(httpServletRequest, httpServletResponse, this.getXssValidator(), uriContext, requestContext);
            httpServletRequest = requestData.getAndRemoveHttpServletRequest();
            httpServletResponse = requestData.getAndRemoveHttpServletResponse();
            this.printRequestUri(httpServletRequest);
            chain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (MiddlewareException e) {
            LOGGER.error((Object)"MiddlewareException occurred in PayloadParsingFilter", (Throwable)e);
            String errorMsg = ObjectServiceUtil.getErrorMsgByMiddlewareException(e);
            FabricResponseManager responseManager = (FabricResponseManager)RequestUtils.getAttribute((HttpServletRequest)httpServletRequest, (String)"RESPONSE_MANAGER");
            if (responseManager != null) {
                StreamWriter streamWriter = (StreamWriter)responseManager.getPayloadHandler();
                streamWriter.setMiddlewareResponse(new ResponseData((Object)errorMsg, response.getCharacterEncoding()));
            } else {
                ObjectServiceUtil.sendResponse(errorMsg, httpServletResponse);
            }
        }
        catch (XssException e) {
            LOGGER.error((Object)"XSS error occurred.", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to process request", (Throwable)e);
            httpServletResponse.setStatus(500);
        }
    }

    private void printRequestUri(HttpServletRequest httpServletRequest) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Request URL  : " + httpServletRequest.getRequestURL()));
            LOGGER.debug((Object)("Remote Address : " + httpServletRequest.getRemoteAddr()));
            LOGGER.debug((Object)("Local Address  : " + httpServletRequest.getLocalAddr()));
            LOGGER.debug((Object)("Parameter Map  : " + httpServletRequest.getParameterMap()));
            LOGGER.debug((Object)("Remote Host  : " + httpServletRequest.getRemoteHost()));
            LOGGER.debug((Object)("Server Name  : " + httpServletRequest.getServerName()));
            LOGGER.debug((Object)("Path Info  : " + httpServletRequest.getPathInfo()));
            LOGGER.debug((Object)("Servlet Path  : " + httpServletRequest.getServletPath()));
        }
    }
}

