/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.common;

import com.kony.mobilefabric.util.ReflectionUtils;
import com.konylabs.middleware.registry.impl.KonyAppCache;
import com.konylabs.middleware.registry.vo.Application;
import com.konylabs.middleware.registry.vo.ConfigParam;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.registry.vo.Services;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ProcessorValidationListener
implements ServletContextListener {
    private static final Logger LOGGER = Logger.getLogger(ProcessorValidationListener.class);
    private static final String REQUEST = "com.konylabs.middleware.controller.DataControllerRequest";
    private static final String RESPONSE = "com.konylabs.middleware.controller.DataControllerResponse";
    private static final String RESULT = "com.konylabs.middleware.dataobject.Result";
    private static final String SESSION = "com.konylabs.middleware.session.Session";
    private static final String PREPROCESSOR = "preprocessorname";
    private static final String POSTPROCESSOR = "postprocessorname";
    private static final String CLASSNAME = "className";
    private static final String SCRAPPERCLASS = "com.kony.scrapper.gc.ScrapperJavaService";
    private static final String URLPROVIDER = "urlprovider";
    private static List<String> classesList = new ArrayList<String>();

    public void contextDestroyed(ServletContextEvent sce) {
    }

    public void contextInitialized(ServletContextEvent sce) {
        Set apps = null;
        KonyAppCache appCache = null;
        try {
            appCache = (KonyAppCache)sce.getServletContext().getAttribute("appregistry_Cache");
            if (appCache != null) {
                apps = appCache.getAllApps();
                if (apps != null && apps.size() > 0) {
                    for (Application app : apps) {
                        LOGGER.debug((Object)(" validating " + app.getId() + ".xml"));
                        this.validateApplication(app);
                    }
                } else {
                    LOGGER.debug((Object)"KonyAppCache is either null or empty");
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug((Object)("ERROR: Error occurred while validating Global variables " + e.getMessage()));
        }
    }

    private void validateApplication(Application app) {
        Services services = app.getServices();
        Service[] allServices = null;
        ArrayList configParams = null;
        if (services != null && (allServices = services.getServiceArray()) != null && allServices.length > 0) {
            for (Service service : allServices) {
                configParams = service.getServiceConfig().getServiceConfig();
                this.loopOverConfigParams(configParams);
            }
        }
    }

    private void loopOverConfigParams(ArrayList<ConfigParam> configParams) {
        if (configParams != null) {
            for (ConfigParam configParam : configParams) {
                if (!StringUtils.isNotEmpty((String)configParam.getValue()) || classesList.contains(configParam.getValue())) continue;
                if (configParam.getName().equalsIgnoreCase(PREPROCESSOR) || configParam.getName().equalsIgnoreCase(POSTPROCESSOR) || configParam.getName().equalsIgnoreCase(URLPROVIDER)) {
                    this.validateProcessor(configParam.getValue());
                    continue;
                }
                if (!configParam.getName().equalsIgnoreCase(CLASSNAME) || configParam.getValue().equalsIgnoreCase(SCRAPPERCLASS)) continue;
                this.validateProcessor(configParam.getValue());
            }
        }
    }

    private void validateProcessor(String processorName) {
        classesList.add(processorName);
        Field[] fields = ReflectionUtils.getAllFields((String)processorName);
        if (fields != null && fields.length > 0) {
            this.validateGlobalFields(fields, processorName);
        }
    }

    private void validateGlobalFields(Field[] fields, String processorName) {
        String qualifiedFieldName = null;
        String[] fieldTokens = null;
        String fieldClassName = null;
        if (fields != null) {
            for (Field field : fields) {
                qualifiedFieldName = field.toString();
                fieldTokens = qualifiedFieldName.split(" ");
                fieldClassName = fieldTokens[fieldTokens.length - 2];
                this.validateClassName(fieldClassName, field.getName(), processorName);
            }
        }
    }

    private void validateClassName(String fieldClassName, String fieldName, String processorName) {
        if (fieldClassName != null && fieldName != null && processorName != null) {
            if (fieldClassName.equalsIgnoreCase(REQUEST) || fieldClassName.equalsIgnoreCase(RESPONSE) || fieldClassName.equalsIgnoreCase(RESULT) || fieldClassName.equalsIgnoreCase(SESSION)) {
                this.logWarnForGlobalVariableUse(fieldClassName, fieldName, processorName);
            } else {
                LOGGER.warn((Object)("WARN: Global variable {" + fieldClassName + " " + fieldName + "} used in " + processorName + ". Please do not use global variables instead use method scoped variables as preprocessor and postprocessor are singleton objects."));
            }
        } else {
            LOGGER.debug((Object)"Input params invalid to validateClassName");
        }
    }

    protected void logWarnForGlobalVariableUse(String fieldClassName, String fieldName, String processorName) {
        LOGGER.warn((Object)String.format("CRITICAL WARNING: Global variable {%s %s) used in %s. Please do not create global instance of %s as preprocessor and postprocessor are singleton objects.", fieldClassName, fieldName, processorName, fieldClassName));
    }
}

