/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.config;

import com.kony.api.auth.jwt.common.TokenSerDe;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.request.parser.RequestData;
import com.konylabs.middleware.servlet.filters.IntegrationCustomFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.message.MapMessage;

@IntegrationCustomFilter(filterOrder=201, servletNames={"MWServlet", "AppServices", "AppMetadataServices"}, defaultFilter=true)
public class AuditLogFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(AuditLogFilter.class);

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (LOGGER.isDebugEnabled()) {
            this.logAllDetails((HttpServletRequest)request);
        }
        chain.doFilter(request, response);
    }

    private void logAllDetails(HttpServletRequest request) {
        HashMap<String, String> auditInfo = new HashMap<String, String>();
        AuditLogFilter.getServiceDetails(request, auditInfo);
        AuditLogFilter.getUserDetails(request, auditInfo);
        LOGGER.debug((Object)new MapMessage(auditInfo));
    }

    private static void getServiceDetails(HttpServletRequest request, Map<String, String> auditInfo) {
        AppVersion appVersion;
        String requestedMethod;
        RequestData requestData = (RequestData)request.getAttribute("requestdata");
        String serviceId = requestData.getAppId();
        auditInfo.put("Service Id", serviceId);
        String operationId = requestData.getServiceId();
        auditInfo.put("Operation Id", operationId);
        String objectID = requestData.getObjectId();
        if (objectID != null) {
            auditInfo.put("Object Id", objectID);
        }
        if ((requestedMethod = requestData.getRequestedMethod()) != null) {
            auditInfo.put("Requested Method", requestedMethod);
        }
        if ((appVersion = requestData.getAppVersion()) != null) {
            String version = appVersion.getVersion();
            auditInfo.put("Service Version", version);
        }
    }

    private static void getUserDetails(HttpServletRequest request, Map<String, String> auditInfo) {
        String clientIP = request.getRemoteAddr();
        auditInfo.put("Client Address", clientIP);
        String userId = AuditLogFilter.getUserId(request);
        if (userId != null) {
            auditInfo.put("User Id", userId);
        }
    }

    private static String getUserId(HttpServletRequest request) {
        try {
            String claimsToken = request.getHeader("X-Kony-Authorization");
            if (claimsToken != null) {
                return TokenSerDe.deserializeToken((String)claimsToken).getUserId();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

