/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.config;

import com.kony.mobilefabric.logger.DynamicLogCriteriaHelper;
import com.konylabs.middleware.config.AuditLogFilter;
import com.konylabs.middleware.config.DBConfigSubject;
import com.konylabs.middleware.config.DatasourcePayloadLogger;
import com.konylabs.middleware.config.DevicePayloadLogger;
import com.konylabs.middleware.config.LoggerProperties;
import com.konylabs.middleware.config.Observer;
import com.konylabs.middleware.config.TraceLogProperties;
import com.konylabs.middleware.utilities.LoggerUtility;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;

public class LoggerObserver
implements Observer {
    private static final Map<String, Consumer<String>> LOG_ACTIONS = LoggerObserver.initLogActions();

    public void updateConfiguration(Map<String, Object> updatedMap) {
        for (Map.Entry<String, Object> entry : updatedMap.entrySet()) {
            String key = entry.getKey();
            String value = (String)entry.getValue();
            Consumer<String> updateConfig = LOG_ACTIONS.get(key);
            if (updateConfig != null) {
                updateConfig.accept(value);
                continue;
            }
            if (!DBConfigSubject.getInstance().getLoggerLevelMap().containsKey(key)) continue;
            if (StringUtils.isBlank((String)value)) {
                LoggerUtility.removeLoggerLevel(key);
                continue;
            }
            LoggerUtility.updateLoggerLevel(LoggerUtility.toLevel(value), key);
        }
    }

    private static Map<String, Consumer<String>> initLogActions() {
        TreeMap<String, Consumer<String>> actions = new TreeMap<String, Consumer<String>>(String.CASE_INSENSITIVE_ORDER);
        actions.put(LoggerProperties.SERVER_LOG_LEVEL.getName(), LoggerUtility::updateRootLogger);
        actions.put(LoggerProperties.TIMER_LOG_LEVEL.getName(), LoggerUtility::updateTimerLogger);
        actions.put(LoggerProperties.LOG_DEVICE_PAYLOAD.getName(), v -> LoggerUtility.updatePayloadLogger(v, DevicePayloadLogger.class));
        actions.put(LoggerProperties.LOG_DATASOURCE_PAYLOAD.getName(), v -> LoggerUtility.updatePayloadLogger(v, DatasourcePayloadLogger.class));
        actions.put(LoggerProperties.LOG_AUDIT_INFO.getName(), v -> LoggerUtility.updatePayloadLogger(v, AuditLogFilter.class));
        actions.put(LoggerProperties.CLIENT_LOG_LEVEL_OVERRIDE.getName(), v -> LoggerUtility.DYNAMIC_LOG_MANAGER.add(DynamicLogCriteriaHelper.buildClientOverrideLogCriteria((String)LoggerProperties.CLIENT_LOG_LEVEL_OVERRIDE.getName(), (!"false".equalsIgnoreCase((String)v) ? 1 : 0) != 0)));
        actions.put(LoggerProperties.TENANT_ID_LOG_CRITERIA.getName(), v -> LoggerUtility.addDynamicLogCriteria(LoggerProperties.TENANT_ID_LOG_CRITERIA, v));
        actions.put(LoggerProperties.USER_ID_LOG_CRITERIA.getName(), v -> LoggerUtility.addDynamicLogCriteria(LoggerProperties.USER_ID_LOG_CRITERIA, v));
        actions.put(LoggerProperties.CLIENT_IP_LOG_CRITERIA.getName(), v -> LoggerUtility.addDynamicLogCriteria(LoggerProperties.CLIENT_IP_LOG_CRITERIA, v));
        actions.put(LoggerProperties.DEVICE_ID_LOG_CRITERIA.getName(), v -> LoggerUtility.addDynamicLogCriteria(LoggerProperties.DEVICE_ID_LOG_CRITERIA, v));
        actions.put(LoggerProperties.SERVICE_NAME_LOG_CRITERIA.getName(), v -> LoggerUtility.addDynamicLogCriteria(LoggerProperties.SERVICE_NAME_LOG_CRITERIA, v));
        actions.put(LoggerProperties.MFAPP_NAME_LOG_CRITERIA.getName(), v -> LoggerUtility.addDynamicLogCriteria(LoggerProperties.MFAPP_NAME_LOG_CRITERIA, v));
        actions.put(TraceLogProperties.LEVEL.getName(), LoggerUtility::updateTraceLogsLevel);
        return Collections.unmodifiableMap(actions);
    }
}

