/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors;

import com.kony.mobilefabric.timer.FabricTimer;
import com.kony.mobilefabric.timer.FabricTimerCategory;
import com.konylabs.middleware.connectors.Connector;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.exceptions.ProcessorException;
import com.konylabs.middleware.metrics.MWMetricsTimer;
import com.konylabs.middleware.metrics.MetricsBean;
import com.konylabs.middleware.monitoring.MonitoringProperties;
import com.konylabs.middleware.monitoring.MonitoringUtils;
import com.konylabs.middleware.processor.Processor;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.services.ServiceDelegate;
import com.konylabs.middleware.utilities.ConfigUtility;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractCompositeConnector
implements Connector {
    private static final Logger LOGGER = Logger.getLogger(AbstractCompositeConnector.class);
    private ServiceDelegate serviceDelegate;

    @Override
    public void setCallingProcessor(Processor processor) {
        if (processor instanceof ServiceDelegate) {
            this.serviceDelegate = (ServiceDelegate)processor;
        }
    }

    protected ServiceDelegate getServiceDelegate() {
        return this.serviceDelegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Result invokeService(String connectorName, Service service, DataControllerRequest request, DataControllerResponse response) throws ConnectorException {
        Result res = null;
        DataControllerRequest clonedRequest = request.clone();
        String timerName = this.prepareTimerName(service, request);
        MetricsBean originalMetricsBean = this.getOriginalMetricsBeanAndPrepareClone(request, service.getId(), timerName);
        Map<String, String> additionalTimerInfo = this.prepareTimerInfo(service, request, originalMetricsBean.getServiceName());
        FabricTimer childServiceTimer = FabricTimer.startNew((FabricTimerCategory)FabricTimerCategory.SERVICE, (String)timerName, null, additionalTimerInfo);
        try (MWMetricsTimer orchServiceBackendRequestTimer = new MWMetricsTimer(clonedRequest, FabricTimerCategory.BACKEND_REQUEST, "serviceTimeInMillis");){
            try {
                res = this.serviceDelegate.execute(service, request, response);
            }
            catch (ProcessorException pe) {
                childServiceTimer.markAsError();
                if (!ConfigUtility.getBoolean((String)"mask.trace", (boolean)false)) {
                    LOGGER.error((Object)"1582 - Service delegate execute failed", (Throwable)pe);
                } else {
                    LOGGER.error((Object)"1582 - Service delegate execute failed");
                }
                throw new ConnectorException(connectorName, pe.getErrorCode(), pe.getMessage(), (Throwable)pe);
            }
        }
        finally {
            MonitoringUtils.closeTimerAndUpdateInternalDurationManually(childServiceTimer, MonitoringUtils.getMetricsBeanFromRequest(request), timerName);
            request.setAttribute("metricsBean", (Object)originalMetricsBean);
        }
        return res;
    }

    protected MetricsBean getOriginalMetricsBeanAndPrepareClone(DataControllerRequest request, String serviceId, String timerName) {
        MetricsBean originalMetricsBean = MonitoringUtils.getMetricsBeanFromRequestIfNotNullElseDefault(request);
        MonitoringUtils.prepareClonedMetricsBeanAndSetInRequest(request, serviceId, timerName, originalMetricsBean);
        return originalMetricsBean;
    }

    protected String prepareTimerName(Service service, DataControllerRequest request) {
        String appId = request.getParameter("current_appID");
        String serviceId = service.getId();
        String appVersion = request.getParameter("curent_apiVersion");
        return appId + "-" + serviceId + "-" + appVersion;
    }

    protected Map<String, String> prepareTimerInfo(Service service, DataControllerRequest request, String parentServiceName) {
        ServiceMetadata serviceMetadata = (ServiceMetadata)service.getCustomObjMap().get("serviceMetadataKey");
        HashMap<String, String> additionalTimerInfo = new HashMap<String, String>();
        additionalTimerInfo.put(MonitoringProperties.SERVICE_NAME.getName(), request.getParameter("current_appID"));
        additionalTimerInfo.put(MonitoringProperties.OPERATION_NAME.getName(), service.getId());
        additionalTimerInfo.put(MonitoringProperties.SERVICE_VERSION.getName(), request.getParameter("curent_apiVersion"));
        additionalTimerInfo.put(MonitoringProperties.SERVICE_TYPE.getName(), service.getServiceType());
        additionalTimerInfo.put(MonitoringProperties.VERB.getName(), serviceMetadata.getSupportedMethods());
        additionalTimerInfo.put(MonitoringProperties.PARENT_SERVICE_NAME.getName(), parentServiceName);
        if (StringUtils.isNotBlank((String)serviceMetadata.getObjectId())) {
            additionalTimerInfo.put(MonitoringProperties.SERVICE_CATEGORY.getName(), "ObjectService");
        } else {
            additionalTimerInfo.put(MonitoringProperties.SERVICE_CATEGORY.getName(), "Integration");
        }
        return additionalTimerInfo;
    }
}

