/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.w3c.dom.Element;

public abstract class AbstractNamespaceContext
implements NamespaceContext {
    private static final String DEFAULT_NS = "DEFAULT";
    private final Map<String, String> prefix2Uri = new LinkedHashMap<String, String>();
    private final Map<String, String> uri2Prefix = new HashMap<String, String>();

    protected void addNamespace(String prefix, String uri) {
        this.prefix2Uri.put(prefix, uri);
        this.uri2Prefix.put(uri, prefix);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null || prefix.equals("")) {
            return this.prefix2Uri.get(DEFAULT_NS);
        }
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2001/XMLSchema";
        }
        return this.prefix2Uri.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.uri2Prefix.get(namespaceURI);
    }

    public Iterator getPrefixes(String namespaceURI) {
        return null;
    }

    public void addNamespacesToNode(Element element) {
        for (Map.Entry<String, String> namespaceEntry : this.prefix2Uri.entrySet()) {
            if (element.getNamespaceURI() != null && element.getNamespaceURI().equals(namespaceEntry.getValue())) continue;
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + namespaceEntry.getKey(), namespaceEntry.getValue());
        }
    }
}

