/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors;

import com.kony.adapter.event.DataAdapterEvent;
import com.kony.adapter.event.DataAdapterEventNotifier;
import com.kony.adapter.event.DataAdapterEventObserver;
import com.kony.mobilefabric.timer.FabricTimerCategory;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.classloader.ClassLoaderUtils;
import com.konylabs.middleware.cloud.CloudUtils;
import com.konylabs.middleware.common.DataProvider;
import com.konylabs.middleware.common.MiddlewareValidationListener;
import com.konylabs.middleware.common.URLProvider;
import com.konylabs.middleware.common.URLProvider2;
import com.konylabs.middleware.config.DatasourcePayloadLogger;
import com.konylabs.middleware.connectors.Connector;
import com.konylabs.middleware.connectors.ConnectorUtils;
import com.konylabs.middleware.connectors.io.IServiceInputHandler;
import com.konylabs.middleware.connectors.io.IServiceOutputHandler;
import com.konylabs.middleware.connectors.io.MWPassThroughInputHandler;
import com.konylabs.middleware.connectors.io.MWPassThroughOutputHandler;
import com.konylabs.middleware.connectors.postprocessor.PostProcessUtils;
import com.konylabs.middleware.connectors.preprocessor.PreProcessUtils;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.PassthroughResult;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.dataprovider.DefaultDataProvider;
import com.konylabs.middleware.dataprovider.stub.StubDataProvider;
import com.konylabs.middleware.dataprovider.stub.StubUtils;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.exceptions.ConnectorInitializationException;
import com.konylabs.middleware.http.HttpMethods;
import com.konylabs.middleware.identityproviders.MBaaSIdentityProvider;
import com.konylabs.middleware.mbaas.MiddlewareMBaasUtils;
import com.konylabs.middleware.metrics.MWMetricsTimer;
import com.konylabs.middleware.processor.Processor;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.throttle.ThrottleUtil;
import com.konylabs.middleware.utilities.AnnotationUtils;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.MapperUtility;
import com.konylabs.middleware.utilities.MaskUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class BaseConnector
implements Connector,
DataAdapterEventNotifier {
    private static final Logger LOGGER = Logger.getLogger(BaseConnector.class);
    private List<DataAdapterEventObserver> observers;

    @Override
    public Result execute(Service service, DataControllerRequest request, DataControllerResponse response) throws ConnectorInitializationException, ConnectorException {
        Map<String, Object> configMap;
        Result result;
        block46: {
            LOGGER.debug((Object)("BaseConnector - START TIME (ms): " + System.currentTimeMillis()));
            ServiceMetadata serviceMetadata = MiddlewareUtils.getServiceMetadata(service);
            ThrottleUtil.checkThrottled(serviceMetadata, request);
            result = new Result();
            String serviceId = service.getId();
            configMap = MiddlewareUtils.populateConfigMap(service, serviceMetadata);
            StubUtils.populateStubInputTemplate(serviceMetadata, request, configMap);
            String endpointUrlStr = (String)request.getAttribute("endpointUrl");
            if (StringUtils.isBlank((String)endpointUrlStr)) {
                endpointUrlStr = (String)configMap.get("endpointUrl");
            }
            if (StringUtils.isBlank((String)endpointUrlStr)) {
                LOGGER.error((Object)"Connector configuration problem. Mandatory parameters are missing");
                throw new ConnectorInitializationException("9106", "Connector Configuration Problem. endpointUrl is null for service " + serviceId);
            }
            IServiceInputHandler wsinput = this.getInputHandler(configMap.get("isReqPassThru"));
            IServiceOutputHandler wsoutput = this.getOutputHandler(configMap.get("isResPassThru"));
            Map<String, Object> inputMap = new HashMap<String, Object>();
            try {
                String httpMethod = (String)configMap.get("http.method");
                if (MiddlewareUtils.isRequestPassThrough(service) && MBaaSIdentityProvider.CONNECTOR_TYPE_ENUM.soapserviceConnector.toString().equalsIgnoreCase(service.getServiceType())) {
                    httpMethod = HttpMethods.POST.name();
                    configMap.put("http.method", httpMethod);
                }
                inputMap = MapperUtility.isMapperInServiceInput(service) ? MapperUtility.prepareInputMap(service, request, this) : wsinput.getInputMap(request, configMap, service, endpointUrlStr);
                boolean isCachable = service.isCachable();
                Object resultFromCache = null;
                if (isCachable && (resultFromCache = ConnectorUtils.getResultFromCache(request, serviceMetadata, inputMap, response)) != null) {
                    if (MiddlewareUtils.isRequestPassThrough(service)) {
                        if (resultFromCache instanceof PassthroughResult) {
                            PassthroughResult passthroughResult = (PassthroughResult)resultFromCache;
                            response.setAttribute("chunkedresults_json", passthroughResult.getChunkResultObject());
                            response.setCharsetEncoding(passthroughResult.getCharsetEncoding());
                            response.setStatusCode(passthroughResult.getStatusCode());
                            response.setHeaders(passthroughResult.getHeadersMap());
                        }
                    } else {
                        result = (Result)resultFromCache;
                    }
                    LOGGER.debug((Object)"Fetched the result object from cache passing the cloned copy");
                    return result.getCopy();
                }
                if (LOGGER.isDebugEnabled()) {
                    StringBuilder buf = new StringBuilder();
                    for (String key2 : inputMap.keySet()) {
                        if (MiddlewareValidationListener.getKeyList().contains(key2)) {
                            buf.append(" " + key2).append(" = ").append(MaskUtils.maskString((String[])new String[]{String.valueOf(inputMap.get(key2))}));
                            continue;
                        }
                        buf.append(" " + key2).append(" = ").append(inputMap.get(key2));
                    }
                    LOGGER.debug((Object)("Inputmap:" + buf.toString()));
                    buf.delete(0, buf.length());
                }
                AppVersion appVersion = MiddlewareUtils.getAppVersionFromService(service);
                boolean executeService = PreProcessUtils.execute(service, configMap, inputMap, request, response, result, appVersion);
                endpointUrlStr = ConnectorUtils.buildEndPointURL(endpointUrlStr, inputMap, configMap);
                LOGGER.debug((Object)("Endpoint URL :" + endpointUrlStr));
                if (CloudUtils.isCustomCodeEnabled()) {
                    endpointUrlStr = this.getEndPointURLFromCustomURLProvider(endpointUrlStr, service, configMap, request, inputMap);
                    LOGGER.debug((Object)("Endpoint URL after URL Provider:" + endpointUrlStr));
                }
                if (!executeService) break block46;
                String message = wsinput.getMessage(request, inputMap, configMap, service);
                Map<String, String> headerMap = wsinput.getHeaders(request, configMap, service);
                MiddlewareMBaasUtils.populateIdentityHeaders(request, headerMap);
                request.setAttribute("REQUEST_HEADERS", headerMap);
                if (message != null && (LOGGER.isDebugEnabled() || DatasourcePayloadLogger.isEnabled())) {
                    String debugValue = this.maskParam(wsinput, inputMap, message);
                    LOGGER.debug((Object)("Request Message is " + debugValue));
                    DatasourcePayloadLogger.log("Datasource Payload request for Service : %s", service.getId());
                    DatasourcePayloadLogger.log("Datasource Payload request : %s", debugValue);
                    String logReq = ConfigUtility.getProperty((String)"logRequest");
                    if (logReq != null && (logReq.equalsIgnoreCase("true") || logReq.equalsIgnoreCase("yes"))) {
                        request.setAttribute("REQUEST_MSG", (Object)debugValue);
                    }
                }
                ArrayList<File> filesToUpload = new ArrayList<File>();
                for (String string : inputMap.keySet()) {
                    if (!(inputMap.get(string) instanceof File)) continue;
                    filesToUpload.add((File)inputMap.get(string));
                }
                Throwable throwable = null;
                try (MWMetricsTimer timer = new MWMetricsTimer(request, FabricTimerCategory.BACKEND_REQUEST, "serviceTimeInMillis");){
                    DataProvider dataProvider = this.getDataProvider(service, configMap, request, inputMap);
                    dataProvider.execute(endpointUrlStr, request, response, message, headerMap, filesToUpload, (HashMap)configMap);
                }
                catch (Throwable dataProvider) {
                    Throwable throwable2 = dataProvider;
                    throw dataProvider;
                }
                timer = new MWMetricsTimer(request, FabricTimerCategory.PARSING, "prsdur");
                Throwable throwable3 = null;
                try {
                    wsoutput.processOutput(service, request, response, result);
                }
                catch (Throwable dataProvider) {
                    Throwable throwable4 = dataProvider;
                    throw dataProvider;
                }
                finally {
                    if (timer != null) {
                        if (throwable3 != null) {
                            try {
                                timer.close();
                            }
                            catch (Throwable dataProvider) {
                                throwable3.addSuppressed(dataProvider);
                            }
                        } else {
                            timer.close();
                        }
                    }
                }
                if (result != null) {
                    int cacheduration;
                    result = PostProcessUtils.execute(service, configMap, result, request, response, appVersion);
                    int n = cacheduration = service.getCacheduration() == null || service.getCacheduration().length() == 0 ? -1 : Integer.parseInt(service.getCacheduration());
                    if (isCachable) {
                        if (MiddlewareUtils.isRequestPassThrough(service)) {
                            PassthroughResult passthroughResult = new PassthroughResult();
                            Object chunkResultsObject = response.getAttribute("chunkedresults_json");
                            passthroughResult.setCharsetEncoding(response.getCharsetEncoding());
                            passthroughResult.setChunkResultObject(chunkResultsObject);
                            passthroughResult.setHeadersMap(response.getHeaders());
                            passthroughResult.setStatusCode(response.getStatusCode());
                            ConnectorUtils.insertResultsIntoCache(request, serviceMetadata, inputMap, passthroughResult, cacheduration);
                        } else {
                            ConnectorUtils.insertResultsIntoCache(request, serviceMetadata, inputMap, result, cacheduration);
                        }
                    }
                }
                result = MapperUtility.applyMapperOnResult(request, service, result, this);
            }
            catch (ConnectorException ex) {
                AnnotationUtils.callPostProcessorOnException(request, response, configMap, result, inputMap, (Exception)((Object)ex));
                MaskUtils.maskTrace((String)ex.getMessage(), (Throwable)ex);
                String connectorType = StringUtils.isBlank((String)ex.getConnectorType()) ? "BaseConnector " : ex.getConnectorType();
                throw new ConnectorException(connectorType + " for " + serviceId, ex.getErrorCode(), ex.getHttpStatusCode(), ex.getMessage(), (Throwable)ex);
            }
            catch (Exception ex) {
                AnnotationUtils.callPostProcessorOnException(request, response, configMap, result, inputMap, ex);
                MaskUtils.maskTrace((String)("MW9109: Unable to execute for the given service " + serviceId + "while connecting to endpoint URL"), (Throwable)ex);
                throw new ConnectorException("BaseConnector", "9109", "Unable to execute for the given service " + serviceId + "while connecting to endpoint URL", (Throwable)ex);
            }
        }
        LOGGER.debug((Object)("BaseConnector - END TIME before JSON Conversation(ms): " + System.currentTimeMillis()));
        if (Boolean.parseBoolean(configMap.get("isResPassThru").toString())) {
            request.setAttribute("passThruResults", (Object)response);
        }
        return result;
    }

    @Override
    public void setCallingProcessor(Processor processor) {
    }

    public void notify(DataAdapterEvent event) {
        if (this.observers != null) {
            for (DataAdapterEventObserver observer : this.observers) {
                try {
                    observer.onEvent(event);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Exception thrown by observer in notify", (Throwable)e);
                }
            }
        }
    }

    public void register(DataAdapterEventObserver observer) {
        if (this.observers == null) {
            this.observers = new CopyOnWriteArrayList<DataAdapterEventObserver>();
        }
        this.observers.add(observer);
    }

    public void unregister(DataAdapterEventObserver observer) {
        if (this.observers != null) {
            this.observers.remove(observer);
        }
    }

    protected DataProvider getDataProvider(Service service, Map<String, Object> configMap, DataControllerRequest request, Map<String, Object> inputMap) throws ConnectorException {
        String dataProviderClazz = (String)configMap.get("dataprovider");
        if (CloudUtils.isCustomCodeEnabled() && StringUtils.isNotBlank((String)dataProviderClazz)) {
            String jarModule = MiddlewareUtils.getJarModuleNameFromService(service);
            return (DataProvider)ClassLoaderUtils.getCustomClassInstance(service.getId(), jarModule, dataProviderClazz);
        }
        if (StubUtils.isStubDataProviderEnabled(request, configMap)) {
            LOGGER.warn((Object)("INFO - Creating stub data provider for service: " + service.getId()));
            return new StubDataProvider(this, inputMap, service);
        }
        return new DefaultDataProvider(this);
    }

    protected abstract IServiceInputHandler getInputHandler();

    protected abstract IServiceOutputHandler getOutputHandler();

    private IServiceInputHandler getInputHandler(Object isRequestPassThrough) {
        return Boolean.parseBoolean(isRequestPassThrough.toString()) ? new MWPassThroughInputHandler() : this.getInputHandler();
    }

    private IServiceOutputHandler getOutputHandler(Object isResponsePassThrough) {
        return Boolean.parseBoolean(isResponsePassThrough.toString()) ? new MWPassThroughOutputHandler() : this.getOutputHandler();
    }

    private String getEndPointURLFromCustomURLProvider(String endPointURL, Service service, Map<String, Object> config, DataControllerRequest request, Map<String, Object> inputMap) throws ConnectorException {
        String urlProviderName = (String)config.get("urlprovider");
        if (StringUtils.isNotBlank((String)urlProviderName)) {
            String jarModule = MiddlewareUtils.getJarModuleNameFromService(service);
            Object object = ClassLoaderUtils.getCustomClassInstance(service.getId(), jarModule, urlProviderName);
            if (object != null && (object instanceof URLProvider || object instanceof URLProvider2)) {
                try (MWMetricsTimer timer = new MWMetricsTimer(request, FabricTimerCategory.URL_PROVIDER_PROCESSING, "urlProviderDur");){
                    if (object instanceof URLProvider) {
                        URLProvider urlProvider = (URLProvider)object;
                        endPointURL = urlProvider.execute(endPointURL, request);
                    } else if (object instanceof URLProvider2) {
                        URLProvider2 urlProvider2 = (URLProvider2)object;
                        endPointURL = urlProvider2.execute(endPointURL, service, config, request, inputMap);
                    }
                }
            }
        }
        return endPointURL;
    }

    private String maskParam(IServiceInputHandler wsinput, Map<String, Object> inputMap, String debugValue) {
        for (String token : MiddlewareValidationListener.getKeyList()) {
            Object tokenValue = inputMap.get(token);
            if (tokenValue == null || !StringUtils.isNotBlank((String)String.valueOf(tokenValue))) continue;
            String cseq = String.valueOf(tokenValue);
            if (debugValue.contains(cseq)) {
                debugValue = debugValue.replace(cseq, "*****");
                continue;
            }
            String cseqEncoded = wsinput.getEncodeFunction().apply(cseq);
            debugValue = debugValue.replace(cseqEncoded, "*****");
        }
        return debugValue;
    }
}

