/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors;

import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.common.CSRIssueLogger;
import com.konylabs.middleware.connectors.AbstractCompositeConnector;
import com.konylabs.middleware.connectors.ServiceThreadPooler;
import com.konylabs.middleware.connectors.postprocessor.PostProcessUtils;
import com.konylabs.middleware.connectors.utility.CompositeConnectorHandler;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Dataset;
import com.konylabs.middleware.dataobject.Param;
import com.konylabs.middleware.dataobject.Record;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.dataobject.ResultToJSON;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.registry.vo.ConfigParam;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.session.Session;
import com.konylabs.middleware.throttle.ThrottleUtil;
import com.konylabs.middleware.utilities.MaskUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;

public class CompositeConnector
extends AbstractCompositeConnector {
    private static final Logger LOGGER = Logger.getLogger(CompositeConnector.class);
    private static final String INT_CONST = "int";
    private static final String OPSTATUS = "opstatus";
    private static final String ERRMSG = "errmsg";

    @Override
    public Result execute(Service service, DataControllerRequest request, DataControllerResponse response) throws ConnectorException {
        LOGGER.debug((Object)"Composite Execute Service Called");
        ServiceMetadata serviceMetadata = MiddlewareUtils.getServiceMetadata(service);
        ThrottleUtil.checkThrottled(serviceMetadata, request);
        ArrayList<Service> compositeServices = new ArrayList<Service>();
        ArrayList<AppVersion> inlineAppIdList = new ArrayList<AppVersion>();
        String appID = serviceMetadata.getAppId();
        Map<String, Object> configMap = MiddlewareUtils.populateConfigMap(service, serviceMetadata);
        String execType = "Sequential";
        if (configMap.containsKey("exec_type")) {
            execType = (String)configMap.get("exec_type");
        }
        String uniqueKeys = (String)configMap.get("unique_keys");
        ArrayList cparams = service.getServiceConfig().getServiceConfig();
        if (cparams != null) {
            for (ConfigParam param : cparams) {
                String inlineAppId;
                if (!"service".equals(param.getName())) continue;
                String inlineServiceId = param.getValue();
                if (inlineServiceId.contains(".")) {
                    String[] name = StringUtils.split((String)inlineServiceId, (String)".");
                    inlineAppId = name[0];
                    inlineServiceId = name[1];
                } else {
                    inlineAppId = StringUtils.isNotBlank((String)param.getAppid()) ? param.getAppid() : appID;
                }
                String inlineAPIVersion = StringUtils.isNotBlank((String)param.getApiVersion()) ? param.getApiVersion() : MiddlewareUtils.getRuntimeVersion(serviceMetadata.getAppMetadata().getAppCache(), inlineAppId);
                try {
                    AppVersion inlineAppVersion = new AppVersion(inlineAppId, inlineAPIVersion);
                    inlineAppIdList.add(inlineAppVersion);
                    ApplicationMetadata appMetadata = (ApplicationMetadata)serviceMetadata.getAppMetadata().getAppCache().getAppMetadata(inlineAppVersion);
                    if (appMetadata == null) {
                        LOGGER.error((Object)("Application does not exist for the inline appId : " + inlineAppId));
                        throw new ConnectorException("compsoitConnector", "1582", "Not able to lookup service " + inlineServiceId);
                    }
                    ServiceMetadata inlineServiceMetadata = appMetadata.getServiceMetadata(inlineServiceId);
                    if (inlineServiceMetadata == null) {
                        LOGGER.error((Object)("Service does not exist for the inline serviceId : " + inlineServiceId));
                        throw new ConnectorException("compsoitConnector", "1582", "Not able to lookup service " + inlineServiceId);
                    }
                    Service srvc = inlineServiceMetadata.getService();
                    compositeServices.add(srvc);
                }
                catch (ConnectorException e) {
                    throw e;
                }
                catch (Exception ex) {
                    MaskUtils.maskTrace((String)("Not able to lookup service with svcID : " + inlineServiceId), (Throwable)ex);
                    throw new ConnectorException("compsoitConnector", "1582", "Not able to lookup service " + inlineServiceId, (Throwable)ex);
                }
            }
        }
        LOGGER.debug((Object)("execution Type : " + execType + " AppID: " + appID + " Composite Service ID : " + service.getId()));
        ArrayList<Result> results = new ArrayList<Result>();
        long startTime = System.currentTimeMillis();
        LOGGER.debug((Object)("-----------------------START<Execution Type:" + execType + ">START----------------------"));
        Iterator appIdIterator = inlineAppIdList.iterator();
        if ("Sequential".equals(execType)) {
            for (Service srvc : compositeServices) {
                Result res = new Result();
                LOGGER.debug((Object)("Service of Type:" + srvc.getServiceType() + " with ID:" + srvc.getId()));
                for (Result result : results) {
                    if (result == null) continue;
                    CompositeConnectorHandler.paramsToRequestParam(result.getAllParams(), request);
                    CompositeConnectorHandler.datasetToRequestParam(result.getAllDatasets(), request);
                    CompositeConnectorHandler.recordsToRequestParam(result.getAllRecords(), request);
                }
                try {
                    AppVersion currentAppVersion = (AppVersion)appIdIterator.next();
                    MiddlewareUtils.updateCurrentServiceData(request, currentAppVersion.getAppId(), currentAppVersion.getVersion(), srvc.getId());
                    res = this.invokeService("CompositeConnector", srvc, request, response);
                }
                catch (ConnectorException ce) {
                    if (request.getAttribute("ResultOnException") != null) {
                        res = (Result)request.getAttribute("ResultOnException");
                        request.setAttribute("ResultOnException", null);
                    }
                    LOGGER.error((Object)("Unable to execute the service " + srvc.getId() + " due to previous errors."));
                    res.addParam(new Param(OPSTATUS, ce.getErrorCode(), INT_CONST));
                    res.addParam(new Param(ERRMSG, ce.getMessage(), "string"));
                }
                res = this.setMiddlewareStatusCodes(res, srvc, execType);
                results.add(res);
            }
        } else {
            ArrayList<ServiceTask> servicTasks = new ArrayList<ServiceTask>();
            for (Service srvc : compositeServices) {
                ServiceTask stask = new ServiceTask();
                LOGGER.debug((Object)("Service of Type: " + srvc.getServiceType() + " with ID:" + srvc.getId()));
                DataControllerRequest clonedRequest = request.clone();
                AppVersion currentAppVersion = (AppVersion)appIdIterator.next();
                MiddlewareUtils.updateCurrentServiceData(clonedRequest, currentAppVersion.getAppId(), currentAppVersion.getVersion(), srvc.getId());
                stask.setServiceExecInfo(srvc, clonedRequest, response.clone(), NDC.cloneStack(), execType);
                servicTasks.add(stask);
            }
            LOGGER.debug((Object)("Total no. of services : " + servicTasks.size()));
            if (servicTasks.size() > 0) {
                ServiceThreadPooler stp = new ServiceThreadPooler(servicTasks.size(), 5);
                try {
                    stp.runTasks(servicTasks, results);
                }
                catch (Exception ex) {
                    LOGGER.error((Object)"Not able to execute service parallely", (Throwable)ex);
                    throw new ConnectorException("compsoitConnector", "1582", "Not able to execute service parallely for service " + service.getId(), (Throwable)ex);
                }
                finally {
                    if (stp != null) {
                        stp.shutDown();
                    }
                    stp = null;
                }
            }
        }
        long endTime = System.currentTimeMillis();
        HttpServletRequest originalReq = (HttpServletRequest)request.getOriginalRequest();
        if (originalReq != null) {
            Hashtable serviceTimesTable = (Hashtable)originalReq.getAttribute("serviceTimesTable");
            long totalServiceTime = 0L;
            LOGGER.info((Object)("CompositeConnector|" + service.getId() + "|" + execType + "|Service Times Table==" + serviceTimesTable));
            for (Service serv : compositeServices) {
                String serviceTime = serviceTimesTable != null ? (String)serviceTimesTable.get(serv.getId() + "_" + "serviceTimeInMillis") : null;
                LOGGER.debug((Object)("CompositeConnector|" + service.getId() + "|Service Time for " + serv.getId() + " ==" + serviceTime));
                if (serviceTime == null) continue;
                String[] serviceTimes = serviceTime.split(",");
                if (StringUtils.isNumeric((String)serviceTimes[0])) {
                    Long sTime = Long.parseLong(serviceTimes[0]);
                    if ("Sequential".equals(execType)) {
                        totalServiceTime += sTime.longValue();
                    } else if (sTime > totalServiceTime) {
                        totalServiceTime = sTime;
                    }
                } else {
                    LOGGER.debug((Object)("CompositeConnector|" + service.getId() + "|Service Time is Not a Number"));
                }
                serviceTimesTable.remove(serv.getId() + "_" + "serviceTimeInMillis");
            }
            if (totalServiceTime == 0L) {
                totalServiceTime = endTime - startTime;
            }
            LOGGER.debug((Object)("-----------------------END<Service:" + service.getId() + "; Execution Type:" + execType + "; Total Time:" + (endTime - startTime) + "; Service Time:" + totalServiceTime + ">END----------------------"));
        }
        Result finalResult = this.unifyResults(results, uniqueKeys);
        if (LOGGER.isDebugEnabled()) {
            try {
                LOGGER.debug((Object)("Result from Composite Connector before Post Processor - " + ResultToJSON.debugConvert((Result)finalResult)));
            }
            catch (Exception e) {
                LOGGER.error((Object)"error occurred in composite connector", (Throwable)e);
            }
        }
        if (finalResult != null) {
            AppVersion appVersion = MiddlewareUtils.getAppVersionFromService(service);
            finalResult = PostProcessUtils.execute(service, configMap, finalResult, request, response, appVersion);
        }
        return finalResult;
    }

    public Result unifyResults(List<Result> results, String uniqueKeys) {
        int successfulServices = 0;
        Result finalResult = new Result();
        LOGGER.debug((Object)("Total no. of results : " + results.size()));
        HashMap<String, Map<String, Record>> dsRecordMap = new HashMap<String, Map<String, Record>>();
        ArrayList<String> ukeysList = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)uniqueKeys)) {
            StringTokenizer st = new StringTokenizer(uniqueKeys, ",");
            while (st.hasMoreElements()) {
                ukeysList.add(st.nextToken().trim());
            }
        }
        for (Result result : results) {
            if (result == null) continue;
            for (Param sparam : result.getAllParams()) {
                Param existParam = finalResult.getParamByName(sparam.getName());
                if (existParam == null) {
                    finalResult.addParam(sparam);
                }
                if (!OPSTATUS.equals(sparam.getName()) || !"0".equals(sparam.getValue())) continue;
                ++successfulServices;
            }
            for (Dataset sDataset : result.getAllDatasets()) {
                Dataset existDataset = finalResult.getDatasetById(sDataset.getId());
                if (existDataset == null) {
                    finalResult.addDataset(sDataset);
                    if (ukeysList.isEmpty()) continue;
                    dsRecordMap.put(sDataset.getId(), this.prepareRecordMap(sDataset.getAllRecords(), ukeysList));
                    continue;
                }
                if (ukeysList.isEmpty()) {
                    existDataset.addAllRecords((Collection)sDataset.getAllRecords());
                    continue;
                }
                List<Record> extraRecords = this.mergeRecordsByKeys(sDataset.getAllRecords(), ukeysList, (Map)dsRecordMap.get(existDataset.getId()));
                existDataset.addAllRecords(extraRecords);
            }
            HashMap<String, Record> recordsMap = new HashMap<String, Record>();
            for (Record srecord : result.getAllRecords()) {
                Record existRecord = finalResult.getRecordById(srecord.getId());
                if (existRecord == null) {
                    finalResult.addRecord(srecord);
                    if (ukeysList.isEmpty()) continue;
                    recordsMap.putAll(this.prepareRecordMap(finalResult.getAllRecords(), ukeysList));
                    continue;
                }
                if (ukeysList.isEmpty()) {
                    existRecord.addAllRecords((Collection)srecord.getAllRecords());
                    continue;
                }
                List<Record> extraRecords = this.mergeRecordsByKeys(srecord.getAllRecords(), ukeysList, recordsMap);
                existRecord.addAllRecords(extraRecords);
            }
        }
        if (successfulServices < results.size()) {
            CompositeConnectorHandler.addFailedopstatusForCompositeService(finalResult);
        }
        return finalResult;
    }

    private Map<String, Record> prepareRecordMap(List<Record> resultRecords, List<String> ukeysList) {
        HashMap<String, Record> recordsMap = new HashMap<String, Record>();
        for (Record existRecord : resultRecords) {
            recordsMap.put(this.getRecordHash(existRecord, ukeysList), existRecord);
        }
        return recordsMap;
    }

    private String getRecordHash(Record record, List<String> ukeysList) {
        StringBuilder sb = new StringBuilder();
        for (String key : ukeysList) {
            if (!sb.toString().isEmpty()) {
                sb.append("|");
            }
            sb.append(key + "#" + record.getParam(key).getValue());
        }
        return sb.toString();
    }

    private List<Record> mergeRecordsByKeys(List<Record> records, List<String> ukeysList, Map<String, Record> recordMap) {
        ArrayList<Record> extraRecords = new ArrayList<Record>();
        for (Record record : records) {
            Record existRecord = recordMap.get(this.getRecordHash(record, ukeysList));
            if (existRecord != null) {
                CompositeConnectorHandler.mergeRecords(existRecord, record);
                continue;
            }
            recordMap.put(this.getRecordHash(record, ukeysList), record);
            extraRecords.add(record);
        }
        return extraRecords;
    }

    private Result setMiddlewareStatusCodes(Result result, Service service, String execType) {
        Param faultcode;
        Param errmsg;
        Param opstatus = result.getParamByName(OPSTATUS);
        if (opstatus != null) {
            Param newOpstatus = new Param("opstatus_" + service.getId(), opstatus.getValue(), INT_CONST);
            result.addParam(newOpstatus);
        }
        if ((errmsg = result.getParamByName(ERRMSG)) != null) {
            Param newErrmsg = new Param("errmsg_" + service.getId(), errmsg.getValue(), "string");
            result.addParam(newErrmsg);
        }
        if ((faultcode = result.getParamByName("faultcode")) != null) {
            Param newErrmsg = new Param("faultcode_" + service.getId(), faultcode.getValue(), "string");
            result.addParam(newErrmsg);
            if (!"Sequential".equalsIgnoreCase(execType)) {
                result.removeParam(faultcode);
            }
        }
        return result;
    }

    public class ServiceTask
    implements Callable<Result> {
        private Service srvc = null;
        private DataControllerRequest request = null;
        private DataControllerResponse response = null;
        private Stack<String> ndcStack = null;
        private String execType = null;

        public void setServiceExecInfo(Service service, DataControllerRequest request, DataControllerResponse response, Stack<String> ndcStack, String execType) {
            this.srvc = service;
            this.request = request;
            this.response = response;
            this.ndcStack = ndcStack;
            this.execType = execType;
        }

        @Override
        public Result call() {
            NDC.inherit(this.ndcStack);
            Result result = null;
            try {
                result = CompositeConnector.this.invokeService("CompositeConnector", this.srvc, this.request, this.response);
            }
            catch (ConnectorException ex) {
                String csrID = CSRIssueLogger.generateCSRID();
                result = CompositeConnectorHandler.prepareResultOnExceptionForOrchestrationService(this.request, ex);
                Session session = this.request.getSession(false);
                CSRIssueLogger.logCSRIssue(csrID, ex.getErrorCode(), session != null ? session.getId() : null, Calendar.getInstance().getTime(), ex.getMessage());
                MaskUtils.maskTrace((String)ex.getMessage(), (Throwable)ex);
            }
            result = CompositeConnector.this.setMiddlewareStatusCodes(result, this.srvc, this.execType);
            return result;
        }
    }
}

