/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors;

import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.registry.vo.Dataset;
import com.konylabs.middleware.registry.vo.Param;
import com.konylabs.middleware.registry.vo.Record;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.registry.vo.ServiceInput;
import com.konylabs.middleware.session.Session;
import com.konylabs.middleware.utilities.MaskUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConnectorJsonUtils {
    private final String connectorName;
    private static final Logger LOGGER = Logger.getLogger(ConnectorJsonUtils.class);

    public ConnectorJsonUtils(String connectorName) {
        this.connectorName = connectorName;
    }

    public HashMap<String, Object> processInputParam(Service service, DataControllerRequest request) {
        ServiceInput serviceInput = service.getServiceInput();
        ArrayList params = serviceInput.getParams();
        ArrayList records = serviceInput.getRecords();
        ArrayList datasets = serviceInput.getDatasets();
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        LOGGER.debug((Object)("Param Size : " + params.size()));
        LOGGER.debug((Object)("Record Size : " + records.size()));
        LOGGER.debug((Object)("Dataset Size : " + datasets.size()));
        String serviceId = service.getId();
        try {
            this.populateParams(request, params, inputMap);
            this.populateRecords(request, records, inputMap);
            this.populateDatasets(request, datasets, inputMap);
        }
        catch (ConnectorException e) {
            LOGGER.error((Object)("Connector exception for input params of service " + serviceId), (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception for input params of service " + serviceId), (Throwable)e);
        }
        return inputMap;
    }

    private void populateParams(DataControllerRequest request, ArrayList<Param> params, HashMap<String, Object> inputMap) throws ConnectorException {
        Session session;
        String serviceId = null;
        if (request != null) {
            serviceId = request.getParameter("serviceID");
        }
        if ((session = request.getSession(false)) == null) {
            if (serviceId != null) {
                LOGGER.error((Object)("Very rare scenario. Did not find an exisitng session when in scrapping connector for service " + serviceId));
            } else {
                LOGGER.error((Object)"Very rare scenario. Did not find an exisitng session when in scrapping connector");
            }
        }
        for (Param param : params) {
            Object paramValue;
            String source = param.getSource();
            String paramName = param.getName();
            if (source == null || source.trim().length() == 0 || "request".equals(source)) {
                paramValue = request.getParameter(paramName);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Param Source : " + source + " Name: " + paramName));
                    LOGGER.debug((Object)("Param Value : " + MaskUtils.maskParamValue((String)paramName, (String)paramValue)));
                }
                inputMap.put(paramName, paramValue);
                continue;
            }
            if ("session".equals(source)) {
                paramValue = session.getAttribute(paramName);
                MaskUtils.logDebugWithMasking((String)"Param", (String)paramName, (String)String.valueOf(paramValue));
                inputMap.put(paramName, paramValue);
                continue;
            }
            LOGGER.debug((Object)("Invalid source type " + source + " while preparing request for scraping service"));
            if (serviceId != null) {
                throw new ConnectorException(this.connectorName, "8804", "Invalid source to the param for " + paramName + " for service " + serviceId);
            }
            throw new ConnectorException(this.connectorName, "8804", "Invalid source to the param for " + paramName);
        }
    }

    private void populateRecords(DataControllerRequest request, ArrayList<Record> records, HashMap<String, Object> inputMap) throws ConnectorException {
        Session session;
        String serviceId = null;
        if (request != null) {
            serviceId = request.getParameter("serviceID");
        }
        if ((session = request.getSession(false)) == null) {
            if (serviceId != null) {
                LOGGER.error((Object)("Very rare scenario. Did not find an exisitng session when in scrapping connector for service " + serviceId));
            } else {
                LOGGER.error((Object)"Very rare scenario. Did not find an exisitng session when in scrapping connector");
            }
        }
        for (Record record : records) {
            Object paramValue;
            String source = record.getSource();
            String paramName = record.getId();
            if (source == null || source.trim().length() == 0 || "request".equals(source)) {
                paramValue = request.getParameter(paramName);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Record Source : " + source + " Name: " + paramName));
                    LOGGER.debug((Object)("Record Value : " + MaskUtils.maskParamValue((String)paramName, (String)paramValue)));
                }
                if (!StringUtils.isNotEmpty((String)paramValue)) continue;
                com.konylabs.middleware.dataobject.Record convertedRecord = this.convertJSON2Record((String)paramValue, record.getId());
                inputMap.put(paramName, convertedRecord);
                continue;
            }
            if ("session".equals(source)) {
                paramValue = session.getAttribute(paramName);
                MaskUtils.logDebugWithMasking((String)"Record", (String)paramName, (String)String.valueOf(paramValue));
                inputMap.put(paramName, paramValue);
                continue;
            }
            LOGGER.debug((Object)("Invalid source type " + source + " while preparing request for scraping service " + serviceId));
            if (serviceId != null) {
                throw new ConnectorException(this.connectorName, "8805", "Invalid source to the param for  " + paramName + " for service " + serviceId);
            }
            throw new ConnectorException(this.connectorName, "8805", "Invalid source to the param for  " + paramName);
        }
    }

    private void populateDatasets(DataControllerRequest request, ArrayList<Dataset> datasets, HashMap<String, Object> inputMap) throws ConnectorException {
        Session session;
        String serviceId = null;
        if (request != null) {
            serviceId = request.getParameter("serviceID");
        }
        if ((session = request.getSession(false)) == null) {
            if (serviceId != null) {
                LOGGER.error((Object)("Very rare scenario. Did not find an exisitng session when in scrapping connector for service " + serviceId));
            } else {
                LOGGER.error((Object)"Very rare scenario. Did not find an exisitng session when in scrapping connector.");
            }
        }
        for (Dataset dataset : datasets) {
            Object paramValue;
            String source = dataset.getSource();
            String paramName = dataset.getId();
            if (source == null || source.trim().length() == 0 || "request".equals(source)) {
                paramValue = request.getParameter(paramName);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Record Source : " + source + " Name: " + paramName));
                    LOGGER.debug((Object)("Record Value : " + MaskUtils.maskParamValue((String)paramName, (String)paramValue)));
                }
                if (!StringUtils.isNotEmpty((String)paramValue)) continue;
                com.konylabs.middleware.dataobject.Dataset convertedDataset = this.convertJSON2Dataset((String)paramValue, paramName);
                inputMap.put(paramName, convertedDataset);
                continue;
            }
            if ("session".equals(source)) {
                paramValue = session.getAttribute(paramName);
                MaskUtils.logDebugWithMasking((String)"Record", (String)paramName, (String)String.valueOf(paramValue));
                inputMap.put(paramName, paramValue);
                continue;
            }
            LOGGER.debug((Object)("Invalid source type " + source + " while preparing request for scraping service " + serviceId));
            if (serviceId != null) {
                throw new ConnectorException(this.connectorName, "8806", "Invalid source to the param for  " + paramName + " for service " + serviceId);
            }
            throw new ConnectorException(this.connectorName, "8806", "Invalid source to the param for  " + paramName);
        }
    }

    private com.konylabs.middleware.dataobject.Record convertJSON2Record(String jsonString, String id) {
        com.konylabs.middleware.dataobject.Record record = new com.konylabs.middleware.dataobject.Record();
        record.setId(id);
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            Iterator it = jsonObject.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                record.addParam(new com.konylabs.middleware.dataobject.Param(key, jsonObject.getString(key)));
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"JSON to Record conversion exception", (Throwable)ex);
        }
        return record;
    }

    private com.konylabs.middleware.dataobject.Dataset convertJSON2Dataset(String jsonString, String id) {
        com.konylabs.middleware.dataobject.Dataset dataset = new com.konylabs.middleware.dataobject.Dataset();
        dataset.setId(id);
        try {
            JSONArray jsonArray = new JSONArray(jsonString);
            if (jsonArray != null) {
                for (int idx = 0; idx < jsonArray.length(); ++idx) {
                    JSONObject jsonObj = (JSONObject)jsonArray.get(idx);
                    com.konylabs.middleware.dataobject.Record record = new com.konylabs.middleware.dataobject.Record();
                    Iterator it = jsonObj.keys();
                    while (it.hasNext()) {
                        String chKey = (String)it.next();
                        Object obj = jsonObj.get(chKey);
                        if (obj instanceof JSONArray) {
                            com.konylabs.middleware.dataobject.Dataset dset = new com.konylabs.middleware.dataobject.Dataset();
                            dset.setId(chKey);
                            com.konylabs.middleware.dataobject.Record rec = new com.konylabs.middleware.dataobject.Record();
                            for (int i = 0; i < ((JSONArray)obj).length(); ++i) {
                                rec = new com.konylabs.middleware.dataobject.Record();
                                JSONObject jsonOb = (JSONObject)((JSONArray)obj).get(i);
                                Iterator j = jsonOb.keys();
                                while (j.hasNext()) {
                                    String chhKey = (String)j.next();
                                    rec.addParam(new com.konylabs.middleware.dataobject.Param(chhKey, jsonOb.getString(chhKey)));
                                }
                                if (rec.getAllParams().size() <= 0) continue;
                                dset.addRecord(rec);
                            }
                            record.addDataset(dset);
                            continue;
                        }
                        record.addParam(new com.konylabs.middleware.dataobject.Param(chKey, jsonObj.getString(chKey)));
                    }
                    dataset.addRecord(record);
                }
            }
        }
        catch (JSONException jExe) {
            LOGGER.error((Object)"JSON to Dataset conversion exception", (Throwable)jExe);
        }
        return dataset;
    }
}

