/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors;

import com.kony.adapter.event.DataAdapterEvent;
import com.kony.adapter.event.DataAdapterEventNotifier;
import com.kony.adapter.event.DataAdapterEventType;
import com.kony.adapter.event.EventDetail;
import com.kony.middleware.dbcommons.entity.ServerCertificate;
import com.kony.mobilefabric.logger.DiagnosticContext;
import com.konylabs.middleware.cache.CacheUtils;
import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.common.MWConstants;
import com.konylabs.middleware.connectors.CustomCredentialsProvider;
import com.konylabs.middleware.connectors.CustomNTLMSchemeFactory;
import com.konylabs.middleware.connectors.DefaultSSLContextFactory;
import com.konylabs.middleware.connectors.ProxyUtil;
import com.konylabs.middleware.connectors.SSLProperties;
import com.konylabs.middleware.connectors.io.IServiceInputHandler;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.ehcache.ResultCache;
import com.konylabs.middleware.environment.EnvironmentFactory;
import com.konylabs.middleware.event.impl.HttpRequestEventImpl;
import com.konylabs.middleware.event.impl.HttpResponseEventImpl;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.session.Session;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.EncodeUtils;
import com.konylabs.middleware.utilities.MapperUtility;
import com.konylabs.middleware.utilities.MaskUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import com.konylabs.middleware.utilities.TemplateUtils;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.DeflateDecompressingEntity;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.NTLMSchemeFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;

public final class ConnectorUtils {
    private static final Logger LOGGER = Logger.getLogger(ConnectorUtils.class);
    private static final String CONFIG_PROP_GZIP_COMPRESSION_ENABLED = "gzipCompressionEnabled";
    public static final String EMPTY_STRING = "";
    public static final String PROXY_HOST = System.getProperty("http.proxyHost");
    public static final String PROXY_PORT = System.getProperty("http.proxyPort");
    public static final String PROXY_USERID = System.getProperty("http.proxyUser");
    public static final String PROXY_PWD = System.getProperty("http.proxyPassword");
    public static final String SOCKET_TIMEOUT = "sockettimeout";
    private static final String DOLLAR_SYMBOL = "$";
    private static CloseableHttpClient httpClient = null;
    private static int maxHttpConnectionsPerHost = 500;
    private static int maxTotalHttpConnections = 2000;
    private static final String LOCATION = "location";
    private static final String ALLOW_ALL_HOSTNAME_VERIFIER = "ALLOW_ALL_HOSTNAME_VERIFIER";
    private static final String STRICT_HOSTNAME_VERIFIER = "STRICT_HOSTNAME_VERIFIER";
    private static final String NT_JCIFS = "jcifs";
    private static final String NT_DOMAIN = "domain";
    private static final String NT_HOSTNAME = "hname";
    public static final String USERID_SVC = "userid";
    public static final String P_SVC = "pwd";
    public static final String SERVER_AUTH_HOST = "server.auth.host";
    public static final String SERVER_AUTH_NTLM_DOMAIN = "server.auth.ntlm.domain";
    public static final String SERVER_AUTH_MODE = "server.auth.mode";
    private static final String AUTHENTICATION_MODE_NTLM = "ntlm";
    private static final String RETRY_COUNT = "retrycount";
    private static final int DEFAULT_RETRY_COUNT = 0;
    private static Registry<ConnectionSocketFactory> sr = null;

    private static synchronized void initializeRegistry() {
        SSLConnectionSocketFactory sslFactory = null;
        DefaultSSLContextFactory.initializeConnectionFactory();
        SSLContext context = DefaultSSLContextFactory.getSSLContext();
        if (context != null) {
            String sslSocketVerifier = (String)SSLProperties.HOSTNAME_VERIFIER.getFromConfig();
            sslFactory = ALLOW_ALL_HOSTNAME_VERIFIER.equalsIgnoreCase(sslSocketVerifier) ? new SSLConnectionSocketFactory(context, (HostnameVerifier)NoopHostnameVerifier.INSTANCE) : (STRICT_HOSTNAME_VERIFIER.equalsIgnoreCase(sslSocketVerifier) ? new SSLConnectionSocketFactory(context, (HostnameVerifier)new DefaultHostnameVerifier()) : new SSLConnectionSocketFactory(context, (HostnameVerifier)new DefaultHostnameVerifier()));
            LOGGER.debug((Object)(sslSocketVerifier + " configured as ssl factory host name verifier."));
        } else {
            sslFactory = SSLConnectionSocketFactory.getSocketFactory();
        }
        sr = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslFactory).build();
    }

    public static synchronized void initialize() {
        ConnectorUtils.initializeRegistry();
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setCharset(Consts.UTF_8).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(sr);
        connManager.setDefaultMaxPerRoute(maxHttpConnectionsPerHost);
        connManager.setMaxTotal(maxTotalHttpConnections);
        connManager.setDefaultConnectionConfig(connectionConfig);
        IdleConnectionTimeoutThread idleConnectionTimeoutThread = IdleConnectionTimeoutThread.getInstance(connManager, 15000L);
        if (!idleConnectionTimeoutThread.isAlive() && !idleConnectionTimeoutThread.isExecuted()) {
            idleConnectionTimeoutThread.start();
        }
        RequestConfig requestConfig = RequestConfig.custom().setRedirectsEnabled(true).build();
        Registry authSchemeRegistry = null;
        String ntlmScheme = System.getProperty("ntlm.engine", EMPTY_STRING);
        authSchemeRegistry = NT_JCIFS.equalsIgnoreCase(ntlmScheme) ? RegistryBuilder.create().register("NTLM", (Object)new CustomNTLMSchemeFactory()).build() : RegistryBuilder.create().register("NTLM", (Object)new NTLMSchemeFactory()).build();
        DefaultHttpRequestRetryHandler retryHandler = ConnectorUtils.getRetryHandler();
        HttpClientBuilder clientBuilder = HttpClients.custom();
        if (Boolean.parseBoolean(ConfigUtility.getProperty((String)CONFIG_PROP_GZIP_COMPRESSION_ENABLED))) {
            GzipCompressionInterceptor interceptor = new GzipCompressionInterceptor();
            clientBuilder.addInterceptorFirst((HttpRequestInterceptor)interceptor);
            clientBuilder.addInterceptorFirst((HttpResponseInterceptor)interceptor);
        }
        httpClient = clientBuilder.setConnectionManager((HttpClientConnectionManager)connManager).setConnectionTimeToLive(30000L, TimeUnit.MILLISECONDS).setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry).setRetryHandler((HttpRequestRetryHandler)retryHandler).setDefaultRequestConfig(requestConfig).setConnectionManagerShared(true).build();
    }

    public static CloseableHttpClient getSingleHttpClient() {
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setCharset(Consts.UTF_8).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(sr);
        connManager.setDefaultConnectionConfig(connectionConfig);
        HttpClientBuilder clientBuilder = HttpClients.custom();
        Registry authSchemeRegistry = null;
        String ntlmScheme = System.getProperty("ntlm.engine", EMPTY_STRING);
        authSchemeRegistry = NT_JCIFS.equalsIgnoreCase(ntlmScheme) ? RegistryBuilder.create().register("NTLM", (Object)new CustomNTLMSchemeFactory()).build() : RegistryBuilder.create().register("NTLM", (Object)new NTLMSchemeFactory()).build();
        if (Boolean.parseBoolean(ConfigUtility.getProperty((String)CONFIG_PROP_GZIP_COMPRESSION_ENABLED))) {
            GzipCompressionInterceptor interceptor = new GzipCompressionInterceptor();
            clientBuilder.addInterceptorFirst((HttpRequestInterceptor)interceptor);
            clientBuilder.addInterceptorFirst((HttpResponseInterceptor)interceptor);
        }
        DefaultHttpRequestRetryHandler retryHandler = ConnectorUtils.getRetryHandler();
        return clientBuilder.setConnectionManager((HttpClientConnectionManager)connManager).setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry).setRetryHandler((HttpRequestRetryHandler)retryHandler).setConnectionManagerShared(true).build();
    }

    public static void executeHttpMethod(HttpRequestBase uriRequest, Map configMap, DataControllerRequest request, DataControllerResponse response, String requestEncoding, DataAdapterEventNotifier notifier) throws Exception {
        uriRequest.getParams().setParameter("http.useragent", (Object)ConnectorUtils.getUserAgent(request));
        Session session = request.getSession();
        ArrayList<BasicClientCookie> includeCookies = new ArrayList<BasicClientCookie>();
        String includeCookieConfigName = (String)configMap.get("includecookies");
        if (includeCookieConfigName != null && !includeCookieConfigName.trim().isEmpty()) {
            List<String> includeCookieNames = Arrays.asList(includeCookieConfigName.split("\\s*,\\s*"));
            LOGGER.debug((Object)("Include Cookies Names :: " + includeCookieNames));
            Map apcaheCookiesMap = request.getCookies();
            if (apcaheCookiesMap != null && !apcaheCookiesMap.isEmpty()) {
                block2: for (String includeName : includeCookieNames) {
                    for (Map.Entry entry : apcaheCookiesMap.entrySet()) {
                        if (!((String)entry.getKey()).equalsIgnoreCase(includeName)) continue;
                        BasicClientCookie cookie = (BasicClientCookie)entry.getValue();
                        BasicClientCookie clonedCookie = null;
                        try {
                            clonedCookie = (BasicClientCookie)cookie.clone();
                        }
                        catch (CloneNotSupportedException cnse) {
                            throw new Exception("Exception occurred in include cookie operation while cloning the cookie");
                        }
                        clonedCookie.setDomain(ConnectorUtils.getConsolidatedFromEndpointAndCookieDomain((HttpUriRequest)uriRequest, clonedCookie.getDomain()));
                        includeCookies.add(clonedCookie);
                        continue block2;
                    }
                }
                if (!includeCookies.isEmpty()) {
                    session.addEISCookies(includeCookies);
                }
            }
        }
        BasicCookieStore cookieStore = new BasicCookieStore();
        if (session != null) {
            List cookies = session.getEISCookies();
            for (int i = 0; i < cookies.size(); ++i) {
                Cookie cookie = (Cookie)cookies.get(i);
                cookieStore.addCookie(cookie);
                MaskUtils.logDebugWithMasking((String)"Cookies in request", (String)"cookies", (String)cookie.getValue());
            }
        }
        HttpResponse httpResponse = ConnectorUtils.executeMethodAndRetrieveCookies(httpClient, uriRequest, response, configMap, (CookieStore)cookieStore, requestEncoding, request, notifier);
        ConnectorUtils.setSessionForNTLM(request);
        session.addEISCookies(response.getCookies());
        request.setAttribute("responseEncoding", (Object)response.getCharsetEncoding());
        ConnectorUtils.populateMDCWithSpecialHeaders(httpResponse);
    }

    private static String getConsolidatedFromEndpointAndCookieDomain(HttpUriRequest uriRequest, String cookieDomain) {
        String endpointDomian = null;
        if (uriRequest != null) {
            endpointDomian = ConnectorUtils.getDomainForURL(uriRequest);
        }
        if (cookieDomain != null && endpointDomian != null && endpointDomian.endsWith(cookieDomain)) {
            return cookieDomain;
        }
        return endpointDomian;
    }

    private static String getDomainForURL(HttpUriRequest uriRequest) {
        URI uri = uriRequest.getURI();
        String host = uri.getHost();
        return host.startsWith("www.") ? host.substring(4) : host;
    }

    public static HttpResponse executeMethodAndRetrieveCookies(CloseableHttpClient defaultHttpClient, HttpRequestBase uriRequest, DataControllerResponse response, Map configMap, CookieStore cookieStore, String requestEncoding, DataControllerRequest request) throws IOException {
        return ConnectorUtils.executeMethodAndRetrieveCookies(defaultHttpClient, uriRequest, response, configMap, cookieStore, requestEncoding, request, null);
    }

    public static HttpResponse executeMethodAndRetrieveCookies(CloseableHttpClient defaultHttpClient, HttpRequestBase uriRequest, DataControllerResponse response, Map configMap, CookieStore cookieStore, String requestEncoding, DataControllerRequest request, DataAdapterEventNotifier notifier) throws IOException {
        CloseableHttpResponse httpResponse;
        String authUser = (String)configMap.get(USERID_SVC);
        String authPwd = (String)configMap.get(P_SVC);
        String authMode = (String)configMap.get(SERVER_AUTH_MODE);
        String ntlmHost = (String)configMap.get(SERVER_AUTH_HOST);
        String ntlmDomain = (String)configMap.get(SERVER_AUTH_NTLM_DOMAIN);
        boolean isNtlm = AUTHENTICATION_MODE_NTLM.equalsIgnoreCase(authMode);
        String connTimeOutConfig = (String)configMap.get(SOCKET_TIMEOUT);
        String IGNORE_HTTP_PROXY = (String)configMap.get("ignorehttpproxy");
        boolean isResPassThru = Boolean.parseBoolean(configMap.get("isResPassThru") != null ? configMap.get("isResPassThru").toString() : "false");
        requestEncoding = EncodeUtils.getEncodingOrDefault((Object)requestEncoding);
        LOGGER.debug((Object)("isNtlm Authentication Mode " + isNtlm));
        LOGGER.debug((Object)("Using: " + requestEncoding + " to encode the request."));
        uriRequest.getParams().setParameter("http.protocol.content-charset", (Object)requestEncoding);
        Integer connTimeOut = MWConstants.DEFAULT_TIMEOUT_VALUE;
        if (StringUtils.isNotBlank((String)connTimeOutConfig)) {
            connTimeOut = Integer.valueOf(connTimeOutConfig);
        }
        RequestConfig.Builder requestConfigBuilder = uriRequest.getConfig() != null ? RequestConfig.copy((RequestConfig)uriRequest.getConfig()) : RequestConfig.custom();
        RequestConfig requestConfig = requestConfigBuilder.setConnectTimeout(connTimeOut.intValue()).setSocketTimeout(connTimeOut.intValue()).build();
        uriRequest.setConfig(requestConfig);
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.cookie-store", (Object)cookieStore);
        String retryCountConfigParm = (String)configMap.get(RETRY_COUNT);
        int retryCount = -1;
        if (StringUtils.isNotBlank((String)retryCountConfigParm)) {
            try {
                retryCount = Integer.parseInt(retryCountConfigParm.trim());
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)("Invalid value found for retrycount " + retryCountConfigParm), (Throwable)e);
            }
        }
        context.setAttribute(RETRY_COUNT, (Object)(retryCount >= 0 ? retryCount : 0));
        if (request != null) {
            Session session = request.getSession();
            if (request.getParameter(USERID_SVC) != null) {
                authUser = request.getParameter(USERID_SVC);
            } else if (session != null && session.getAttribute(USERID_SVC) != null) {
                authUser = (String)session.getAttribute(USERID_SVC);
            }
            if (request.getParameter(P_SVC) != null) {
                authPwd = request.getParameter(P_SVC);
            } else if (session != null && session.getAttribute(P_SVC) != null) {
                authPwd = (String)session.getAttribute(P_SVC);
            }
            if (request.getParameter(NT_DOMAIN) != null) {
                ntlmDomain = request.getParameter(NT_DOMAIN);
            } else if (session != null && session.getAttribute(NT_DOMAIN) != null) {
                ntlmDomain = (String)session.getAttribute(NT_DOMAIN);
            }
            if (request.getParameter(NT_HOSTNAME) != null) {
                ntlmHost = request.getParameter(NT_HOSTNAME);
            } else if (session != null && session.getAttribute(NT_HOSTNAME) != null) {
                ntlmHost = (String)session.getAttribute(NT_HOSTNAME);
            }
        }
        if (isNtlm) {
            LOGGER.debug((Object)"NTLM Auth block is executing.");
            CustomCredentialsProvider cProvider = new CustomCredentialsProvider(authUser, authPwd, ntlmHost, ntlmDomain);
            context.setAttribute("http.auth.credentials-provider", (Object)cProvider);
        } else if (!StringUtils.isEmpty((String)authUser) && !StringUtils.isEmpty((String)authPwd)) {
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(authUser, authPwd);
            try {
                uriRequest.addHeader(new BasicScheme().authenticate((Credentials)defaultcreds, (HttpRequest)uriRequest, (HttpContext)context));
            }
            catch (AuthenticationException e) {
                LOGGER.error((Object)"Unable to add authentication creds", (Throwable)e);
            }
        }
        boolean ignoreHttpProxy = false;
        ignoreHttpProxy = Boolean.parseBoolean(IGNORE_HTTP_PROXY);
        LOGGER.debug((Object)("ignorehttpproxy flag " + ignoreHttpProxy));
        ProxyUtil.initProxy(uriRequest, (HttpContext)context, ignoreHttpProxy);
        if (defaultHttpClient == null) {
            throw new IOException("Error:: HTTP client is not initialized, please check SSL certificate correctly installed.");
        }
        if (notifier != null) {
            DataAdapterEvent requestEvent = new DataAdapterEvent(DataAdapterEventType.IntegrationServiceInput);
            requestEvent.addEventDetails("Request", (EventDetail)new HttpRequestEventImpl((HttpRequest)uriRequest));
            notifier.notify(requestEvent);
        }
        if ((httpResponse = defaultHttpClient.execute((HttpUriRequest)uriRequest, (HttpContext)context)) != null) {
            HttpEntity responseEntity = httpResponse.getEntity();
            Object responseEncoding = null;
            if (responseEntity != null && ContentType.get((HttpEntity)responseEntity) != null && ContentType.get((HttpEntity)responseEntity).getCharset() != null) {
                responseEncoding = ContentType.get((HttpEntity)responseEntity).getCharset().name();
            }
            responseEncoding = responseEncoding != null ? responseEncoding : EncodeUtils.getEncodingOrDefault(configMap.get("responseEncoding"));
            LOGGER.debug((Object)("Charset Encoding from response: " + (String)responseEncoding + ". Using encoding: " + (String)responseEncoding));
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (!isResPassThru) {
                String responseString = responseEntity == null ? EMPTY_STRING : EntityUtils.toString((HttpEntity)responseEntity, (String)"UTF-8");
                response.setResponse(responseString);
                if (notifier != null) {
                    DataAdapterEvent responseEvent = new DataAdapterEvent(DataAdapterEventType.IntegrationServiceOutput);
                    responseEvent.addEventDetails("Response", (EventDetail)new HttpResponseEventImpl((HttpResponse)httpResponse, responseString));
                    notifier.notify(responseEvent);
                }
            } else {
                response.setAttribute("chunkedresults_json", (Object)new BufferedHttpEntity(responseEntity));
            }
            response.setCharsetEncoding((String)responseEncoding);
            response.setStatusCode(statusCode);
        }
        List<Cookie> cookies = ConnectorUtils.retrieveCookies((HttpContext)context);
        if (LOGGER.isDebugEnabled()) {
            for (Cookie cookie : cookies) {
                LOGGER.debug((Object)("Cookie Name from response " + cookie.getName()));
                LOGGER.debug((Object)("Cookie Value from response " + cookie.getValue()));
            }
        }
        response.setCookies(cookies);
        Header header = httpResponse.getFirstHeader(LOCATION);
        String location = header != null ? header.getValue() : EMPTY_STRING;
        response.setLocation(location);
        Map<String, String> mapHeaders = ConnectorUtils.retriveHttpResponseHeaderMap((HttpResponse)httpResponse);
        response.setHeaders(mapHeaders);
        return httpResponse;
    }

    private static List<Cookie> retrieveCookies(HttpContext context) {
        List cookies;
        CookieStore cookieStore = (CookieStore)context.getAttribute("http.cookie-store");
        List list = cookies = cookieStore != null ? cookieStore.getCookies() : null;
        if (cookies != null && cookies.size() > 0 && LOGGER.isDebugEnabled()) {
            for (int i = 0; i < cookies.size(); ++i) {
                Cookie cookie = (Cookie)cookies.get(i);
                MaskUtils.logDebugWithMasking((String)"Cookies returned from response", (String)"cookies", (String)cookie.getValue());
            }
        }
        return cookies;
    }

    public static String buildEndPointURL(String endpointUrlStr, Map<String, Object> inputMap, Map configMap) {
        LOGGER.debug((Object)("Endpoint URL before replacing dollar params : " + endpointUrlStr));
        if (StringUtils.isNotBlank((String)endpointUrlStr)) {
            String requestEncoding = EncodeUtils.getEncodingOrDefault(configMap.get("responseEncoding"));
            try {
                if (endpointUrlStr.indexOf(DOLLAR_SYMBOL) != -1 && inputMap != null && inputMap.size() > 0) {
                    endpointUrlStr = TemplateUtils.substituteEndpointUrl(requestEncoding, endpointUrlStr, inputMap);
                }
            }
            catch (ConnectorException c) {
                MaskUtils.maskTrace((String)c.getMessage(), (Throwable)c);
            }
        }
        LOGGER.debug((Object)("Final Endpoint URL : " + endpointUrlStr));
        return endpointUrlStr;
    }

    private static String getUserAgent(DataControllerRequest request) {
        HttpServletRequest req;
        String ua = "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.9.1.7) Gecko/20091221 Firefox/3.5.7 (.NET CLR 3.5.30729)";
        if (ConfigUtility.getBoolean((String)"send.default.user.agent", (boolean)false)) {
            return ua;
        }
        if (request.getOriginalRequest() != null && (req = (HttpServletRequest)request.getOriginalRequest()) != null && req.getHeader("user-agent") != null) {
            ua = req.getHeader("user-agent");
        }
        LOGGER.debug((Object)("User Agent that will sent by server is :" + ua));
        return ua;
    }

    private static void populateMDCWithSpecialHeaders(HttpResponse response) {
        Set<String> responseNDCParams = MiddlewareUtils.splitAndRemoveBlank("log.specific.response.header", ",");
        if (responseNDCParams.size() > 0) {
            for (String s : responseNDCParams) {
                Header[] headers = response.getHeaders(s);
                if (headers == null) continue;
                for (Header header : headers) {
                    if (header == null) continue;
                    DiagnosticContext.addCustomFields((String)s, (String)header.getValue());
                }
            }
        }
    }

    public static String forXML(String aText) {
        String escLessThan = "&lt;";
        String escGreaterThan = "&gt;";
        String escDoubleQuote = "&quot;";
        String escSingleQuote = "&#039;";
        String escAmpersand = "&amp;";
        String escapeChars = ConfigUtility.getProperty((String)"dontEscapeXMLSpecialChars");
        String[] chars = new String[]{};
        if (escapeChars != null && escapeChars.length() > 0) {
            chars = escapeChars.trim().split(",");
        }
        StringBuilder result = new StringBuilder();
        if (aText != null && aText.trim().length() > 0) {
            StringCharacterIterator iterator = new StringCharacterIterator(aText);
            char character = iterator.current();
            while (character != '\uffff') {
                if (chars.length > 0) {
                    int i;
                    boolean checked;
                    if (character == '<') {
                        checked = false;
                        for (i = 0; i < chars.length; ++i) {
                            if (!"<".equals(chars[i])) continue;
                            result.append(character);
                            checked = true;
                            break;
                        }
                        if (!checked) {
                            result.append("&lt;");
                        }
                    } else if (character == '>') {
                        checked = false;
                        for (i = 0; i < chars.length; ++i) {
                            if (!">".equals(chars[i])) continue;
                            result.append(character);
                            checked = true;
                            break;
                        }
                        if (!checked) {
                            result.append("&gt;");
                        }
                    } else if (character == '\"') {
                        checked = false;
                        for (i = 0; i < chars.length; ++i) {
                            if (!"\"".equals(chars[i])) continue;
                            result.append(character);
                            checked = true;
                            break;
                        }
                        if (!checked) {
                            result.append("&quot;");
                        }
                    } else if (character == '\'') {
                        checked = false;
                        for (i = 0; i < chars.length; ++i) {
                            if (!"'".equals(chars[i])) continue;
                            result.append(character);
                            checked = true;
                            break;
                        }
                        if (!checked) {
                            result.append("&#039;");
                        }
                    } else if (character == '&') {
                        checked = false;
                        for (i = 0; i < chars.length; ++i) {
                            if (!"&".equals(chars[i])) continue;
                            result.append(character);
                            checked = true;
                            break;
                        }
                        if (!checked) {
                            result.append("&amp;");
                        }
                    } else {
                        result.append(character);
                    }
                } else if (character == '<') {
                    result.append("&lt;");
                } else if (character == '>') {
                    result.append("&gt;");
                } else if (character == '\"') {
                    result.append("&quot;");
                } else if (character == '\'') {
                    result.append("&#039;");
                } else if (character == '&') {
                    result.append("&amp;");
                } else {
                    result.append(character);
                }
                character = iterator.next();
            }
        }
        return result.toString();
    }

    public static void shutdown() {
        Closer.closeQuietly((Closeable)httpClient);
        IdleConnectionTimeoutThread timeoutThread = IdleConnectionTimeoutThread.getInstance();
        if (timeoutThread != null) {
            timeoutThread.shutdown();
        }
    }

    public static CloseableHttpClient getHttpClient() {
        return httpClient;
    }

    private static void setSessionForNTLM(DataControllerRequest request) {
        Session session = request.getSession();
        if (request.getParameter(USERID_SVC) != null) {
            session.setAttribute(USERID_SVC, (Object)request.getParameter(USERID_SVC));
        }
        if (request.getParameter(P_SVC) != null) {
            session.setAttribute(P_SVC, (Object)request.getParameter(P_SVC));
        }
        if (request.getParameter(NT_DOMAIN) != null) {
            session.setAttribute(NT_DOMAIN, (Object)request.getParameter(NT_DOMAIN));
        }
    }

    private static Map<String, String> retriveHttpResponseHeaderMap(HttpResponse httpResponse) {
        Header[] responseHeaders;
        HashMap<String, String> mapHeaders = null;
        if (httpResponse != null && (responseHeaders = httpResponse.getAllHeaders()).length > 0) {
            mapHeaders = new HashMap<String, String>();
            for (int i = 0; i < responseHeaders.length; ++i) {
                Header header = responseHeaders[i];
                mapHeaders.put(header.getName(), header.getValue());
            }
        }
        return mapHeaders;
    }

    public static Object getResultFromCache(DataControllerRequest request, ServiceMetadata serviceMetadata, Map<String, Object> inputMap, DataControllerResponse response) {
        Object result = null;
        try {
            ResultCache rcache = request.getServicesManager().getResultCache();
            if (rcache != null) {
                String key = ConnectorUtils.prepareResultCacheKey(request, serviceMetadata.getAppId(), serviceMetadata.getService().getId(), inputMap);
                result = rcache.retrieveFromCache(key);
                if (result != null) {
                    LOGGER.debug((Object)("Retrieved results from cache with cache key: " + key));
                    response.getDeviceHeaders().put("X-Kony-Result-From-Cache", "true");
                } else {
                    LOGGER.debug((Object)("Unable to retrieve results from cache with cache key: " + key));
                    response.getDeviceHeaders().put("X-Kony-Result-From-Cache", "false");
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while retreiving results from cache", (Throwable)e);
        }
        return result;
    }

    public static void insertResultsIntoCache(DataControllerRequest request, ServiceMetadata serviceMetadata, Map<String, Object> inputMap, Object result, int cacheduration) {
        try {
            ResultCache rcache = request.getServicesManager().getResultCache();
            if (rcache != null) {
                String resultCacheKey = ConnectorUtils.prepareResultCacheKey(request, serviceMetadata.getAppId(), serviceMetadata.getService().getId(), inputMap);
                rcache.insertIntoCache(resultCacheKey, result, cacheduration);
                LOGGER.debug((Object)("Inserted results into cache with cache key: " + resultCacheKey));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error while inserting results into cache", (Throwable)e);
        }
    }

    public static String prepareResultCacheKey(DataControllerRequest request, String appId, String serviceId, Map<String, Object> inputMap) {
        String cacheID = (String)inputMap.get("cacheid");
        if (StringUtils.isNotBlank((String)cacheID)) {
            inputMap.remove("cacheid");
        }
        String hashKey = String.join((CharSequence)"-", TenantUtilities.getTenantIdentifierFromDCReq(request), appId, serviceId, inputMap.hashCode() + EMPTY_STRING);
        LOGGER.debug((Object)("Hash key prepared from input map: " + inputMap + " is: " + hashKey));
        if (cacheID != null) {
            inputMap.put("cacheid", cacheID);
        }
        return hashKey;
    }

    public static HashMap<String, Object> getInputParam(IServiceInputHandler inputHandler, Service service, DataControllerRequest request, Map<String, Object> config) throws ConnectorException {
        HashMap<String, Object> inputParams = new HashMap<String, Object>();
        if (EnvironmentFactory.getEnvironment() != null && CacheUtils.isSesionDistributed().booleanValue()) {
            LOGGER.debug((Object)"Session is distributed");
            String cacheId = (String)request.getAttribute("cacheid");
            LOGGER.debug((Object)("Cacheid provided form middleware to scraper as a input param " + cacheId));
            inputParams.put("cacheid", cacheId);
        }
        if (!MapperUtility.isMapperInServiceInput(service) || MiddlewareUtils.isBinaryOperand(config)) {
            Map<String, Object> inputMap = inputHandler.getInputMap(request, config, service, null);
            inputParams.putAll(inputMap);
        }
        return inputParams;
    }

    public static void disableEnableRedirect(HttpRequestBase uriRequest, String checkHandleRedirect) {
        boolean handleRedirect = !"mr".equalsIgnoreCase(checkHandleRedirect);
        RequestConfig requestConfig = RequestConfig.custom().setRedirectsEnabled(handleRedirect).build();
        uriRequest.setConfig(requestConfig);
    }

    public static String updateQueryString(String urlString, DataControllerRequest request, Map<String, Object> configMap) {
        LOGGER.debug((Object)"Inside updateQueryString()");
        try {
            URI endPointURI;
            boolean isReqPassThru = Boolean.parseBoolean(configMap.get("isReqPassThru").toString());
            if (isReqPassThru && StringUtils.isBlank((String)(endPointURI = new URI(urlString)).getQuery())) {
                return StringUtils.isNotBlank((String)request.getQueryString()) ? urlString.concat("?").concat(request.getQueryString()) : urlString;
            }
        }
        catch (URISyntaxException e) {
            LOGGER.error((Object)"Exception while updating the query string", (Throwable)e);
        }
        return urlString;
    }

    private static void destroySilently() {
        LOGGER.debug((Object)"Closing the existing HttpClient");
        Closer.closeQuietly((Closeable)httpClient);
        httpClient = null;
    }

    public static void reinitializeWith(List<ServerCertificate> dynamicCerts) {
        ConnectorUtils.destroySilently();
        DefaultSSLContextFactory.setServerCertificates(dynamicCerts);
        LOGGER.debug((Object)"Reinitalizing the HttpClient with the uploaded certs.");
        ConnectorUtils.initialize();
        LOGGER.debug((Object)"HttpClient reinitialized with the uploaded certs.");
    }

    private static DefaultHttpRequestRetryHandler getRetryHandler() {
        return new DefaultHttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (context.getAttribute(ConnectorUtils.RETRY_COUNT) != null && executionCount > (Integer)context.getAttribute(ConnectorUtils.RETRY_COUNT)) {
                    return false;
                }
                if (exception instanceof SocketTimeoutException) {
                    return true;
                }
                return super.retryRequest(exception, executionCount, context);
            }
        };
    }

    private ConnectorUtils() {
    }

    static {
        maxHttpConnectionsPerHost = ConfigUtility.getIntProperty((String)"maxHttpConnectionsPerHost", (int)maxHttpConnectionsPerHost);
        maxTotalHttpConnections = ConfigUtility.getIntProperty((String)"maxTotalHttpConnections", (int)maxTotalHttpConnections);
    }

    private static class IdleConnectionTimeoutThread
    extends Thread {
        private static IdleConnectionTimeoutThread _this = null;
        private final PoolingHttpClientConnectionManager connMgr;
        private volatile boolean shutdown;
        private final long timeout;
        private final Object obj = new Object();
        private boolean isExecuted = false;

        public boolean isExecuted() {
            return this.isExecuted;
        }

        private IdleConnectionTimeoutThread(PoolingHttpClientConnectionManager connMgr, long timeout) {
            super("HttpClientIdleConnectionTimeoutThread");
            this.connMgr = connMgr;
            this.timeout = timeout;
        }

        static synchronized IdleConnectionTimeoutThread getInstance(PoolingHttpClientConnectionManager connMgr, long timeout) {
            if (_this == null) {
                _this = new IdleConnectionTimeoutThread(connMgr, timeout);
            }
            return _this;
        }

        public static IdleConnectionTimeoutThread getInstance() {
            return _this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.isExecuted = true;
            try {
                while (!this.shutdown) {
                    Object object = this.obj;
                    synchronized (object) {
                        this.obj.wait(this.timeout);
                    }
                    this.connMgr.closeExpiredConnections();
                    this.connMgr.closeIdleConnections(30L, TimeUnit.SECONDS);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdown() {
            this.shutdown = true;
            Object object = this.obj;
            synchronized (object) {
                this.obj.notifyAll();
            }
            _this = null;
        }
    }

    private static class GzipCompressionInterceptor
    implements HttpRequestInterceptor,
    HttpResponseInterceptor {
        private GzipCompressionInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            if (!request.containsHeader("Accept-Encoding")) {
                request.addHeader("Accept-Encoding", "gzip");
            }
        }

        public void process(HttpResponse response, HttpContext hc) throws HttpException, IOException {
            Header ceheader;
            HttpEntity entity = response.getEntity();
            if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
                HeaderElement[] codecs = ceheader.getElements();
                for (int i = 0; i < codecs.length; ++i) {
                    if (codecs[i].getName().equalsIgnoreCase("gzip")) {
                        response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                        return;
                    }
                    if (!codecs[i].getName().equalsIgnoreCase("deflate")) continue;
                    response.setEntity((HttpEntity)new DeflateDecompressingEntity(response.getEntity()));
                    return;
                }
            }
        }
    }
}

