/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.lang.StringUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.log4j.Logger;

public class CustomCredentialsProvider
implements CredentialsProvider {
    private static final Logger LOGGER = Logger.getLogger(CustomCredentialsProvider.class);
    private final String user;
    private final String pwd;
    private String host;
    private final String domain;

    public CustomCredentialsProvider(String user, String pwd, String host, String domain) {
        this.user = user;
        this.pwd = pwd;
        this.host = host;
        this.domain = domain;
    }

    public Credentials getCredentials(AuthScope authScope) {
        if (authScope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        if ("NTLM".equalsIgnoreCase(authScope.getScheme()) || "Negotiate".equalsIgnoreCase(authScope.getScheme())) {
            if (StringUtils.isEmpty((String)this.host)) {
                try {
                    this.host = InetAddress.getLocalHost().getHostName();
                }
                catch (UnknownHostException e) {
                    LOGGER.warn((Object)"error in getting credentials", (Throwable)e);
                }
            }
            NTCredentials ntCredentials = new NTCredentials(this.user, this.pwd, this.host, this.domain);
            return ntCredentials;
        }
        if ("Basic".equalsIgnoreCase(authScope.getScheme()) || "Digest".equalsIgnoreCase(authScope.getScheme())) {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.user, this.pwd);
            return credentials;
        }
        return null;
    }

    public void setCredentials(AuthScope authscope, Credentials credentials) {
    }

    public void clear() {
    }
}

