/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors;

import com.google.common.collect.SetMultimap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.kony.middleware.dbcommons.entity.ServerCertificate;
import com.konylabs.middleware.common.Closer;
import com.konylabs.middleware.common.EncryptDecryptText;
import com.konylabs.middleware.connectors.KonyAliasSelectorKeyManager;
import com.konylabs.middleware.connectors.SSLProperties;
import com.konylabs.middleware.utilities.CertificateUtil;
import com.konylabs.middleware.utilities.ConfigPathUtil;
import com.konylabs.middleware.utilities.ConfigUtility;
import com.konylabs.middleware.utilities.MaskUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public final class DefaultSSLContextFactory {
    private static final String JRE_DEFAULT_KEYSTORE_PWD = "changeit";
    private static final Logger LOGGER = Logger.getLogger(DefaultSSLContextFactory.class);
    private static final String FILE_SEP = File.separator;
    private static final String JRE7_SOCKETFACTORY_PROVIDER = "sun.security.ssl.SSLSocketFactoryImpl";
    private static final String JRE7_SERVERSOCKETFACTORY_PROVIDER = "sun.security.ssl.SSLServerSocketFactoryImpl";
    private static List<ServerCertificate> serverCertificates = new ArrayList<ServerCertificate>(0);

    static void initializeConnectionFactory() {
        String socketFactoryProvider = ConfigUtility.getProperty((String)"ssl.SocketFactory.provider", (String)JRE7_SOCKETFACTORY_PROVIDER);
        LOGGER.debug((Object)("SSL socket factory : " + socketFactoryProvider));
        String serverSocketFactoryProvider = ConfigUtility.getProperty((String)"ssl.ServerSocketFactory.provider", (String)JRE7_SERVERSOCKETFACTORY_PROVIDER);
        LOGGER.debug((Object)("SSL server socket factory : " + serverSocketFactoryProvider));
        try {
            Class.forName(socketFactoryProvider);
            LOGGER.info((Object)"Default ssl provider class loading from middleware.properties.");
        }
        catch (Exception e) {
            try {
                Class.forName(JRE7_SOCKETFACTORY_PROVIDER);
                socketFactoryProvider = JRE7_SOCKETFACTORY_PROVIDER;
                serverSocketFactoryProvider = JRE7_SERVERSOCKETFACTORY_PROVIDER;
                LOGGER.info((Object)"found and setting sun.security.ssl.SSLSocketFactoryImpl");
            }
            catch (Exception exc) {
                LOGGER.info((Object)"No ssl provider found to load http context");
            }
        }
        if (socketFactoryProvider != null && socketFactoryProvider.trim().length() != 0) {
            Security.setProperty("ssl.SocketFactory.provider", socketFactoryProvider);
        }
        if (serverSocketFactoryProvider != null && serverSocketFactoryProvider.trim().length() != 0) {
            Security.setProperty("ssl.ServerSocketFactory.provider", serverSocketFactoryProvider);
        }
    }

    public static SSLContext getSSLContext() {
        KeyManager[] keyManagers = DefaultSSLContextFactory.getKeyManagers();
        TrustManager[] trustManagers = DefaultSSLContextFactory.getTrustManagers();
        SSLContext context = null;
        try {
            if (keyManagers != null && trustManagers != null) {
                String sslAlgorithm = (String)SSLProperties.TLS_ALGO.getFromConfig();
                LOGGER.info((Object)("configured ssl sslAlgorithm: " + sslAlgorithm));
                context = SSLContext.getInstance(sslAlgorithm);
                context.init(keyManagers, trustManagers, null);
            }
        }
        catch (NoSuchAlgorithmException ex) {
            MaskUtils.maskTrace((String)"Unable to load a SSLContext implementation for SSL.", (Throwable)ex);
        }
        catch (KeyManagementException ex) {
            MaskUtils.maskTrace((String)"Error while initializing the SSL Context.", (Throwable)ex);
        }
        return context;
    }

    public static void setServerCertificates(List<ServerCertificate> allCerts) {
        serverCertificates = allCerts;
    }

    public static List<ServerCertificate> getServerCertificates() {
        return serverCertificates;
    }

    public static TrustManager[] getTrustManagers() {
        String trustStorePath = DefaultSSLContextFactory.getTrustStorePath();
        String trustStoreType = DefaultSSLContextFactory.getTrustStoreType();
        String trustStoreProvider = System.getProperty("javax.net.ssl.trustStoreProvider", "");
        String trustStorePwd = DefaultSSLContextFactory.getTrustStorePassword();
        String java_home = System.getProperty("java.home");
        TrustManagerFactory tmf = null;
        try {
            KeyStore cacertStore = DefaultSSLContextFactory.getKeyStore(trustStoreProvider, trustStoreType, trustStorePath, trustStorePwd, java_home);
            if (cacertStore != null) {
                List<ServerCertificate> additionalTrustStoreCerts = serverCertificates.stream().filter(CertificateUtil::isTrustStoreCert).collect(Collectors.toList());
                additionalTrustStoreCerts.forEach(cert -> DefaultSSLContextFactory.addCertToTrustStore(cert, cacertStore));
                tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(cacertStore);
                return tmf != null ? tmf.getTrustManagers() : null;
            }
        }
        catch (KeyStoreException ex) {
            MaskUtils.maskTrace((String)"Error instantiating the TrustManagerFactory with provided keystore.", (Throwable)ex, (Logger)LOGGER);
        }
        catch (NoSuchAlgorithmException ex) {
            MaskUtils.maskTrace((String)"Error instantiating the TrustManagerFactory with default algorithm.", (Throwable)ex, (Logger)LOGGER);
        }
        catch (IllegalStateException ex) {
            MaskUtils.maskTrace((String)"Error while getting trust managers.", (Throwable)ex, (Logger)LOGGER);
        }
        return null;
    }

    private static void addCertToTrustStore(ServerCertificate cert, KeyStore cacertStore) {
        try {
            cacertStore.setCertificateEntry(cert.getAlias(), CertificateUtil.getRootCertificate(cert.getCertificateContent()));
            LOGGER.debug((Object)("Added cert with id " + cert.getId() + " to the Trust store"));
        }
        catch (KeyStoreException e) {
            MaskUtils.maskTrace((String)("Error while adding cert entry with id " + cert.getId() + " to cacerts"), (Throwable)e, (Logger)LOGGER);
        }
        catch (IOException | CertificateException e) {
            MaskUtils.maskTrace((String)("Error while parsing the cert with id " + cert.getId()), (Throwable)e, (Logger)LOGGER);
        }
    }

    public static KeyManager[] getKeyManagers() {
        String keyStorePath = DefaultSSLContextFactory.getKeyStorePath();
        String keyStoreType = DefaultSSLContextFactory.getKeyStoreType();
        String keyStoreProvider = System.getProperty("javax.net.ssl.keyStoreProvider", "");
        String keyStorePwd = DefaultSSLContextFactory.getKeyStorePassword();
        String javaHome = System.getProperty("java.home");
        KeyManager[] keyManagers = null;
        KeyManagerFactory kmf = null;
        try {
            KeyStore ks = DefaultSSLContextFactory.getKeyStore(keyStoreProvider, keyStoreType, keyStorePath, keyStorePwd, javaHome);
            if (ks != null) {
                List<ServerCertificate> additionalKeyStoreCerts = serverCertificates.stream().filter(CertificateUtil::isKeyStoreCert).collect(Collectors.toList());
                char[] defaultKeyPass = DefaultSSLContextFactory.resolveDefaultKeyPass(keyStorePwd, keyStorePath, javaHome);
                additionalKeyStoreCerts.forEach(cert -> DefaultSSLContextFactory.addCertToKeyStore(cert, ks, defaultKeyPass));
                kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                kmf.init(ks, keyStorePwd.toCharArray());
                keyManagers = kmf.getKeyManagers();
                SetMultimap<String, String> aliasDomainMapping = CertificateUtil.getAliasDomainMapping(additionalKeyStoreCerts);
                String twoWaySSLConfig = (String)SSLProperties.TWO_WAY_SSL_CONFIGURATION.getFromConfig();
                if (StringUtils.isNotBlank((String)twoWaySSLConfig)) {
                    DefaultSSLContextFactory.add2WaySSLJsonToAliasDomainMapping(aliasDomainMapping, twoWaySSLConfig);
                }
                if (!aliasDomainMapping.isEmpty()) {
                    LOGGER.debug((Object)("Creating Alias domain mapping as " + aliasDomainMapping));
                    for (int i = 0; i < keyManagers.length; ++i) {
                        if (!(keyManagers[i] instanceof X509KeyManager)) continue;
                        keyManagers[i] = new KonyAliasSelectorKeyManager((X509KeyManager)keyManagers[i], aliasDomainMapping);
                    }
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            MaskUtils.maskTrace((String)"Error instantiating the KeyManagerFactory with default algorithm.", (Throwable)e);
        }
        catch (KeyStoreException | UnrecoverableKeyException e) {
            MaskUtils.maskTrace((String)("Error instantiating the KeyManagerFactory with the given keystore : " + keyStorePath), (Throwable)e);
        }
        catch (IllegalStateException e) {
            MaskUtils.maskTrace((String)"Error while getting key managers.", (Throwable)e);
        }
        catch (Exception e) {
            MaskUtils.maskTrace((String)"Unknown exception while getting key managers.", (Throwable)e);
        }
        return keyManagers;
    }

    public static void add2WaySSLJsonToAliasDomainMapping(SetMultimap<String, String> aliasDomainMapping, String config) {
        if (StringUtils.isNotBlank((String)config)) {
            try {
                JsonObject jsonObject = new JsonParser().parse(config).getAsJsonObject();
                jsonObject.entrySet().forEach(e -> aliasDomainMapping.put((Object)((JsonElement)e.getValue()).getAsString(), e.getKey()));
                LOGGER.debug((Object)"Reading KONY_SERVER_TWO_WAY_SSL_CONFIGURATION json");
            }
            catch (JsonSyntaxException e2) {
                LOGGER.error((Object)"Error while Parsing KONY_SERVER_TWO_WAY_SSL_CONFIGURATION json", (Throwable)e2);
            }
        }
    }

    private static char[] resolveDefaultKeyPass(String keyStorePwd, String keyStorePath, String javaHome) {
        char[] defaultKeyPass = null;
        if (StringUtils.isNotEmpty((String)keyStorePwd)) {
            defaultKeyPass = keyStorePwd.toCharArray();
        } else if (DefaultSSLContextFactory.pickKeyStoreFromJRE(keyStorePath, javaHome)) {
            defaultKeyPass = JRE_DEFAULT_KEYSTORE_PWD.toCharArray();
        }
        return defaultKeyPass;
    }

    private static void addCertToKeyStore(ServerCertificate cert, KeyStore ks, char[] defaultKeyPass) {
        try {
            PrivateKey pKey = CertificateUtil.getPrivateKey(cert);
            if (pKey != null) {
                Certificate[] certificates = CertificateUtil.getCertificates(cert.getCertificateContent());
                ks.setKeyEntry(cert.getAlias(), pKey, CertificateUtil.getKeypassOrDefault(cert.getKeypass(), defaultKeyPass), certificates);
                LOGGER.debug((Object)("Added cert with id " + cert.getId() + " to the KeyStore"));
            } else {
                LOGGER.debug((Object)("Couldn't extract the private key from the provided Pem for cert with id " + cert.getId()));
            }
        }
        catch (KeyStoreException e) {
            MaskUtils.maskTrace((String)("Error while loading cert with id " + cert.getId() + " into key store"), (Throwable)e);
        }
        catch (IOException | CertificateException e) {
            MaskUtils.maskTrace((String)"Error while parsing the certificate", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore getKeyStore(String keyStoreProvider, String keyStoreType, String keyStorePath, String keyStorePwd, String javaHome) {
        char[] pwdChars = keyStorePwd != null ? keyStorePwd.toCharArray() : null;
        KeyStore ks = null;
        FileInputStream kis = null;
        try {
            ks = StringUtils.isBlank((String)keyStoreProvider) ? KeyStore.getInstance(keyStoreType) : KeyStore.getInstance(keyStoreType, keyStoreProvider);
            if (DefaultSSLContextFactory.pickKeyStoreFromJRE(keyStorePath, javaHome)) {
                keyStorePath = javaHome + FILE_SEP + "lib" + FILE_SEP + "security" + FILE_SEP + "cacerts";
                pwdChars = JRE_DEFAULT_KEYSTORE_PWD.toCharArray();
                LOGGER.info((Object)("Taking keystorePath from javaHome : " + javaHome));
            }
            LOGGER.info((Object)("KeyStorePath :" + keyStorePath));
            if (!StringUtils.isEmpty((String)keyStorePath) && new File(keyStorePath).exists()) {
                kis = new FileInputStream(keyStorePath);
                ks.load(kis, pwdChars);
            }
        }
        catch (FileNotFoundException ex) {
            MaskUtils.maskTrace((String)"Unable to locate the keystore.", (Throwable)ex);
        }
        catch (IOException ex) {
            MaskUtils.maskTrace((String)"Error reading the provided keystore.", (Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            MaskUtils.maskTrace((String)"Error loading the keystore.", (Throwable)ex);
        }
        catch (CertificateException ex) {
            MaskUtils.maskTrace((String)"Error loading the provided certificate to the keystore.", (Throwable)ex);
        }
        catch (KeyStoreException e) {
            MaskUtils.maskTrace((String)"Encountered keystore exception while loading the keystore.", (Throwable)e);
        }
        catch (NoSuchProviderException e) {
            MaskUtils.maskTrace((String)"Error instantiating the keystore for the given provider.", (Throwable)e);
        }
        finally {
            Closer.closeQuietly(kis);
        }
        return ks;
    }

    private static boolean pickKeyStoreFromJRE(String keyStorePath, String javaHome) {
        return StringUtils.isEmpty((String)keyStorePath) && !StringUtils.isEmpty((String)javaHome);
    }

    private static String getKeyStorePath() {
        return DefaultSSLContextFactory.getStorePath(SSLProperties.KEY_STORE);
    }

    private static String getTrustStorePath() {
        return DefaultSSLContextFactory.getStorePath(SSLProperties.TRUST_STORE);
    }

    private static String getStorePath(SSLProperties pathProp) {
        String storePath = (String)pathProp.getFromConfig();
        if (!StringUtils.isBlank((String)storePath)) {
            String cloudStorePath = ConfigPathUtil.getMiddlewareHome() + "/middleware/middleware-bootconfig/certs/" + storePath;
            File f = new File(cloudStorePath);
            if (f.exists() && !f.isDirectory()) {
                storePath = cloudStorePath;
                LOGGER.info((Object)(pathProp.getName() + " for cloud: " + storePath));
            }
        } else {
            storePath = System.getProperty("javax.net.ssl.keyStore", "");
            LOGGER.info((Object)(pathProp.getName() + " using javax.net.ssl.keyStore: " + storePath));
        }
        return storePath;
    }

    private static String getKeyStorePassword() {
        return DefaultSSLContextFactory.getStorePassword("ssl.keyStorePassword");
    }

    private static String getTrustStorePassword() {
        return DefaultSSLContextFactory.getStorePassword("ssl.trustStorePassword");
    }

    private static String getStorePassword(String name) {
        String storePassword = ConfigUtility.getProperty((String)name);
        if (StringUtils.isBlank((String)storePassword)) {
            storePassword = System.getProperty("javax.net." + name, "");
        } else if ("true".equalsIgnoreCase(ConfigUtility.getProperty((String)"use.encryption", (String)"false"))) {
            storePassword = EncryptDecryptText.decryptTextLegacy((String)storePassword);
        }
        return storePassword;
    }

    private static String getKeyStoreType() {
        return DefaultSSLContextFactory.getStoreType("ssl.keyStoreType");
    }

    private static String getTrustStoreType() {
        return DefaultSSLContextFactory.getStoreType("ssl.trustStoreType");
    }

    private static String getStoreType(String name) {
        String storeType = ConfigUtility.getProperty((String)name);
        if (StringUtils.isBlank((String)storeType)) {
            storeType = System.getProperty("javax.net." + name, KeyStore.getDefaultType());
        }
        LOGGER.info((Object)(name + " is: " + storeType));
        return storeType;
    }
}

