/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors;

import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.connectors.Connector;
import com.konylabs.middleware.connectors.io.IServiceInputHandler;
import com.konylabs.middleware.connectors.io.ServiceInputHandler;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.exceptions.ProcessorException;
import com.konylabs.middleware.processor.Processor;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.registry.vo.ConfigParam;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.services.ServiceDelegate;
import com.konylabs.middleware.throttle.ThrottleUtil;
import com.konylabs.middleware.utilities.MapperUtility;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InProcConnector
implements Connector {
    private static final Logger logger = Logger.getLogger(InProcConnector.class);
    private ServiceDelegate svcDelegate;

    @Override
    public void setCallingProcessor(Processor processor) {
        if (processor instanceof ServiceDelegate) {
            this.svcDelegate = (ServiceDelegate)processor;
        }
    }

    @Override
    public Result execute(Service service, DataControllerRequest request, DataControllerResponse response) throws ConnectorException {
        Result result = null;
        try {
            ServiceMetadata serviceMetadata = MiddlewareUtils.getServiceMetadata(service);
            ThrottleUtil.checkThrottled(serviceMetadata, request);
            IServiceInputHandler wsinput = this.getInputHandler();
            ConfigParam configParam = service.getServiceConfig().getConfigParam("service");
            String inlineAppId = configParam.getAppid();
            String inlineServiceId = configParam.getValue();
            Map<String, Object> inputMap = wsinput.getInputMap(request, null, service, null);
            Set<String> inputMapKeys = inputMap.keySet();
            for (String key : inputMapKeys) {
                request.addRequestParam_(key, inputMap.get(key).toString());
            }
            String inlineAPIVersion = MiddlewareUtils.getRuntimeVersion(serviceMetadata.getAppMetadata().getAppCache(), inlineAppId);
            AppVersion inlineAppVersion = new AppVersion(inlineAppId, inlineAPIVersion);
            ApplicationMetadata appMetadata = (ApplicationMetadata)serviceMetadata.getAppMetadata().getAppCache().getAppMetadata(inlineAppVersion);
            Service inProcService = appMetadata.getServiceMetadata(inlineServiceId).getService();
            result = this.svcDelegate.execute(inProcService, request, response);
            result = MapperUtility.applyMapperOnResult(request, service, result, null);
        }
        catch (ProcessorException e) {
            logger.error((Object)"Problem Executing:", (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"Problem Executing:", (Throwable)e);
        }
        return result;
    }

    private IServiceInputHandler getInputHandler() {
        return new ServiceInputHandler();
    }
}

