/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors;

import com.kony.adapter.event.DataAdapterEvent;
import com.kony.adapter.event.DataAdapterEventNotifier;
import com.kony.adapter.event.DataAdapterEventObserver;
import com.kony.mobilefabric.timer.FabricTimerCategory;
import com.kony.scrapper.gc.ScrapperMain;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.classloader.ClassLoaderUtils;
import com.konylabs.middleware.common.JavaService;
import com.konylabs.middleware.common.JavaService2;
import com.konylabs.middleware.connectors.Connector;
import com.konylabs.middleware.connectors.ConnectorUtils;
import com.konylabs.middleware.connectors.io.IServiceInputHandler;
import com.konylabs.middleware.connectors.io.IServiceOutputHandler;
import com.konylabs.middleware.connectors.io.JavaInputHandler;
import com.konylabs.middleware.connectors.io.JavaOutputHandler;
import com.konylabs.middleware.connectors.postprocessor.PostProcessUtils;
import com.konylabs.middleware.connectors.preprocessor.PreProcessUtils;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.metrics.MWMetricsTimer;
import com.konylabs.middleware.processor.Processor;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.services.ServiceDelegate;
import com.konylabs.middleware.throttle.ThrottleUtil;
import com.konylabs.middleware.utilities.AnnotationUtils;
import com.konylabs.middleware.utilities.MaskUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

public class JavaConnector
implements Connector,
DataAdapterEventNotifier {
    private static final Logger LOGGER = Logger.getLogger(JavaConnector.class);
    private ServiceDelegate svcDelegate = null;
    private List<DataAdapterEventObserver> observers;

    @Override
    public Result execute(Service service, DataControllerRequest request, DataControllerResponse response) throws ConnectorException {
        LOGGER.debug((Object)"Execute Service Called");
        ServiceMetadata serviceMetadata = MiddlewareUtils.getServiceMetadata(service);
        ThrottleUtil.checkThrottled(serviceMetadata, request);
        Map<String, Object> configMap = MiddlewareUtils.populateConfigMap(service, serviceMetadata);
        MiddlewareUtils.populateAdditionalConfig(serviceMetadata, request, configMap);
        HashMap<String, Object> inputParams = ConnectorUtils.getInputParam(this.getInputHandler(), service, request, configMap);
        boolean isCachable = service.isCachable();
        Object resultFromCache = null;
        if (isCachable && (resultFromCache = ConnectorUtils.getResultFromCache(request, serviceMetadata, inputParams, response)) != null) {
            return (Result)resultFromCache;
        }
        ScrapperMain.setAppCache(serviceMetadata.getAppMetadata().getAppCache());
        AppVersion appVersion = MiddlewareUtils.getAppVersionFromService(service);
        Result result = new Result();
        boolean excuteService = false;
        try {
            excuteService = PreProcessUtils.execute(service, configMap, inputParams, request, response, result, appVersion);
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Exception occurred while invoking preprocessor", (Throwable)ex);
            AnnotationUtils.callPostProcessorOnException(request, response, configMap, result, inputParams, ex);
            throw ex;
        }
        if (excuteService && (result = this.executeService(service, request, response, (HashMap)configMap, inputParams, result)) != null) {
            int cacheduration;
            this.getOutputHandler().processOutput(service, request, response, result);
            try {
                result = PostProcessUtils.execute(service, configMap, result, request, response, appVersion);
            }
            catch (Exception ex) {
                LOGGER.error((Object)"Exception occurred while invoking postprocessor", (Throwable)ex);
                AnnotationUtils.callPostProcessorOnException(request, response, configMap, result, inputParams, ex);
                throw ex;
            }
            int n = cacheduration = service.getCacheduration() == null || service.getCacheduration().length() == 0 ? -1 : Integer.parseInt(service.getCacheduration());
            if (isCachable) {
                ConnectorUtils.insertResultsIntoCache(request, serviceMetadata, inputParams, result, cacheduration);
            }
        }
        return result;
    }

    protected Result executeService(Service service, DataControllerRequest request, DataControllerResponse response, HashMap<String, Object> config, HashMap<String, Object> inputParams, Result result) throws ConnectorException {
        String serviceId = service.getId();
        String methodName = (String)config.get("methodName");
        String className = (String)config.get("className");
        LOGGER.debug((Object)("class name : " + className + " method name : " + methodName));
        String jarModule = MiddlewareUtils.getJarModuleNameFromService(service);
        Object jService = ClassLoaderUtils.getCustomClassInstance(serviceId, jarModule, className);
        try (MWMetricsTimer timer = new MWMetricsTimer(request, FabricTimerCategory.BACKEND_REQUEST, "serviceTimeInMillis");){
            Object resultObj = null;
            Object[] inParams = new Object[3];
            inParams[0] = config;
            inParams[1] = inputParams;
            if (jService instanceof JavaService) {
                resultObj = ((JavaService)jService).invoke(methodName, inParams);
            } else if (jService instanceof JavaService2) {
                resultObj = ((JavaService2)jService).invoke(methodName, inParams, request, response);
            }
            if (resultObj == null) {
                LOGGER.error((Object)("Java service returned null result object for service " + serviceId));
            }
            result = (Result)resultObj;
        }
        catch (ClassCastException ex) {
            LOGGER.error((Object)("Invalid Result object returned on method invocation : " + className + "/" + methodName), (Throwable)ex);
            throw new ConnectorException("Java Connector", "8008", "Invalid Result object returned on invoking Java Service " + serviceId, (Throwable)ex);
        }
        catch (NoClassDefFoundError e) {
            AnnotationUtils.callPostProcessorOnException(request, response, config, result, inputParams, new Exception(e));
            MaskUtils.maskTrace((String)("operation cannot be invoked " + className + " and method " + methodName), (Throwable)new Exception(e));
            throw new ConnectorException("Java Connector", "8004", "NoClassDefFoundError occurred while invoking Java Service " + serviceId);
        }
        catch (Throwable ex) {
            AnnotationUtils.callPostProcessorOnException(request, response, config, result, inputParams, new Exception(ex));
            MaskUtils.maskTrace((String)("operation cannot be invoked " + className + " and method " + methodName), (Throwable)ex);
            throw new ConnectorException("Java Connector", "8004", "Error occurred while invoking Java Service " + serviceId);
        }
        return result;
    }

    @Override
    public void setCallingProcessor(Processor processor) {
        if (processor instanceof ServiceDelegate) {
            this.svcDelegate = (ServiceDelegate)processor;
        }
    }

    protected IServiceInputHandler getInputHandler() {
        return new JavaInputHandler();
    }

    protected IServiceOutputHandler getOutputHandler() {
        return new JavaOutputHandler();
    }

    public ServiceDelegate getSvcDelegate() {
        return this.svcDelegate;
    }

    public void setSvcDelegate(ServiceDelegate svcDelegate) {
        this.svcDelegate = svcDelegate;
    }

    protected Result invokePostProcessor(Service service, DataControllerRequest request, DataControllerResponse response, HashMap<String, Object> config, Result result) throws ConnectorException {
        AppVersion appVersion = MiddlewareUtils.getAppVersionFromService(service);
        return PostProcessUtils.execute(service, config, result, request, response, appVersion);
    }

    protected boolean invokePreProcessor(Service service, DataControllerRequest request, DataControllerResponse response, Map<String, Object> config, HashMap<String, Object> inputMap, Result result) throws ConnectorException {
        AppVersion appVersion = MiddlewareUtils.getAppVersionFromService(service);
        return PreProcessUtils.execute(service, config, inputMap, request, response, result, appVersion);
    }

    public void register(DataAdapterEventObserver observer) {
        if (this.observers == null) {
            this.observers = new CopyOnWriteArrayList<DataAdapterEventObserver>();
        }
        this.observers.add(observer);
    }

    public void notify(DataAdapterEvent event) {
        if (this.observers != null) {
            for (DataAdapterEventObserver observer : this.observers) {
                try {
                    observer.onEvent(event);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Exception thrown by observer in notify", (Throwable)e);
                }
            }
        }
    }

    public void unregister(DataAdapterEventObserver observer) {
        if (this.observers != null) {
            this.observers.remove(observer);
        }
    }
}

