/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors;

import com.kony.mobilefabric.timer.FabricTimerCategory;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.cache.CacheUtils;
import com.konylabs.middleware.classloader.ClassLoaderUtils;
import com.konylabs.middleware.common.JavaService2;
import com.konylabs.middleware.connectors.Connector;
import com.konylabs.middleware.connectors.ConnectorUtils;
import com.konylabs.middleware.connectors.io.IServiceInputHandler;
import com.konylabs.middleware.connectors.io.IServiceOutputHandler;
import com.konylabs.middleware.connectors.io.JavaInputHandler;
import com.konylabs.middleware.connectors.io.JavaOutputHandler;
import com.konylabs.middleware.connectors.postprocessor.PostProcessUtils;
import com.konylabs.middleware.connectors.preprocessor.PreProcessUtils;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.metrics.MWMetricsTimer;
import com.konylabs.middleware.processor.Processor;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.registry.vo.Param;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.session.Session;
import com.konylabs.middleware.throttle.ThrottleUtil;
import com.konylabs.middleware.utilities.AnnotationUtils;
import com.konylabs.middleware.utilities.MaskUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class JavaConnector2
implements Connector {
    private static final Logger LOGGER = Logger.getLogger(JavaConnector2.class);

    @Override
    public Result execute(Service service, DataControllerRequest request, DataControllerResponse response) throws ConnectorException {
        ArrayList params;
        LOGGER.debug((Object)"Execute Service Called");
        ServiceMetadata serviceMetadata = MiddlewareUtils.getServiceMetadata(service);
        ThrottleUtil.checkThrottled(serviceMetadata, request);
        Map<String, Object> config = MiddlewareUtils.populateConfigMap(service, serviceMetadata);
        MiddlewareUtils.populateAdditionalConfig(serviceMetadata, request, config);
        HashMap<String, Object> inputParams = new HashMap<String, Object>();
        Result result = new Result();
        String serviceId = service.getId();
        String methodName = (String)config.get("methodName");
        String className = (String)config.get("className");
        LOGGER.debug((Object)("class name : " + className + " method name : " + methodName));
        String jarModule = MiddlewareUtils.getJarModuleNameFromService(service);
        JavaService2 jService = (JavaService2)ClassLoaderUtils.getCustomClassInstance(serviceId, jarModule, className);
        Session session = request.getSession(false);
        if (session == null) {
            LOGGER.error((Object)("Very rare scenario. Did not find an exisitng session when in scrapping connector " + serviceId));
        }
        if (CacheUtils.isSesionDistributed().booleanValue()) {
            LOGGER.debug((Object)"Session is distributed");
            String cacheId = (String)request.getAttribute("cacheid");
            LOGGER.debug((Object)("Cacheid provided form middleware to scraper as a input param " + cacheId));
            inputParams.put("cacheid", cacheId);
        }
        if ((params = service.getServiceInput().getParams()) != null) {
            int size = params.size();
            LOGGER.debug((Object)("Param Size : " + size));
            for (int i = 0; i < size; ++i) {
                Object paramValue;
                Param param = (Param)params.get(i);
                String source = param.getSource();
                String paramName = param.getName();
                LOGGER.debug((Object)("Param Source : " + source + " Name: " + paramName));
                if (source == null || source.trim().length() == 0 || "request".equals(source)) {
                    paramValue = request.getParameter(paramName);
                    MaskUtils.logDebugWithMasking((String)"Param", (String)paramName, (String)paramValue);
                    inputParams.put(paramName, paramValue);
                    continue;
                }
                if ("session".equals(source)) {
                    if (session == null) {
                        LOGGER.error((Object)("Error Code: MW6000: Session expired or doesnt exist where as source is mentioned as session for the param - " + paramName));
                        throw new ConnectorException(service.getServiceType(), "6000", "Session expired or doesnt exist where as source is mentioned as session for service " + serviceId);
                    }
                    paramValue = session.getAttribute(paramName);
                    MaskUtils.logDebugWithMasking((String)"Param", (String)paramName, (String)String.valueOf(paramValue));
                    inputParams.put(paramName, paramValue);
                    continue;
                }
                LOGGER.error((Object)("Invalid source to the param for  " + paramName + " of service " + serviceId));
                throw new ConnectorException("javaConnector", "7001", "Invalid source to the param for  " + paramName + " of service " + serviceId);
            }
        }
        boolean isCachable = service.isCachable();
        Object resultFromCache = null;
        if (isCachable && (resultFromCache = ConnectorUtils.getResultFromCache(request, serviceMetadata, inputParams, response)) != null) {
            return (Result)resultFromCache;
        }
        AppVersion appVersion = MiddlewareUtils.getAppVersionFromService(service);
        boolean excuteService = PreProcessUtils.execute(service, config, inputParams, request, response, result, appVersion);
        if (excuteService) {
            Object[] inParams = new Object[3];
            inParams[0] = config;
            inParams[1] = inputParams;
            Object resultObj = null;
            try (MWMetricsTimer timer = new MWMetricsTimer(request, FabricTimerCategory.BACKEND_REQUEST, "serviceTimeInMillis");){
                resultObj = jService.invoke(methodName, inParams, request, response);
            }
            catch (Exception ex) {
                AnnotationUtils.callPostProcessorOnException(request, response, config, result, inputParams, ex);
                MaskUtils.maskTrace((String)("operation cannot be invoked " + className + " and method " + methodName), (Throwable)ex);
                throw new ConnectorException("Java Connector", "8004", "Error occurred while invoking Java Service " + serviceId, (Throwable)ex);
            }
            catch (NoClassDefFoundError e) {
                AnnotationUtils.callPostProcessorOnException(request, response, config, result, inputParams, new Exception(e));
                MaskUtils.maskTrace((String)("operation cannot be invoked " + className + " and method " + methodName), (Throwable)new Exception(e));
                throw new ConnectorException("Java Connector", "8004", "NoClassDefFoundError occurred while invoking Java Service " + serviceId);
            }
            if (resultObj == null) {
                LOGGER.error((Object)(serviceId + " returned with null object, please create 'Result' object and return."));
            }
            try {
                result = (Result)resultObj;
            }
            catch (ClassCastException ex) {
                LOGGER.error((Object)("Invalid Result object returned on method invocation : " + className + "/" + methodName), (Throwable)ex);
                throw new ConnectorException("Java Connector", "8008", "Invalid Result object returned on invoking Java Service " + serviceId, (Throwable)ex);
            }
            if (result != null) {
                int cacheduration;
                this.getOutputHandler().processOutput(service, request, response, result);
                result = PostProcessUtils.execute(service, config, result, request, response, appVersion);
                int n = cacheduration = service.getCacheduration() == null || service.getCacheduration().length() == 0 ? -1 : Integer.parseInt(service.getCacheduration());
                if (isCachable) {
                    ConnectorUtils.insertResultsIntoCache(request, serviceMetadata, inputParams, result, cacheduration);
                }
            }
        }
        return result;
    }

    @Override
    public void setCallingProcessor(Processor processor) {
    }

    protected IServiceInputHandler getInputHandler() {
        return new JavaInputHandler();
    }

    protected IServiceOutputHandler getOutputHandler() {
        return new JavaOutputHandler();
    }
}

