/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors;

import com.kony.mapper.javascript.JavaScriptEngineWrapper;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.connectors.JavaConnector;
import com.konylabs.middleware.connectors.io.IServiceInputHandler;
import com.konylabs.middleware.connectors.io.ServiceInputHandler;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.js.JavaScriptExecutorUtil;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import com.konylabs.middleware.utilities.TenantUtilities;
import java.util.HashMap;
import javax.script.ScriptContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class JavaScriptConnector
extends JavaConnector {
    private static final Logger LOGGER = Logger.getLogger(JavaScriptConnector.class);

    @Override
    protected Result executeService(Service service, DataControllerRequest request, DataControllerResponse response, HashMap<String, Object> config, HashMap<String, Object> inputParams, Result result) throws ConnectorException {
        ScriptContext scriptContext;
        AppVersion appVersion;
        String javaScriptText = (String)config.get("javascript");
        if (StringUtils.isBlank((String)javaScriptText)) {
            LOGGER.error((Object)"Found empty javascript config param, it is required");
            throw new ConnectorException("JavaScript Connector", "8058", "javascript config param is required");
        }
        JavaScriptEngineWrapper jsEngineWrapper = TenantUtilities.getJavaScriptEngineFromRequest(request);
        Object resultObj = JavaScriptExecutorUtil.execute(jsEngineWrapper, appVersion = MiddlewareUtils.getAppVersionFromService(service), javaScriptText, scriptContext = JavaScriptExecutorUtil.createScriptContext(request, response, result, inputParams, LOGGER));
        if (resultObj != null && resultObj instanceof Result) {
            return (Result)resultObj;
        }
        return result;
    }

    @Override
    protected IServiceInputHandler getInputHandler() {
        return new ServiceInputHandler();
    }
}

