/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors;

import com.google.common.collect.SetMultimap;
import com.konylabs.middleware.utilities.ConfigUtility;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509KeyManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class KonyAliasSelectorKeyManager
implements X509KeyManager {
    private static final Logger LOGGER = Logger.getLogger(KonyAliasSelectorKeyManager.class);
    private final X509KeyManager sourceKeyManager;
    private final SetMultimap<String, String> aliasDomainMapping;

    public KonyAliasSelectorKeyManager(X509KeyManager sourceKeyManager, SetMultimap<String, String> aliasDomainMapping) {
        LOGGER.debug((Object)"Creating instance of KonyAliasSelectorKeyManager");
        this.sourceKeyManager = sourceKeyManager;
        this.aliasDomainMapping = aliasDomainMapping;
    }

    @Override
    public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
        String serverDNS = socket.getInetAddress().getHostName();
        String alias = this.aliasDomainMapping.entries().stream().filter(e -> StringUtils.equals((CharSequence)((CharSequence)e.getValue()), (CharSequence)serverDNS)).map(e -> (String)e.getKey()).findFirst().orElseGet(() -> this.sourceKeyManager.chooseClientAlias(keyType, issuers, socket));
        LOGGER.debug((Object)("Returning client alias " + alias + " for DNS " + serverDNS));
        return alias;
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        String alias = this.sourceKeyManager.chooseServerAlias(keyType, issuers, socket);
        LOGGER.debug((Object)("Returning server alias " + alias));
        return alias;
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        X509Certificate[] chain = this.sourceKeyManager.getCertificateChain(alias);
        LOGGER.debug((Object)("Returning certificate chain: " + chain));
        return chain;
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        String[] clientAliases = this.sourceKeyManager.getClientAliases(keyType, issuers);
        LOGGER.debug((Object)("Returning client alises: " + clientAliases));
        return clientAliases;
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.sourceKeyManager.getPrivateKey(alias);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        String[] serverAliases = this.sourceKeyManager.getServerAliases(keyType, issuers);
        LOGGER.debug((Object)("Returning client alises: " + serverAliases));
        return serverAliases;
    }

    protected String getTwoWaySslConfigJson() {
        String config = ConfigUtility.getProperty((String)"KONY_SERVER_TWO_WAY_SSL_CONFIGURATION");
        LOGGER.debug((Object)("Two way SSL configuration: " + config));
        return config;
    }
}

