/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors;

import com.kony.mobilefabric.timer.FabricTimer;
import com.kony.mobilefabric.timer.FabricTimerCategory;
import com.konylabs.commons.vo.AppVersion;
import com.konylabs.middleware.common.CSRIssueLogger;
import com.konylabs.middleware.connectors.AbstractCompositeConnector;
import com.konylabs.middleware.connectors.ServiceThreadPooler;
import com.konylabs.middleware.connectors.postprocessor.PostProcessUtils;
import com.konylabs.middleware.connectors.preprocessor.PreProcessUtils;
import com.konylabs.middleware.connectors.utility.LoopingConnectorHandler;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Dataset;
import com.konylabs.middleware.dataobject.Param;
import com.konylabs.middleware.dataobject.Record;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.exceptions.ProcessorException;
import com.konylabs.middleware.metrics.MWMetricsTimer;
import com.konylabs.middleware.metrics.MetricsBean;
import com.konylabs.middleware.monitoring.MonitoringUtils;
import com.konylabs.middleware.registry.impl.ApplicationMetadata;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.registry.vo.ConfigParam;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.session.Session;
import com.konylabs.middleware.throttle.ThrottleUtil;
import com.konylabs.middleware.utilities.MaskUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;

public class LoopingConnector
extends AbstractCompositeConnector {
    private static final String DEPENDANT_TAG = "dependant_tag";
    private static final String DEPENDANT_VALUE = "dependant_value";
    private static final String DEPENDENT_TAG = "dependent_tag";
    private static final String DEPENDENT_VALUE = "dependent_value";
    private static final String EXEC_TYPE = "exec_type";
    private static final String LOOP_COUNT = "loop_count";
    private static final String LOOP_SEPARATOR = "loop_separator";
    private static final String SERVICE = "service";
    private static final String ALLOW_LOOP_COUNT_FROM_CLIENT = "allow_loop_count_from_client";
    private static final String MAX_LOOP_COUNT_FROM_CLIENT = "max_loop_count_from_client";
    private static final String INT_CONST = "int";
    private static final String HTTP_STATUS_CODE = "httpStatusCode";
    private static final String STRING_CONST = "string";
    private static final String ERR_MSG = "errmsg";
    private static final Logger LOGGER = Logger.getLogger(LoopingConnector.class);

    @Override
    public Result execute(Service service, DataControllerRequest request, DataControllerResponse response) throws ConnectorException {
        Object value;
        String str;
        String dependant_value;
        String allowLoopCountConfig;
        String loopCountConfig;
        LOGGER.debug((Object)"------ LoopingConnector Service Called ----- ");
        ServiceMetadata serviceMetadata = MiddlewareUtils.getServiceMetadata(service);
        ThrottleUtil.checkThrottled(serviceMetadata, request);
        String appID = serviceMetadata.getAppId();
        Map<String, Object> configMap = MiddlewareUtils.populateConfigMap(service, serviceMetadata);
        String execType = "Sequential";
        String separator = ",";
        int loopCount = -1;
        boolean allowLoopCount = true;
        boolean overrideLoopCount = false;
        if (configMap.containsKey(EXEC_TYPE)) {
            execType = (String)configMap.get(EXEC_TYPE);
        }
        if (configMap.containsKey(LOOP_SEPARATOR)) {
            separator = (String)configMap.get(LOOP_SEPARATOR);
        }
        if (StringUtils.isNotBlank((String)(loopCountConfig = (String)configMap.get(LOOP_COUNT)))) {
            try {
                loopCount = Integer.parseInt(loopCountConfig);
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)"The loopCount value provided is invalid.", (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((String)(allowLoopCountConfig = (String)configMap.get(ALLOW_LOOP_COUNT_FROM_CLIENT)))) {
            allowLoopCount = BooleanUtils.toBoolean((String)allowLoopCountConfig);
        }
        String maxLoopCount = (String)configMap.get(MAX_LOOP_COUNT_FROM_CLIENT);
        String dependant_tag = (String)configMap.get(DEPENDANT_TAG);
        if (StringUtils.isBlank((String)dependant_tag)) {
            dependant_tag = (String)configMap.get(DEPENDENT_TAG);
        }
        if (StringUtils.isBlank((String)(dependant_value = (String)configMap.get(DEPENDANT_VALUE)))) {
            dependant_value = (String)configMap.get(DEPENDENT_VALUE);
        }
        Service loopingService = null;
        ArrayList cparams = service.getServiceConfig().getServiceConfig();
        if (cparams != null) {
            for (ConfigParam param : cparams) {
                String paramName = param.getName();
                if (!SERVICE.equals(paramName)) continue;
                String inlineServiceId = param.getValue();
                String inlineAppId = StringUtils.isNotBlank((String)param.getAppid()) ? param.getAppid() : appID;
                String inlineAPIVersion = StringUtils.isNotBlank((String)param.getApiVersion()) ? param.getApiVersion() : MiddlewareUtils.getRuntimeVersion(serviceMetadata.getAppMetadata().getAppCache(), inlineAppId);
                MiddlewareUtils.updateCurrentServiceData(request, inlineAppId, inlineAPIVersion, inlineServiceId);
                try {
                    AppVersion inlineAppVersion = new AppVersion(inlineAppId, inlineAPIVersion);
                    ApplicationMetadata appMetadata = (ApplicationMetadata)serviceMetadata.getAppMetadata().getAppCache().getAppMetadata(inlineAppVersion);
                    if (appMetadata == null) {
                        LOGGER.error((Object)("Application does not exist for the inline appId : " + inlineAppId));
                        throw new ConnectorException("LoopingConnector", "1582", "Not able to lookup service " + inlineServiceId);
                    }
                    ServiceMetadata inlineServiceMetadata = appMetadata.getServiceMetadata(inlineServiceId);
                    if (inlineServiceMetadata == null) {
                        LOGGER.error((Object)("Service does not exist for the inline serviceId : " + inlineServiceId));
                        throw new ConnectorException("LoopingConnector", "1582", "Not able to lookup service " + inlineServiceId);
                    }
                    loopingService = inlineServiceMetadata.getService();
                    break;
                }
                catch (Exception ex) {
                    MaskUtils.maskTrace((String)("MW1582: Not able to lookup service with svcID:" + inlineAPIVersion), (Throwable)ex);
                    throw new ConnectorException("LoopingConnector", "1582", "Not able to lookup service", (Throwable)ex);
                }
            }
        }
        if (StringUtils.isNotBlank((String)(str = request.getParameter(LOOP_SEPARATOR)))) {
            separator = str;
            LOGGER.debug((Object)("Obtained the loop_separator from request : " + separator));
        } else {
            LOGGER.debug((Object)"Request parameter loop_separator is missing. Defaulting to value present in service-definition file");
        }
        str = request.getParameter(DEPENDANT_TAG);
        if (StringUtils.isBlank((String)str)) {
            str = request.getParameter(DEPENDENT_TAG);
        }
        if (str != null && str.length() != 0) {
            dependant_tag = str;
            LOGGER.debug((Object)("Obtained the dependant_tag from request : " + dependant_tag));
        }
        if (StringUtils.isBlank((String)(str = request.getParameter(DEPENDANT_VALUE)))) {
            str = request.getParameter(DEPENDENT_VALUE);
        }
        if (StringUtils.isNotBlank((String)dependant_tag) && StringUtils.isNotBlank((String)str)) {
            dependant_value = str;
            LOGGER.debug((Object)("Obtained the dependant_value from request : " + dependant_value));
        }
        str = request.getParameter(LOOP_COUNT);
        try {
            if (allowLoopCount && StringUtils.isNotBlank((String)str)) {
                loopCount = Integer.parseInt(str);
                overrideLoopCount = true;
                LOGGER.debug((Object)("Obtained the loop_count from request : " + loopCount));
            } else {
                LOGGER.info((Object)("loop_count is not allowed from request, will be used from servicedef : " + loopCount));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Request parameter loop_count not found in the request. Defaulting to value in servicedef ", (Throwable)e);
        }
        if (loopCount < 0 && (dependant_tag == null || dependant_tag.length() == 0 || dependant_value == null || dependant_value.length() == 0)) {
            throw new ConnectorException("loopingConnector", "6003", "Mandatory request parameter loop_count or dependant_tag/dependant_value not found in the request");
        }
        Iterator itr = request.getParameterNames();
        HashMap<String, Object> reqParamsMap = new HashMap<String, Object>();
        while (itr.hasNext()) {
            String paramName = (String)itr.next();
            if (LOOP_SEPARATOR.equals(paramName) || LOOP_COUNT.equals(paramName) || DEPENDANT_TAG.equals(paramName) || DEPENDANT_VALUE.equals(paramName) || DEPENDENT_TAG.equals(paramName) || DEPENDENT_VALUE.equals(paramName)) continue;
            String paramValues = request.getParameter(paramName);
            String[] paramBuff = StringUtils.split((String)paramValues, (String)separator);
            reqParamsMap.put(paramName, paramBuff);
        }
        Result result = null;
        AppVersion appVersion = MiddlewareUtils.getAppVersionFromService(service);
        boolean executeService = PreProcessUtils.execute(service, configMap, reqParamsMap, request, response, result, appVersion);
        String string = str = reqParamsMap.get(DEPENDANT_TAG) instanceof String ? (String)reqParamsMap.remove(DEPENDANT_TAG) : null;
        if (StringUtils.isBlank((String)str)) {
            String string2 = str = reqParamsMap.get(DEPENDENT_TAG) instanceof String ? (String)reqParamsMap.remove(DEPENDENT_TAG) : null;
        }
        if (str != null && str.length() != 0) {
            dependant_tag = str;
            LOGGER.debug((Object)("Obtained the dependant_tag from input map: " + dependant_tag));
        }
        String string3 = str = reqParamsMap.get(DEPENDANT_VALUE) instanceof String ? (String)reqParamsMap.remove(DEPENDANT_VALUE) : null;
        if (StringUtils.isBlank((String)str)) {
            String string4 = str = reqParamsMap.get(DEPENDENT_VALUE) instanceof String ? (String)reqParamsMap.remove(DEPENDENT_VALUE) : null;
        }
        if (StringUtils.isNotBlank((String)dependant_tag) && StringUtils.isNotBlank((String)str)) {
            dependant_value = str;
            LOGGER.debug((Object)("Obtained the dependant_value from input map : " + dependant_value));
        }
        str = (value = reqParamsMap.remove(LOOP_COUNT)) != null ? String.valueOf(value) : null;
        try {
            if (allowLoopCount && NumberUtils.isNumber((String)str)) {
                loopCount = Integer.parseInt(str);
                overrideLoopCount = true;
                LOGGER.debug((Object)("Obtained the loop_count from input map : " + loopCount));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Error parsing the loop_count found in the input map.", (Throwable)e);
        }
        LOGGER.debug((Object)(" AppID: " + appID + " Looping Service ID : " + service.getId()));
        LOGGER.debug((Object)("Looping Connector exec_type = " + execType));
        LOGGER.debug((Object)("Looping Connector loop_count = " + loopCount));
        LOGGER.debug((Object)("Looping Connector loop_separator = " + separator));
        LOGGER.debug((Object)("Looping Connector dependent tag = " + dependant_tag));
        LOGGER.debug((Object)("Looping Connector dependent value = " + dependant_value));
        if (allowLoopCount && overrideLoopCount && NumberUtils.isNumber((String)maxLoopCount) && loopCount > Integer.parseInt(maxLoopCount)) {
            throw new ConnectorException("loopingConnector", "6006", "Loop count in request is greater than the maximum allowed loop count");
        }
        List<Result> resultsList = null;
        long startTime = System.currentTimeMillis();
        if (executeService) {
            resultsList = "Concurrent".equals(execType) ? this.concurrentServiceCall(loopCount, reqParamsMap, request, response, loopingService) : this.sequentialServiceCall(loopCount, dependant_tag, dependant_value, reqParamsMap, request, response, loopingService);
        }
        long endTime = System.currentTimeMillis();
        long totalServiceTime = 0L;
        if (request.getOriginalRequest() != null) {
            HttpServletRequest originalRequest = (HttpServletRequest)request.getOriginalRequest();
            Hashtable serviceTimesTable = (Hashtable)originalRequest.getAttribute("serviceTimesTable");
            String serviceTime = serviceTimesTable != null ? (String)serviceTimesTable.get(service.getId() + "_" + "serviceTimeInMillis") : null;
            LOGGER.info((Object)("LoopingConnector|" + service.getId() + "|" + execType + "|Service Times Table==" + serviceTimesTable));
            if (serviceTime != null && StringUtils.isNotBlank((String)serviceTime)) {
                String[] serviceTimes;
                for (String s : serviceTimes = serviceTime.split(",")) {
                    if (StringUtils.isNumeric((String)s)) {
                        long sTime = Long.parseLong(s);
                        if ("Concurrent".equals(execType)) {
                            if (sTime <= totalServiceTime) continue;
                            totalServiceTime = sTime;
                            continue;
                        }
                        totalServiceTime += sTime;
                        continue;
                    }
                    LOGGER.error((Object)("LoopingConnector|" + service.getId() + "|Service Time[" + s + "] is Not a Number"));
                }
            }
        }
        if (totalServiceTime == 0L) {
            totalServiceTime = endTime - startTime;
        }
        LOGGER.debug((Object)("-----------------------END<Total Time:" + (endTime - startTime) + ", Total Service Time:" + totalServiceTime + ">END----------------------"));
        result = this.unifyLoopResults(resultsList);
        if (result != null) {
            result = PostProcessUtils.execute(service, configMap, result, request, response, appVersion);
        }
        return result;
    }

    private Result unifyLoopResults(List<Result> results) {
        Result finalResult = new Result();
        LOGGER.debug((Object)("Total no. of results : " + results.size()));
        Result result = null;
        Dataset dset = new Dataset();
        dset.setId("LoopDataset");
        int successfulServices = 0;
        for (int i = 0; i < results.size(); ++i) {
            result = results.get(i);
            if (result == null) continue;
            Record record = new Record();
            record.setId("LoopRecord");
            record.addAllDatasets((Collection)result.getAllDatasets());
            record.addAllRecords((Collection)result.getAllRecords());
            record.addAllParams((Collection)result.getAllParams());
            for (Param sparam : result.getAllParams()) {
                if (!"opstatus".equals(sparam.getName()) || !"0".equals(sparam.getValue())) continue;
                ++successfulServices;
            }
            dset.addRecord(record);
        }
        if (successfulServices < results.size()) {
            LoopingConnectorHandler.addFailedopstatusForLoopingService(finalResult);
        } else {
            finalResult.addParam(new Param("opstatus", "0", INT_CONST));
        }
        finalResult.addDataset(dset);
        return finalResult;
    }

    private List<Result> concurrentServiceCall(int loopCount, HashMap<String, Object> reqParamsMap, DataControllerRequest request, DataControllerResponse response, Service srvc) throws ConnectorException {
        if (loopCount < 0) {
            throw new ConnectorException("loopingConnector", "6004", "Invalid loop count while execution type is concurrent");
        }
        int i = 0;
        ArrayList<ServiceTask> serviceTasksList = new ArrayList<ServiceTask>();
        ArrayList<Result> resultsList = new ArrayList<Result>();
        Iterator<String> itr = null;
        DataControllerRequest loopRequest = null;
        for (i = 0; i < loopCount; ++i) {
            loopRequest = request.clone();
            itr = reqParamsMap.keySet().iterator();
            if (itr == null) continue;
            String key = "";
            String[] val = null;
            while (itr.hasNext()) {
                key = itr.next();
                if (!(reqParamsMap.get(key) instanceof String[])) continue;
                val = (String[])reqParamsMap.get(key);
                if (val.length > i) {
                    loopRequest.addRequestParam_(key, val[i]);
                    continue;
                }
                if (val.length == 0) {
                    loopRequest.addRequestParam_(key, "");
                    continue;
                }
                int size = val.length;
                loopRequest.addRequestParam_(key, val[size - 1]);
            }
            ServiceTask stask = new ServiceTask();
            stask.setServiceExecInfo(srvc, loopRequest, response.clone(), NDC.cloneStack());
            serviceTasksList.add(stask);
            stask = null;
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug((Object)("Adding the service to the stasks for iteration :" + i));
            LoopingConnectorHandler.logRequestParamsOfService(loopRequest, i, LOGGER);
        }
        if (serviceTasksList.size() > 0) {
            ServiceThreadPooler stp = new ServiceThreadPooler(serviceTasksList.size(), 10);
            try {
                stp.runTasks(serviceTasksList, resultsList);
            }
            catch (Exception e) {
                MaskUtils.maskTrace((String)"Unable to execute the services parallely", (Throwable)e);
                throw new ConnectorException("loopingConnector", "6005", "Unable to execute services parallely.", (Throwable)e);
            }
            finally {
                if (stp != null) {
                    stp.shutDown();
                }
                stp = null;
            }
        }
        return resultsList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Result> sequentialServiceCall(int loopCount, String dependant_tag, String dependant_value, HashMap<String, Object> reqParamsMap, DataControllerRequest request, DataControllerResponse response, Service srvc) throws ConnectorException {
        ArrayList<Result> resultsList = new ArrayList<Result>();
        Iterator<String> itr = null;
        DataControllerRequest loopRequest = null;
        for (int i = 0; i < loopCount; ++i) {
            Result result;
            block29: {
                LOGGER.debug((Object)("-----------------------START<LOOP COUNT: " + i + ">START----------------------"));
                loopRequest = request.clone();
                itr = reqParamsMap.keySet().iterator();
                if (itr != null) {
                    String key = "";
                    String[] val = null;
                    while (itr.hasNext()) {
                        key = itr.next();
                        if (!(reqParamsMap.get(key) instanceof String[])) continue;
                        val = (String[])reqParamsMap.get(key);
                        if (val.length > i) {
                            loopRequest.addRequestParam_(key, val[i]);
                            continue;
                        }
                        if (val.length == 0) {
                            loopRequest.addRequestParam_(key, "");
                            continue;
                        }
                        int size = val.length;
                        loopRequest.addRequestParam_(key, val[size - 1]);
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Executing the service in iteration :" + i));
                    LoopingConnectorHandler.logRequestParamsOfService(loopRequest, i, LOGGER);
                }
                String timerName = this.prepareTimerName(srvc, loopRequest);
                MetricsBean originalMetricsBean = this.getOriginalMetricsBeanAndPrepareClone(loopRequest, srvc.getId(), timerName);
                Map<String, String> additionalTimerInfo = this.prepareTimerInfo(srvc, request, originalMetricsBean.getServiceName());
                result = null;
                FabricTimer childServiceTimer = FabricTimer.startNew((FabricTimerCategory)FabricTimerCategory.SERVICE, (String)timerName, null, additionalTimerInfo);
                try (MWMetricsTimer orchServiceBackendRequestTimer = new MWMetricsTimer(request, FabricTimerCategory.BACKEND_REQUEST, "serviceTimeInMillis");){
                    try {
                        result = this.getServiceDelegate().execute(srvc, loopRequest, response);
                    }
                    catch (Exception ex) {
                        childServiceTimer.markAsError();
                        result = (Result)loopRequest.getAttribute("ResultOnException");
                        if (result == null) {
                            if (ex instanceof ProcessorException) {
                                ProcessorException pe = (ProcessorException)((Object)ex);
                                if (((ProcessorException)((Object)ex)).getHttpStatusCode() == 429) {
                                    result = new Result();
                                    result.addParam(new Param(ERR_MSG, pe.getMessage(), STRING_CONST));
                                    result.addParam(new Param("opstatus", "14049", INT_CONST));
                                    result.addParam(new Param(HTTP_STATUS_CODE, pe.getHttpStatusCode() + "", INT_CONST));
                                    break block29;
                                }
                                throw new ConnectorException("loopingConnector", pe.getErrorCode(), pe.getHttpStatusCode(), pe.getMessage(), (Throwable)ex);
                            }
                            LOGGER.error((Object)"Unable to instantiate the connector class ");
                            throw new ConnectorException("loopingConnector", "6004", "Unable to instantiate the connector class", (Throwable)ex);
                        }
                        loopRequest.setAttribute("ResultOnException", null);
                    }
                }
                finally {
                    MonitoringUtils.closeTimerAndUpdateInternalDurationManually(childServiceTimer, MonitoringUtils.getMetricsBeanFromRequest(loopRequest), timerName);
                    loopRequest.setAttribute("metricsBean", (Object)originalMetricsBean);
                }
            }
            if (result != null) {
                LOGGER.debug((Object)("Adding the result to the arraylist of results for iteration :" + i));
                resultsList.add(result);
            }
            if (result != null && !StringUtils.isBlank((String)dependant_tag)) {
                Param resParam = result.getParamByName(dependant_tag);
                if (dependant_value != null && resParam != null && dependant_value.equals(resParam.getValue())) {
                    LOGGER.debug((Object)("Breaking from the loop as dependant_tag :" + dependant_tag + " and dependant_value " + dependant_value + " have matched."));
                    break;
                }
            }
            result = null;
        }
        return resultsList;
    }

    public class ServiceTask
    implements Callable<Result> {
        private Service srvc = null;
        private DataControllerRequest request = null;
        private DataControllerResponse response = null;
        private Stack<String> ndcStack = null;

        public void setServiceExecInfo(Service service, DataControllerRequest request, DataControllerResponse response, Stack<String> ndcStack) {
            this.srvc = service;
            this.request = request;
            this.response = response;
            this.ndcStack = ndcStack;
        }

        @Override
        public Result call() {
            NDC.inherit(this.ndcStack);
            Result result = null;
            try {
                result = LoopingConnector.this.invokeService("LoopingConnector", this.srvc, this.request, this.response);
            }
            catch (ConnectorException ex) {
                String csrID = CSRIssueLogger.generateCSRID();
                result = LoopingConnectorHandler.prepareResultOnExceptionForOrchestrationService(this.request, ex);
                Session session = this.request.getSession(false);
                CSRIssueLogger.logCSRIssue(csrID, ex.getErrorCode(), session != null ? session.getId() : null, Calendar.getInstance().getTime(), ex.getMessage());
                MaskUtils.maskTrace((String)ex.getMessage(), (Throwable)ex);
            }
            return result;
        }
    }
}

