/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors;

import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;

public final class ProxyUtil {
    private static final Logger LOGGER = Logger.getLogger(ProxyUtil.class);
    private static String PROXY_HOST = System.getProperty("kony.http.proxyHost");
    private static String PROXY_PORT = System.getProperty("kony.http.proxyPort");
    private static String PROXY_USERID = System.getProperty("kony.http.proxyUser");
    private static String PROXY_PWD = System.getProperty("kony.http.proxyPassword");
    private static final String AUTHENTICATION_MODE_NTLM = "NTLM";
    private static final String PROXY_AUTHENTICATION_MODE_PROP = "kony.proxy.authentication.mode";
    private static final String PROXY_NTLM_DOMAIN_PROP = "kony.proxy.ntlm.domainName";
    private static String PROXY_NTLM_DOMAIN_VALUE = System.getProperty("kony.proxy.ntlm.domainName");
    private static String PROXY_AUTHENTICATION_MODE_VALUE = System.getProperty("kony.proxy.authentication.mode");

    public static void initProxy(HttpRequestBase uriRequest, HttpContext context, boolean ignoreProxy) throws IOException {
        String proxyHost = PROXY_HOST;
        if (StringUtils.isNotEmpty((String)proxyHost) && !ignoreProxy) {
            String proxyUser = PROXY_USERID;
            String proxyPassword = PROXY_PWD;
            String proxyDomain = PROXY_NTLM_DOMAIN_VALUE;
            String proxyAutMode = PROXY_AUTHENTICATION_MODE_VALUE;
            boolean isNtlmProxy = AUTHENTICATION_MODE_NTLM.equalsIgnoreCase(proxyAutMode);
            int proxyPort = NumberUtils.toInt((String)PROXY_PORT, (int)80);
            LOGGER.debug((Object)("ProxyHost: " + PROXY_HOST + " ProxyPort: " + proxyPort + "- ntDomain: " + proxyDomain));
            if (StringUtils.isNotEmpty((String)proxyUser) && isNtlmProxy) {
                if (StringUtils.isEmpty((String)proxyDomain)) {
                    throw new IOException("Please set kony.proxy.ntlm.domainName NT Domain Name in JAVA_OPTS");
                }
                LOGGER.debug((Object)("NT Domain Name :" + PROXY_NTLM_DOMAIN_VALUE));
            }
            ProxyUtil.initProxySettings(uriRequest, context, proxyHost, proxyPort, proxyUser, proxyPassword, proxyDomain, isNtlmProxy);
        }
    }

    private static void initProxySettings(HttpRequestBase httpMethod, HttpContext httpContext, String proxyHost, int proxyPort, String proxyUsername, String proxyPassword, String proxyNtlmDomain, boolean isNtlmProxy) throws MalformedURLException {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        if (StringUtils.isNotEmpty((String)proxyHost)) {
            HttpHost proxy = new HttpHost(proxyHost, proxyPort);
            if (StringUtils.isNotEmpty((String)proxyUsername) && StringUtils.isNotEmpty((String)proxyPassword)) {
                UsernamePasswordCredentials proxyCreds = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
                if (isNtlmProxy) {
                    proxyCreds = new NTCredentials(proxyUsername, proxyPassword, proxyHost, proxyNtlmDomain);
                }
                credsProvider.setCredentials(new AuthScope(proxy.getHostName(), proxy.getPort()), (Credentials)proxyCreds);
                httpContext.setAttribute("http.auth.credentials-provider", (Object)credsProvider);
            }
            RequestConfig.Builder requestConfigBuilder = httpMethod.getConfig() != null ? RequestConfig.copy((RequestConfig)httpMethod.getConfig()) : RequestConfig.custom();
            RequestConfig config = requestConfigBuilder.setProxy(proxy).build();
            httpMethod.setConfig(config);
        }
    }

    private ProxyUtil() {
    }
}

