/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors;

import com.konylabs.middleware.config.ConfigProperty;
import java.io.File;
import org.apache.log4j.Logger;

public final class SSLProperties
extends ConfigProperty {
    private static final Logger LOGGER = Logger.getLogger(SSLProperties.class);
    public static final String CACERTS_PATH = "/lib/security/cacerts";
    public static final String JAVA_HOME = "java.home";
    public static final SSLProperties TRUST_STORE = new SSLProperties("ssl.trustStore", String.class, null);
    public static final SSLProperties KEY_STORE = new SSLProperties("ssl.keyStore", String.class, null);
    public static final SSLProperties TLS_ALGO = new SSLProperties("ssl.algorithm", String.class, "TLSv1.2");
    public static final SSLProperties HOSTNAME_VERIFIER = new SSLProperties("ssl.SocketFactory.hostname.verifier", String.class, null);
    public static final SSLProperties TWO_WAY_SSL_CONFIGURATION = new SSLProperties("KONY_SERVER_TWO_WAY_SSL_CONFIGURATION", String.class, null);

    public boolean validateSslPathKey() {
        return this.validateSslPathKey((String)this.getFromConfig());
    }

    protected boolean validateSslPathKey(String pathKey) {
        boolean isValid = false;
        if (!this.validate(pathKey)) {
            return isValid;
        }
        String javaHome = System.getProperty(JAVA_HOME);
        String cacertsPath = javaHome + CACERTS_PATH;
        if (cacertsPath.equals(pathKey)) {
            LOGGER.debug((Object)("Successfully validated " + this.getName() + " path with java cacerts path " + cacertsPath));
            File keyFile = new File(pathKey);
            if (keyFile.exists()) {
                LOGGER.info((Object)("Successfully matched " + this.getName() + " with JVM cacerts path " + pathKey));
                isValid = true;
            } else {
                LOGGER.warn((Object)("JVM cacerts file doesn't exists in " + pathKey));
            }
        } else {
            LOGGER.warn((Object)("Path " + pathKey + " is not same as JVM cacerts path " + cacertsPath));
        }
        return isValid;
    }

    private <T> SSLProperties(String name, Class<T> type, T defaultValue) {
        super(name, type, defaultValue);
    }
}

