/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors;

import com.kony.mobilefabric.timer.FabricTimerCategory;
import com.kony.scrapper.gc.ScraperException;
import com.kony.scrapper.gc.ScrapperMain;
import com.konylabs.middleware.connectors.JavaConnector;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.metrics.MWMetricsTimer;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.registry.vo.Service;
import com.konylabs.middleware.utilities.AnnotationUtils;
import com.konylabs.middleware.utilities.MaskUtils;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ScraperConnector
extends JavaConnector {
    private static final Logger LOGGER = Logger.getLogger(ScraperConnector.class);

    @Override
    protected Result executeService(Service service, DataControllerRequest request, DataControllerResponse response, HashMap<String, Object> config, HashMap<String, Object> inputParams, Result result) throws ConnectorException {
        LOGGER.debug((Object)"Execute Service Called in Scrapper Connector");
        try (MWMetricsTimer timer = new MWMetricsTimer(request, FabricTimerCategory.BACKEND_REQUEST, "serviceTimeInMillis");){
            HashMap outParams = new HashMap();
            ServiceMetadata serviceMetadata = MiddlewareUtils.getServiceMetadata(service);
            ScrapperMain.setAppCache(serviceMetadata.getAppMetadata().getAppCache());
            result = ScrapperMain.getGenericScrapperData(config, inputParams, outParams);
        }
        catch (ScraperException e) {
            MaskUtils.maskTrace((String)(e.getErrorCode() + ": Unable to execute Scraper service : " + service.getId() + ", Error Message : " + e.getErrorMessage()), (Throwable)e);
            throw new ConnectorException("Scraper Connector", e.getErrorCode(), e.getErrorMessage());
        }
        catch (Exception ex) {
            AnnotationUtils.callPostProcessorOnException(request, response, config, result, inputParams, ex);
            MaskUtils.maskTrace((String)("MW8010: Unable to execute Scraper service : " + service.getId()), (Throwable)ex);
            throw new ConnectorException("Scraper Connector", "8010", "Error occurred while invoking Scraper Service ", (Throwable)ex);
        }
        return result;
    }
}

