/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors;

import com.konylabs.middleware.dataobject.Result;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ServiceThreadPooler {
    private static final Logger LOGGER = Logger.getLogger(ServiceThreadPooler.class);
    private ThreadPoolExecutor threadPool = null;
    private final LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue();

    public ServiceThreadPooler(int poolNum, int keepAlive) {
        this.threadPool = new ThreadPoolExecutor(poolNum, poolNum, keepAlive, TimeUnit.MILLISECONDS, this.queue);
    }

    public void runTasks(List taskList, List<Result> results) throws InterruptedException, ExecutionException {
        List futureList = this.threadPool.invokeAll(taskList);
        if (futureList != null && !futureList.isEmpty()) {
            for (Future futBool : futureList) {
                LOGGER.debug((Object)("Task Completed: " + futBool.isDone()));
                Result res = (Result)futBool.get();
                results.add(res);
            }
        }
        LOGGER.debug((Object)("Queue List BackLog Count: " + this.queue.size()));
    }

    public void shutDown() {
        try {
            if (this.threadPool != null) {
                LOGGER.debug((Object)"Closing Object Pool ...");
                this.threadPool.shutdown();
                LOGGER.debug((Object)"Closed Object Pool successfully ...");
            }
        }
        finally {
            if (this.threadPool != null && !this.threadPool.isShutdown()) {
                LOGGER.debug((Object)" In finally Closing Object Pool ...");
                this.threadPool.shutdownNow();
                LOGGER.debug((Object)"In finally Closed Object Pool successfully ...");
            }
            this.threadPool = null;
            if (this.queue != null) {
                this.queue.clear();
            }
        }
    }
}

