/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors;

import com.kony.adapter.exception.DataAdapterException;
import com.kony.adapter.handler.AsyncHandler;
import com.kony.adapter.model.Context;
import com.konylabs.middleware.connectors.AsyncConnector;
import com.konylabs.middleware.connectors.Connector;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.controller.DataControllerResponse;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.exceptions.ConnectorInitializationException;
import com.konylabs.middleware.registry.impl.ServiceMetadata;
import com.konylabs.middleware.services.AbstractServiceDelegate;
import java.util.Map;

public class WrapperAsyncConnector
implements AsyncConnector {
    private Connector connector;
    private AbstractServiceDelegate serviceDelegate;

    public WrapperAsyncConnector(Connector connector) {
        this.connector = connector;
    }

    @Override
    public void executeAsync(ServiceMetadata serviceMetadata, DataControllerRequest request, DataControllerResponse response, Context parentContext, Map<String, Object> config) {
        AsyncHandler asyncHandler = (AsyncHandler)parentContext.get("handler");
        try {
            this.connector.setCallingProcessor(this.serviceDelegate);
            Result result = this.connector.execute(serviceMetadata.getService(), request, response);
            asyncHandler.onSuccess((Object)result, parentContext);
        }
        catch (ConnectorException exception) {
            asyncHandler.onError(new DataAdapterException(exception.getErrorCode(), exception.getMessage(), (Throwable)exception, exception.getHttpStatusCode()), parentContext);
        }
        catch (ConnectorInitializationException exception) {
            asyncHandler.onError(new DataAdapterException(exception.getErrorCode(), exception.getMessage(), (Throwable)exception, exception.getHttpStatusCode()), parentContext);
        }
    }

    @Override
    public void setServiceDelegate(AbstractServiceDelegate serviceDelegate) {
        this.serviceDelegate = serviceDelegate;
    }
}

