/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors;

import com.konylabs.middleware.connectors.AbstractNamespaceContext;
import com.konylabs.middleware.connectors.NamespaceCacheContext;
import com.konylabs.middleware.connectors.NamespaceMapContextImpl;
import com.konylabs.middleware.connectors.OrderedRecordCreator;
import com.konylabs.middleware.connectors.XPathEngine;
import com.konylabs.middleware.connectors.XPathUtil;
import com.konylabs.middleware.controller.DataControllerRequest;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.ConnectorException;
import com.konylabs.middleware.registry.vo.Dataset;
import com.konylabs.middleware.registry.vo.Param;
import com.konylabs.middleware.registry.vo.Record;
import com.konylabs.middleware.session.Session;
import com.konylabs.middleware.utilities.MiddlewareUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XPathEngineImpl
implements XPathEngine {
    private static final Logger LOGGER = Logger.getLogger(XPathEngineImpl.class);
    private static final String XPATH_SEPARATOR_REGEX = "/+";
    private static final String COMMA = ",";
    private static final Pattern XPATH_PATTERN = XPathEngineImpl.getXPathFunctionPattern();
    private static final Pattern XPATH_PARENT_REFERENCE_PATTERN = XPathEngineImpl.getXPathParentReferencePattern();
    private final Node documentElement;
    private final AbstractNamespaceContext namespaceContext;

    public XPathEngineImpl(Document document) {
        this.documentElement = document.getDocumentElement();
        this.namespaceContext = new NamespaceCacheContext(document);
    }

    public XPathEngineImpl(String payload, String encoding) throws ConnectorException {
        try {
            payload = this.skipBOM(payload);
            Document document = XPathUtil.createDocument(payload, encoding);
            this.documentElement = document.getDocumentElement();
            this.namespaceContext = new NamespaceMapContextImpl(payload);
        }
        catch (Exception ex) {
            MiddlewareUtils.maskTrace("8007", "Error parsing the XML response.", ex);
            throw new ConnectorException("XMLEntity", "8007", "Error parsing the XML response.", (Throwable)ex);
        }
    }

    @Override
    public void fillParams(Result result, List<Param> metaParams, DataControllerRequest request) throws ConnectorException {
        try {
            for (Param metaParam : metaParams) {
                com.konylabs.middleware.dataobject.Param param = this.prepareParam(this.documentElement, metaParam);
                if (param == null) continue;
                if ("session".equalsIgnoreCase(metaParam.getTarget())) {
                    Session session = request.getSession();
                    if (session == null) {
                        LOGGER.error((Object)("Error MW6000: Session doesn't exist where as source is mentioned as session for the param " + metaParam.getName()));
                        throw new ConnectorException("plainxmlserviceConnector", "6000", "Session deosnt exist where as  source is mentioned as session.");
                    }
                    session.setAttribute(metaParam.getName(), (Object)param.getValue());
                }
                result.addParam(param);
            }
        }
        catch (XPathExpressionException e) {
            throw new ConnectorException("plainxmlserviceConnector", "8013", "No value for expression.", (Throwable)e);
        }
        catch (TransformerException e) {
            throw new ConnectorException("plainxmlserviceConnector", "8013", "No value for expression.", (Throwable)e);
        }
    }

    @Override
    public String evalErrorDetailXPath(String source) {
        return this.evalXPath(source);
    }

    @Override
    public String evalXPath(String xpath) {
        String value = null;
        try {
            Node node = XPathUtil.evaluateAsNode(this.documentElement, xpath, this.namespaceContext);
            value = node != null ? XPathUtil.getNodeContent(node, this.namespaceContext) : null;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Expection while evaluating XPath", (Throwable)e);
        }
        return value;
    }

    @Override
    public List<com.konylabs.middleware.dataobject.Record> fillRecords(List<Record> metaRecords) throws Exception {
        ArrayList<com.konylabs.middleware.dataobject.Record> records = new ArrayList<com.konylabs.middleware.dataobject.Record>();
        for (Record metaRecord : metaRecords) {
            com.konylabs.middleware.dataobject.Record record = this.prepareRecord(this.documentElement, metaRecord);
            if (record == null) continue;
            records.add(record);
        }
        return records;
    }

    @Override
    public List<com.konylabs.middleware.dataobject.Dataset> fillDatasets(List<Dataset> metaDatasets) throws Exception {
        ArrayList<com.konylabs.middleware.dataobject.Dataset> datasets = new ArrayList<com.konylabs.middleware.dataobject.Dataset>();
        for (Dataset metaDataset : metaDatasets) {
            com.konylabs.middleware.dataobject.Dataset dataset = this.prepareDataset(this.documentElement, metaDataset);
            if (dataset == null) continue;
            datasets.add(dataset);
        }
        return datasets;
    }

    public String skipBOM(String payload) {
        return payload.replaceFirst("\ufeff", "");
    }

    public static Pattern getXPathFunctionPattern() {
        String or = "|";
        CharSequence[] nodeSetFuncs = new String[]{"last", "position", "count", "id", "local-name", "namespace-uri", "name"};
        CharSequence[] stringFuncs = new String[]{"string", "concat", "contains", "starts-with", "substring-before", "substring-after", "substring", "string-length", "normalize-space", "translate"};
        CharSequence[] boolFuncs = new String[]{"boolean", "not", "true", "false", "lang"};
        CharSequence[] numberFuncs = new String[]{"number", "sum", "floor", "ceiling", "round"};
        Pattern xPathFunctionPattern = Pattern.compile("((^(" + String.join((CharSequence)"|", nodeSetFuncs) + "|" + String.join((CharSequence)"|", stringFuncs) + "|" + String.join((CharSequence)"|", boolFuncs) + "|" + String.join((CharSequence)"|", numberFuncs) + "))\\((.*)\\)$)");
        Pattern xPathArithmeticOperatorsPattern = Pattern.compile("(.+)\\s(\\+|-|div|\\*|<|<=|>|>=|=|!=|\\||or|and|mod)\\s(.+)");
        return Pattern.compile("(" + xPathFunctionPattern.pattern() + "|" + xPathArithmeticOperatorsPattern.pattern() + ")");
    }

    public com.konylabs.middleware.dataobject.Param createParam(Param metaParam, String textContent) {
        return new com.konylabs.middleware.dataobject.Param(metaParam.getName(), StringEscapeUtils.unescapeXml((String)textContent), metaParam.getDataType(), metaParam.getFormat(), metaParam.getFormatvalue());
    }

    private com.konylabs.middleware.dataobject.Param prepareParam(Node parent, Param metaParam) throws XPathExpressionException, TransformerException {
        String sourceXPath = metaParam.getSource();
        if (StringUtils.isBlank((String)sourceXPath)) {
            return null;
        }
        XPathExpression compiledPath = XPathUtil.prepareXPath(sourceXPath, this.namespaceContext);
        if (compiledPath == null) {
            return null;
        }
        Matcher matcher = XPATH_PATTERN.matcher(sourceXPath);
        boolean isFunction = matcher.matches();
        if (isFunction) {
            String textContent = XPathUtil.evaluateAsString(parent, sourceXPath, this.namespaceContext);
            com.konylabs.middleware.dataobject.Param param = this.createParam(metaParam, textContent);
            return param;
        }
        NodeList nodeList = (NodeList)compiledPath.evaluate(parent, XPathConstants.NODESET);
        if (nodeList.getLength() == 0) {
            com.konylabs.middleware.dataobject.Param param = this.createParam(metaParam, "");
            return param;
        }
        if (nodeList.getLength() > 1 && "collection".equals(metaParam.getDataType())) {
            com.konylabs.middleware.dataobject.Param param = this.createParam(metaParam, null);
            JSONArray array = new JSONArray();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                array.put((Object)XPathUtil.getNodeContent(nodeList.item(i), null));
            }
            param.setObjectValue((Object)array);
            return param;
        }
        com.konylabs.middleware.dataobject.Param param = this.createParam(metaParam, XPathUtil.getNodeContent(nodeList.item(nodeList.getLength() - 1), null));
        return param;
    }

    private com.konylabs.middleware.dataobject.Record prepareRecord(Node parent, Record metaRecord) throws Exception {
        String recordXPathStr = metaRecord.getSource();
        com.konylabs.middleware.dataobject.Record record = null;
        Node recordNode = XPathUtil.evaluateAsNode(parent, recordXPathStr, this.namespaceContext);
        if (recordNode != null) {
            record = this.populateChilds(metaRecord, recordNode);
        }
        return record;
    }

    private com.konylabs.middleware.dataobject.Dataset prepareDataset(Node parent, Dataset metaDataset) throws Exception {
        com.konylabs.middleware.dataobject.Dataset dataset = null;
        String datasetXPathStr = metaDataset.getSource();
        Node datasetNode = XPathUtil.evaluateAsNode(parent, datasetXPathStr, this.namespaceContext);
        if (datasetNode != null) {
            dataset = this.populateChilds(metaDataset, datasetNode);
        }
        return dataset;
    }

    private com.konylabs.middleware.dataobject.Dataset populateChilds(Dataset metaDataset, Node datasetNode) throws XPathExpressionException {
        OrderedRecordCreator recordList = new OrderedRecordCreator();
        this.processParamsInDataSets(metaDataset, datasetNode, recordList);
        this.processNestedDataSetsInDataSets(metaDataset, datasetNode, recordList);
        this.processNestedRecordsInDataSets(metaDataset, datasetNode, recordList);
        com.konylabs.middleware.dataobject.Dataset dataset = new com.konylabs.middleware.dataobject.Dataset(metaDataset.getId());
        dataset.addAllRecords(recordList.getRecords());
        return dataset;
    }

    private com.konylabs.middleware.dataobject.Record populateChilds(Record recordMeta, Node recordNode) throws XPathExpressionException {
        com.konylabs.middleware.dataobject.Record record = new com.konylabs.middleware.dataobject.Record();
        record.setId(recordMeta.getId());
        this.processParamsInRecords(recordMeta, recordNode, record);
        this.processNestedDataSetsInRecords(recordMeta, recordNode, record);
        this.processNestedRecordsInRecords(recordMeta, recordNode, record);
        return record;
    }

    private void processParamsInDataSets(Dataset metaDataset, Node datasetNode, OrderedRecordCreator recordList) throws XPathExpressionException {
        for (Param metaParam : metaDataset.getParams()) {
            String sourceXPath = metaParam.getSource();
            String functionArgumentXPath = this.getExpressionFromFunction(sourceXPath);
            String xpath = functionArgumentXPath == null ? sourceXPath : functionArgumentXPath;
            if (!StringUtils.isNotBlank((String)xpath)) continue;
            int childDepth = xpath.split(XPATH_SEPARATOR_REGEX).length;
            NodeList paramNodeList = XPathUtil.evaluateAsNodeList(datasetNode, xpath, this.namespaceContext);
            if (paramNodeList == null) continue;
            for (int i = 0; i < paramNodeList.getLength(); ++i) {
                Node paramNode = paramNodeList.item(i);
                Node paramParent = this.getParentNode(paramNode, childDepth);
                com.konylabs.middleware.dataobject.Record record = recordList.createRecord(paramParent);
                String textContent = paramNode.getTextContent();
                if (functionArgumentXPath != null) {
                    String nXpath = this.prepareFunctionXPath(sourceXPath, functionArgumentXPath, textContent);
                    textContent = XPathUtil.evaluateAsString(datasetNode, nXpath, this.namespaceContext);
                }
                com.konylabs.middleware.dataobject.Param param = this.createParam(metaParam, textContent);
                record.addParam(param);
            }
        }
    }

    private void processNestedRecordsInDataSets(Dataset metaDataset, Node datasetNode, OrderedRecordCreator recordList) throws XPathExpressionException {
        for (Record nestedRecordMeta : metaDataset.getRecords()) {
            String nestedRecordXPathStr = nestedRecordMeta.getSource();
            if (!StringUtils.isNotBlank((String)nestedRecordXPathStr)) continue;
            int childDepth = nestedRecordXPathStr.split(XPATH_SEPARATOR_REGEX).length;
            NodeList nestedRecordNodeList = XPathUtil.evaluateAsNodeList(datasetNode, nestedRecordXPathStr, this.namespaceContext);
            if (nestedRecordNodeList == null) continue;
            for (int i = 0; i < nestedRecordNodeList.getLength(); ++i) {
                Node nestedRecordNode = nestedRecordNodeList.item(i);
                com.konylabs.middleware.dataobject.Record nestedRecord = this.populateChilds(nestedRecordMeta, nestedRecordNode);
                Node paramParent = this.getParentNode(nestedRecordNode, childDepth);
                com.konylabs.middleware.dataobject.Record record = recordList.createRecord(paramParent);
                record.addRecord(nestedRecord);
            }
        }
    }

    private void processNestedDataSetsInDataSets(Dataset metaDataset, Node datasetNode, OrderedRecordCreator recordList) throws XPathExpressionException {
        for (Dataset nestedDatasetMeta : metaDataset.getDatasets()) {
            String nestedDatasetXPathStr = nestedDatasetMeta.getSource();
            if (!StringUtils.isNotBlank((String)nestedDatasetXPathStr)) continue;
            int childDepth = nestedDatasetXPathStr.split(XPATH_SEPARATOR_REGEX).length;
            NodeList nestedDatasetNodeList = XPathUtil.evaluateAsNodeList(datasetNode, nestedDatasetXPathStr, this.namespaceContext);
            if (nestedDatasetNodeList == null) continue;
            if (XPathEngineImpl.hasParentReference(nestedDatasetXPathStr)) {
                this.processNestedDS(recordList, nestedDatasetMeta, nestedDatasetNodeList, childDepth);
                continue;
            }
            this.removeParentNodeAndProcessNestedDS(recordList, nestedDatasetMeta, nestedDatasetNodeList, childDepth);
        }
    }

    private void processParamsInRecords(Record recordMeta, Node recordNode, com.konylabs.middleware.dataobject.Record record) throws XPathExpressionException {
        for (Param metaParam : recordMeta.getParams()) {
            NodeList paramNodeList;
            String sourceXPath = metaParam.getSource();
            String functionArgumentXPath = this.getExpressionFromFunction(sourceXPath);
            String xpath = functionArgumentXPath == null ? sourceXPath : functionArgumentXPath;
            if (!StringUtils.isNotBlank((String)xpath) || (paramNodeList = XPathUtil.evaluateAsNodeList(recordNode, xpath, this.namespaceContext)) == null) continue;
            for (int i = 0; i < paramNodeList.getLength(); ++i) {
                Node paramNode = paramNodeList.item(i);
                String textContent = paramNode.getTextContent();
                if (functionArgumentXPath != null) {
                    String nXpath = this.prepareFunctionXPath(sourceXPath, functionArgumentXPath, textContent);
                    textContent = XPathUtil.evaluateAsString(recordNode, nXpath, this.namespaceContext);
                }
                com.konylabs.middleware.dataobject.Param param = this.createParam(metaParam, textContent);
                record.addParam(param);
            }
        }
    }

    private void processNestedDataSetsInRecords(Record recordMeta, Node recordNode, com.konylabs.middleware.dataobject.Record record) throws XPathExpressionException {
        for (Dataset nestedDatasetMeta : recordMeta.getDatasets()) {
            String nestedDatasetXPathStr = nestedDatasetMeta.getSource();
            NodeList nestedDatasetNodeList = XPathUtil.evaluateAsNodeList(recordNode, nestedDatasetXPathStr, this.namespaceContext);
            if (nestedDatasetNodeList == null) continue;
            for (int i = 0; i < nestedDatasetNodeList.getLength(); ++i) {
                Node nestedDatasetNode = nestedDatasetNodeList.item(i);
                com.konylabs.middleware.dataobject.Dataset nestedDataset = this.populateChilds(nestedDatasetMeta, nestedDatasetNode);
                record.addDataset(nestedDataset);
            }
        }
    }

    private void processNestedRecordsInRecords(Record recordMeta, Node recordNode, com.konylabs.middleware.dataobject.Record record) throws XPathExpressionException {
        for (Record nestedRecordMeta : recordMeta.getRecords()) {
            String nestedRecordXPathStr = nestedRecordMeta.getSource();
            NodeList nestedRecordNodeList = XPathUtil.evaluateAsNodeList(recordNode, nestedRecordXPathStr, this.namespaceContext);
            if (nestedRecordNodeList == null) continue;
            for (int i = 0; i < nestedRecordNodeList.getLength(); ++i) {
                Node nestedRecordNode = nestedRecordNodeList.item(i);
                com.konylabs.middleware.dataobject.Record nestedRecord = this.populateChilds(nestedRecordMeta, nestedRecordNode);
                record.addRecord(nestedRecord);
            }
        }
    }

    private void removeParentNodeAndProcessNestedDS(OrderedRecordCreator recordList, Dataset nestedDatasetMeta, NodeList nestedDatasetNodeList, int childDepth) throws XPathExpressionException {
        for (int i = 0; i < nestedDatasetNodeList.getLength(); ++i) {
            Node nestedDatasetNode = nestedDatasetNodeList.item(i);
            Node parentAtHeight = this.getParentNode(nestedDatasetNode, childDepth);
            Node parent = nestedDatasetNode.getParentNode();
            Node nextSibling = nestedDatasetNode.getNextSibling();
            parent.removeChild(nestedDatasetNode);
            com.konylabs.middleware.dataobject.Dataset nestedDataset = this.populateChilds(nestedDatasetMeta, nestedDatasetNode);
            parent.insertBefore(nestedDatasetNode, nextSibling);
            com.konylabs.middleware.dataobject.Record record = recordList.createRecord(parentAtHeight);
            record.addDataset(nestedDataset);
        }
    }

    private void processNestedDS(OrderedRecordCreator recordList, Dataset nestedDatasetMeta, NodeList nestedDatasetNodeList, int childDepth) throws XPathExpressionException {
        for (int i = 0; i < nestedDatasetNodeList.getLength(); ++i) {
            Node nestedDatasetNode = nestedDatasetNodeList.item(i);
            Node parentAtHeight = this.getParentNode(nestedDatasetNode, childDepth);
            com.konylabs.middleware.dataobject.Dataset nestedDataset = this.populateChilds(nestedDatasetMeta, nestedDatasetNode);
            com.konylabs.middleware.dataobject.Record record = recordList.createRecord(parentAtHeight);
            record.addDataset(nestedDataset);
        }
    }

    private String prepareFunctionXPath(String sourceXPath, String functionArgumentXPath, String textContent) {
        int indx = sourceXPath.indexOf(functionArgumentXPath);
        String nXpath = new StringBuffer(sourceXPath).replace(indx, indx + functionArgumentXPath.length(), "'" + textContent + "'").toString();
        return nXpath;
    }

    private Node getParentNode(Node node, int depth) {
        for (int i = 0; i < depth - 1; ++i) {
            Node parentNode;
            Node node2 = parentNode = node.getNodeType() == 2 ? ((Attr)node).getOwnerElement() : node.getParentNode();
            if (parentNode == null) {
                return node;
            }
            node = parentNode;
        }
        return node;
    }

    private String getExpressionFromFunction(String src) {
        String functionParameters;
        String functionParameterXPath = null;
        Matcher matcher = XPATH_PATTERN.matcher(src);
        if (matcher.matches() && (functionParameters = matcher.group(5)) != null && functionParameters.trim().length() > 0) {
            String[] functionParameterArray = functionParameters.split(COMMA);
            for (int idx = 0; idx < functionParameterArray.length; ++idx) {
                String functionParameter = functionParameterArray[idx].trim();
                if (functionParameter.startsWith("'")) continue;
                functionParameterXPath = functionParameter;
                break;
            }
        }
        return functionParameterXPath;
    }

    static boolean hasParentReference(String nestedDatasetXPathStr) {
        return XPATH_PARENT_REFERENCE_PATTERN.matcher(nestedDatasetXPathStr).matches();
    }

    static Pattern getXPathParentReferencePattern() {
        String parentRefPattern = ".*(\\.\\.|::|//).*";
        return Pattern.compile(".*(\\.\\.|::|//).*");
    }
}

