/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors;

import com.konylabs.middleware.connectors.AbstractNamespaceContext;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XPathUtil {
    private static final Logger LOGGER = Logger.getLogger(XPathUtil.class);
    private static final XPathFactory xpathFactory = XPathFactory.newInstance();
    private static final DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private static final Pattern XMLNS_PATTERN = Pattern.compile("\\s+xmlns=\"[^\"]*\"");

    private XPathUtil() {
    }

    private static void disableExternalEntityInjection(DocumentBuilderFactory builderFactory) {
        try {
            builderFactory.setNamespaceAware(true);
            builderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            builderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            builderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            builderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static Document createDocument(String payload, String encoding) throws SAXException, IOException, ParserConfigurationException {
        payload = XMLNS_PATTERN.matcher(payload).replaceAll("");
        DocumentBuilder builder = builderFactory.newDocumentBuilder();
        InputSource iSource = new InputSource(new StringReader(payload));
        LOGGER.debug((Object)("Parsing with the User Specified Encoding =" + encoding));
        if (encoding != null) {
            iSource.setEncoding(encoding);
        }
        return builder.parse(iSource);
    }

    public static XPathExpression prepareXPath(String xPathString, NamespaceContext nsContext) {
        XPath xPath = xpathFactory.newXPath();
        if (nsContext != null) {
            xPath.setNamespaceContext(nsContext);
        }
        try {
            return xPath.compile(xPathString);
        }
        catch (XPathExpressionException e) {
            LOGGER.warn((Object)("The xpath " + xPathString + " doesn't exist."));
            return null;
        }
    }

    public static Node evaluateAsNode(Node parent, String xPathString, NamespaceContext nsContext) throws XPathExpressionException {
        return (Node)XPathUtil.evaluate(parent, xPathString, nsContext, XPathConstants.NODE);
    }

    public static String evaluateAsString(Node parent, String xPathString, NamespaceContext nsContext) throws XPathExpressionException {
        return (String)XPathUtil.evaluate(parent, xPathString, nsContext, XPathConstants.STRING);
    }

    public static NodeList evaluateAsNodeList(Node parent, String xPathString, NamespaceContext nsContext) throws XPathExpressionException {
        return (NodeList)XPathUtil.evaluate(parent, xPathString, nsContext, XPathConstants.NODESET);
    }

    public static String getNodeContent(Node node, AbstractNamespaceContext namespaceContext) throws TransformerException {
        if (node.getNodeValue() != null) {
            return node.getNodeValue();
        }
        StringWriter stringWriter = new StringWriter();
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            Transformer trans = transformerFactory.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "yes");
            StreamResult streamResult = new StreamResult(stringWriter);
            for (int index = 0; index < children.getLength(); ++index) {
                Node child = children.item(index);
                if (namespaceContext != null && child instanceof Element) {
                    Element element = (Element)child;
                    namespaceContext.addNamespacesToNode(element);
                    child = element;
                }
                DOMSource source = new DOMSource(child);
                trans.transform(source, streamResult);
            }
        }
        return stringWriter.toString().trim();
    }

    private static <T> T evaluate(Node parent, String xPathString, NamespaceContext nsContext, QName asType) throws XPathExpressionException {
        XPathExpression compiledPath = XPathUtil.prepareXPath(xPathString, nsContext);
        return (T)(compiledPath == null ? null : compiledPath.evaluate(parent, asType));
    }

    static {
        XPathUtil.disableExternalEntityInjection(builderFactory);
    }
}

