/*
 * Decompiled with CFR 0.152.
 */
package com.konylabs.middleware.connectors.dataadapter;

import com.kony.adapter.exception.DataAdapterException;
import com.kony.adapter.handler.AsyncHandler;
import com.kony.adapter.metadata.model.EntityMetadata;
import com.kony.adapter.model.BinaryContent;
import com.kony.adapter.model.BinaryContextParamType;
import com.kony.adapter.model.BinaryField;
import com.kony.adapter.model.ByteRange;
import com.kony.adapter.model.Entity;
import com.kony.adapter.model.EntityList;
import com.kony.adapter.service.runtime.ServiceData;
import com.kony.adapter.service.runtime.ServiceInput;
import com.kony.adapter.service.runtime.ServiceInputList;
import com.kony.adapter.service.runtime.ServiceInputObject;
import com.kony.adapter.service.runtime.ServiceInputParam;
import com.konylabs.middleware.appservices.common.util.BinaryOperandUtils;
import com.konylabs.middleware.appservices.common.util.UploadFileContainer;
import com.konylabs.middleware.common.BinaryOperandAttributes;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterAsyncHandler;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterData;
import com.konylabs.middleware.connectors.dataadapter.DataAdapterOperand;
import com.konylabs.middleware.dataobject.Dataset;
import com.konylabs.middleware.dataobject.Record;
import com.konylabs.middleware.dataobject.Result;
import com.konylabs.middleware.exceptions.DataAdapterConnectorException;
import com.konylabs.middleware.registry.vo.Param;
import com.konylabs.middleware.utilities.ByteRangeUtil;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

abstract class AbstractOperand<T>
implements DataAdapterOperand {
    private static final Logger LOGGER = Logger.getLogger(AbstractOperand.class);
    private DataAdapterData dataAdapterData;
    private volatile Result result;
    protected DataAdapterAsyncHandler<T> dataAdapterAsyncHandler;
    protected volatile T preparedResult;

    AbstractOperand() {
    }

    public DataAdapterData getDataAdapterData() {
        return this.dataAdapterData;
    }

    public void setDataAdapterData(DataAdapterData dataAdapterData) {
        this.dataAdapterData = dataAdapterData;
    }

    public Result getResult() {
        return this.result;
    }

    @Override
    public void execute(DataAdapterData data, Result results, AsyncHandler<Result> asyncHandler) {
        LOGGER.debug((Object)("Executing " + this.getOperandName()));
        this.dataAdapterData = data;
        this.result = results;
        try {
            LOGGER.debug((Object)("Preparing for execute step for " + this.getOperandName()));
            this.preExecuteStep(this.result, asyncHandler);
            LOGGER.debug((Object)("Calling executeStep for " + this.getOperandName()));
            this.dataAdapterAsyncHandler.startMWMetricsTimer();
            this.executeStep();
        }
        catch (DataAdapterException e) {
            LOGGER.error((Object)("Exception during execution of " + this.getOperandName()), (Throwable)e);
            asyncHandler.onError(e, this.dataAdapterData.getContext());
            return;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Exception during execution of " + this.getOperandName()), (Throwable)e);
            DataAdapterException ex = new DataAdapterException(this.getErrorCode(), e.getMessage(), 500);
            asyncHandler.onError(ex, this.dataAdapterData.getContext());
            return;
        }
    }

    protected Dataset convertEntityListToDataset(EntityList entityList, String name) {
        LOGGER.debug((Object)"Converting the EntityList to Dataset.");
        Dataset dataset = new Dataset();
        dataset.setId(name);
        for (Entity entity : entityList.getEntities()) {
            dataset.addRecord(this.convertEntityToRecord(entity));
        }
        return dataset;
    }

    protected Record convertEntityToRecord(Entity entity) {
        LOGGER.debug((Object)"Converting the Entity to Record.");
        Record rec = new Record();
        rec.setId(entity.getEntityName());
        for (String fieldName : entity.getFieldNames()) {
            rec.addParam(this.setParamValue(entity, fieldName));
        }
        Map relatedEntityMap = entity.getRelatedEntityMap();
        if (relatedEntityMap != null && relatedEntityMap.size() > 0) {
            for (String relatedName : relatedEntityMap.keySet()) {
                rec.addDataset(this.convertEntityListToDataset((EntityList)relatedEntityMap.get(relatedName), relatedName));
            }
        }
        return rec;
    }

    protected com.konylabs.middleware.dataobject.Param setParamValue(Entity entity, String fieldName) {
        com.konylabs.middleware.dataobject.Param outputParam;
        block9: {
            Param inputParam;
            outputParam = new com.konylabs.middleware.dataobject.Param();
            outputParam.setName(fieldName);
            Object fieldValue = entity.getFieldValue(fieldName);
            Param param = inputParam = this.dataAdapterData.getServiceInputParams() != null ? this.dataAdapterData.getServiceInputParams().get(fieldName) : null;
            if (inputParam != null && fieldValue != null) {
                String formatValue = inputParam.getFormatvalue();
                if ("date".equalsIgnoreCase(inputParam.getDataType()) && fieldValue instanceof Date) {
                    try {
                        if (StringUtils.isNotBlank((String)formatValue)) {
                            SimpleDateFormat sdfr = new SimpleDateFormat(formatValue);
                            outputParam.setFormatValue(formatValue);
                            outputParam.setFormat("Date");
                            outputParam.setValue(sdfr.format((Date)fieldValue));
                            break block9;
                        }
                        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(ZoneOffset.UTC));
                        cal.setTime((Date)fieldValue);
                        outputParam.setValue(DatatypeConverter.printDateTime((Calendar)cal));
                    }
                    catch (Exception ex) {
                        LOGGER.error((Object)"Unable to format the value", (Throwable)ex);
                        outputParam.setValue(fieldValue.toString());
                    }
                } else {
                    outputParam.setValue(fieldValue.toString());
                    outputParam.setObjectValue(fieldValue);
                }
            } else if (fieldValue != null) {
                outputParam.setValue(fieldValue.toString());
                outputParam.setObjectValue(fieldValue);
            } else {
                outputParam.setValue((String)fieldValue);
                outputParam.setObjectValue(fieldValue);
            }
        }
        return outputParam;
    }

    protected Entity prepareEntity() throws DataAdapterException {
        Entity entity = this.dataAdapterData.getEntity();
        if (entity == null) {
            entity = this.dataAdapterData.getDataAdapter().createEntity((EntityMetadata)this.dataAdapterData.getMetadata());
            Map<String, Object> inputObjectMap = this.dataAdapterData.getInputMap();
            if (entity != null && inputObjectMap != null) {
                Set<String> fieldKeySet = inputObjectMap.keySet();
                for (String fieldKey : fieldKeySet) {
                    if ("cacheid".equalsIgnoreCase(fieldKey)) continue;
                    Object fieldValue = inputObjectMap.get(fieldKey);
                    if (fieldValue instanceof Dataset) {
                        entity.setRelatedEntities(fieldKey, this.convertDatasettoEntityList((Dataset)inputObjectMap.get(fieldKey)));
                        continue;
                    }
                    entity.setFieldValue(fieldKey, fieldValue);
                }
            }
        }
        return entity;
    }

    protected ServiceInput prepareGenericInputCollection() throws DataAdapterException {
        ServiceInput serviceInput;
        Map<String, Object> inputObjectMap = this.dataAdapterData.getInputMap();
        if (this.dataAdapterData.getInputMap() == null || this.dataAdapterData.getInputMap().isEmpty()) {
            serviceInput = (ServiceInput)this.dataAdapterData.getServiceData();
        } else {
            Set<String> fieldKeySet = inputObjectMap.keySet();
            serviceInput = new ServiceInputObject();
            for (String fieldKey : fieldKeySet) {
                Object fieldValue = inputObjectMap.get(fieldKey);
                this.prepareInputCollectionRecursive(fieldKey, fieldValue, serviceInput);
            }
        }
        return serviceInput;
    }

    void prepareInputCollectionRecursive(String fieldKey, Object fieldValue, ServiceInput serviceInput) {
        if (fieldValue instanceof Dataset) {
            Dataset dataSet = (Dataset)fieldValue;
            ServiceInputList serviceInputList = new ServiceInputList(dataSet.getId());
            for (Record record : dataSet.getAllRecords()) {
                this.prepareInputCollectionRecursive(dataSet.getId(), record, (ServiceInput)serviceInputList);
            }
            serviceInput.addParamRecordDataset((ServiceData)serviceInputList);
        } else if (fieldValue instanceof Record) {
            Record record = (Record)fieldValue;
            ServiceInputObject serviceInputObject = new ServiceInputObject(record.getId());
            for (com.konylabs.middleware.dataobject.Param param : record.getAllParams()) {
                this.prepareInputCollectionRecursive(record.getId(), param, (ServiceInput)serviceInputObject);
            }
            for (Record innerRecord : record.getAllRecords()) {
                this.prepareInputCollectionRecursive(record.getId(), innerRecord, (ServiceInput)serviceInputObject);
            }
            for (Dataset innerDataSet : record.getAllDatasets()) {
                this.prepareInputCollectionRecursive(record.getId(), innerDataSet, (ServiceInput)serviceInputObject);
            }
            serviceInput.addParamRecordDataset((ServiceData)serviceInputObject);
        } else if (fieldValue instanceof com.konylabs.middleware.dataobject.Param) {
            com.konylabs.middleware.dataobject.Param param = (com.konylabs.middleware.dataobject.Param)fieldValue;
            serviceInput.addParamRecordDataset((ServiceData)new ServiceInputParam(param.getName(), param.getObjectValue()));
        } else {
            serviceInput.addParamRecordDataset((ServiceData)new ServiceInputParam(fieldKey, fieldValue));
        }
    }

    private EntityList convertDatasettoEntityList(Dataset dataset) throws DataAdapterException {
        EntityList entityList = new EntityList();
        for (Record record : dataset.getAllRecords()) {
            entityList.addEntity(this.convertRecordToEntity(record));
        }
        return entityList;
    }

    protected Entity convertRecordToEntity(Record entityRecordValue) throws DataAdapterException {
        LOGGER.debug((Object)"Converting the Record to Entity");
        EntityMetadata entityMetadata = null;
        if (!this.dataAdapterData.getRelatedEntityMetadataMap().containsKey(entityRecordValue.getId())) {
            String errorMessage = DataAdapterConnectorException.getErrorCodeMessage(DataAdapterConnectorException.METADATA_NOT_FOUND);
            errorMessage = MessageFormat.format(errorMessage, entityRecordValue.getId());
            LOGGER.error((Object)errorMessage);
            throw new DataAdapterException(DataAdapterConnectorException.METADATA_NOT_FOUND, errorMessage);
        }
        entityMetadata = this.dataAdapterData.getRelatedEntityMetadataMap().get(entityRecordValue.getId());
        Entity entity = this.dataAdapterData.getDataAdapter().createEntity(entityMetadata);
        for (com.konylabs.middleware.dataobject.Param param : entityRecordValue.getAllParams()) {
            entity.setFieldValue(param.getName(), (Object)param.getValue());
        }
        for (Dataset dataset : entityRecordValue.getAllDatasets()) {
            entity.setRelatedEntities(dataset.getId(), this.convertDatasettoEntityList(dataset));
        }
        return entity;
    }

    protected BinaryField prepareBinaryField() throws DataAdapterException {
        String outputDataType;
        LOGGER.debug((Object)"Preparing binary field");
        Map<String, Object> inputObjectMap = this.dataAdapterData.getInputMap();
        BinaryField binaryField = new BinaryField();
        binaryField.setEntityMetadata((EntityMetadata)this.dataAdapterData.getMetadata());
        if (inputObjectMap != null) {
            for (Map.Entry<String, Object> param : inputObjectMap.entrySet()) {
                String paramName = param.getKey();
                Object fieldValue = inputObjectMap.get(paramName);
                if (fieldValue == null) continue;
                if (BinaryOperandAttributes.data.name().equals(paramName)) {
                    UploadFileContainer uploadContainer = BinaryOperandUtils.getUploadedFileDataField(fieldValue, this.dataAdapterData);
                    this.createBinaryContent(binaryField, uploadContainer.getFieldValue(), uploadContainer.getContentType());
                    continue;
                }
                if ("fieldName".equalsIgnoreCase(paramName)) {
                    binaryField.setName((String)fieldValue);
                    continue;
                }
                if ("fileName".equalsIgnoreCase(paramName)) {
                    binaryField.getBinaryContext().put(BinaryContextParamType.FILENAME, fieldValue);
                    continue;
                }
                binaryField.setAttribute(paramName, fieldValue);
            }
        }
        if ("bytes".equalsIgnoreCase(outputDataType = this.getBinaryResponseType())) {
            binaryField.setRequestType(BinaryContent.BINARY_CONTENT_TYPE.STREAM);
            String rangeHeader = this.dataAdapterData.getDataControllerRequest().getHeader("Range");
            if (rangeHeader != null) {
                if (ByteRangeUtil.isRangeValid(rangeHeader)) {
                    LOGGER.debug((Object)("Range values sent by client:" + rangeHeader));
                    List<ByteRange> byteRange = ByteRangeUtil.getStartAndEndPosition(rangeHeader);
                    binaryField.setByteRange(byteRange);
                } else {
                    LOGGER.error((Object)"Range is invalid ");
                    throw new DataAdapterException("Unsupported Range header value");
                }
            }
        }
        return binaryField;
    }

    protected String getBinaryResponseType() {
        return this.dataAdapterData.getDataControllerRequest().getParameter("type") == null ? (String)this.dataAdapterData.getInputMap().get("type") : this.dataAdapterData.getDataControllerRequest().getParameter("type");
    }

    protected void createBinaryContent(BinaryField binaryField, Object fieldValue, BinaryContent.BINARY_CONTENT_TYPE contentType) throws DataAdapterException {
        LOGGER.debug((Object)"Creating binary content.");
        BinaryContent binaryContent = this.getDataAdapterData().getDataAdapter().getBinaryAdapter().createBinaryContent(fieldValue, contentType);
        binaryField.setContent(binaryContent);
    }

    protected void setDatasetToResult(Result result, Entity entity) {
        LOGGER.debug((Object)"Setting dataset to result.");
        EntityList entityList = new EntityList();
        entityList.addEntity(entity);
        result.addDataset(this.convertEntityListToDataset(entityList, this.dataAdapterData.getMetadata().getName()));
    }

    protected void setResultParamString(String key, String value) {
        this.result.addParam(new com.konylabs.middleware.dataobject.Param(key, value, "string"));
    }

    protected void setResultParamInt(String key, String value) {
        this.result.addParam(new com.konylabs.middleware.dataobject.Param(key, value, "int"));
    }

    protected abstract void preExecuteStep(Result var1, AsyncHandler<Result> var2) throws DataAdapterException;

    protected abstract void executeStep() throws DataAdapterException;

    protected abstract void processResults(T var1) throws DataAdapterException;

    protected abstract String getOperandName();

    protected abstract String getErrorCode();
}

